/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.threshold;

import com.atlassian.jira.issue.Issue;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdUpdateContext;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdExceeded;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdsExceededEvent;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SlaThresholdsExceededEventImpl
implements SlaThresholdsExceededEvent {
    private final Issue issue;
    private final Collection<SlaThresholdExceeded> thresholdsExceeded;
    private final Date eventTime;

    public SlaThresholdsExceededEventImpl(SlaThresholdUpdateContext slaThresholdUpdateContext, Date eventTime) {
        this.issue = slaThresholdUpdateContext.getIssue();
        this.thresholdsExceeded = ImmutableList.copyOf(slaThresholdUpdateContext.getSlaThresholdsExceeded());
        this.eventTime = eventTime;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public Collection<SlaThresholdExceeded> getThresholdsExceeded() {
        return this.thresholdsExceeded;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("issue= [id:" + this.issue.getId() + ", key:" + this.issue.getKey() + "]");
        builder.append(", thresholdsExceeded=");
        for (SlaThresholdExceeded slaThresholdExceeded : this.thresholdsExceeded) {
            builder.append(" [timemetric=[name:" + slaThresholdExceeded.getTimeMetric().getName() + "]");
            builder.append(",[thresholds=");
            for (SlaThreshold slaThreshold : slaThresholdExceeded.getThresholds()) {
                builder.append("[threshold=[remainingTime=" + slaThreshold.getRemainingTime() + "]");
            }
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public Date getTime() {
        return this.eventTime;
    }
}

