/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.task;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.internal.sla.task.OutdatedIssueFinder;
import com.atlassian.servicedesk.internal.sla.task.SlaConsistencyCheckState;
import com.atlassian.servicedesk.internal.sla.task.SlaConsistencyCheckStatus;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyManager;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyService;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyState;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaDataConsistencyServiceImpl
implements SlaDataConsistencyService {
    private static final Logger log = LoggerFactory.getLogger(SlaDataConsistencyServiceImpl.class);
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private SlaDataConsistencyManager slaDataConsistencyManager;
    @Autowired
    OutdatedIssueFinder outdatedIssueFinder;
    @Autowired
    TimeMetricManager timeMetricManager;

    @Override
    public SlaDataConsistencyState getSLADataConsistencyState(ApplicationUser user, ServiceDesk serviceDesk) {
        long total = this.outdatedIssueFinder.getServiceDeskIssueCount(serviceDesk);
        long outdated = this.outdatedIssueFinder.getOutdatedServiceDeskIssueCount(user, serviceDesk);
        SlaConsistencyCheckStatus consistencyCheckStatus = this.slaDataConsistencyManager.getConsistencyCheckStatus(serviceDesk);
        boolean upToDate = outdated == 0L;
        boolean queued = consistencyCheckStatus.getConsistencyCheckState() != SlaConsistencyCheckState.NOT_RUNNING;
        return new SlaDataConsistencyState(total, outdated, upToDate, queued, consistencyCheckStatus);
    }

    @Override
    public SlaConsistencyCheckStatus getConsistencyCheckStatus(ApplicationUser user, ServiceDesk serviceDesk) {
        return this.slaDataConsistencyManager.getConsistencyCheckStatus(serviceDesk);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, SlaConsistencyCheckStatus> requestConsistencyCheck(ApplicationUser user, ServiceDesk serviceDesk, Option<SlaAuditLogReason> reason) {
        boolean projectAdmin = this.permissionService.canManageSlas(user, serviceDesk);
        if (!projectAdmin) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.consistency.service.permission.error", (Object[])new Object[0]));
        }
        SlaConsistencyCheckStatus info = this.slaDataConsistencyManager.requestConsistencyCheck(user, serviceDesk, reason);
        return io.atlassian.fugue.Either.right((Object)info);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> cancelConsistencyCheck(ApplicationUser user, ServiceDesk serviceDesk) {
        boolean projectAdmin = this.permissionService.canManageSlas(user, serviceDesk);
        if (!projectAdmin) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.consistency.service.permission.error", (Object[])new Object[0]));
        }
        this.slaDataConsistencyManager.cancelConsistencyCheck(serviceDesk);
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public void forceOverallConsistencyCheck(ApplicationUser user, ServiceDesk serviceDesk) {
        List<TimeMetric> timeMetrics = this.timeMetricManager.getTimeMetrics(serviceDesk);
        if (timeMetrics != null && !timeMetrics.isEmpty()) {
            for (TimeMetric timeMetric : timeMetrics) {
                this.timeMetricManager.updateDefinitionChangeDateAndMsEpoch(timeMetric).left().foreach(errorCollection -> log.warn("Failed to update definition change data and ms from epoch values in Time Metric table for {} : {}", (Object)timeMetric.getId(), errorCollection));
            }
        }
        this.requestConsistencyCheck(user, serviceDesk, (Option<SlaAuditLogReason>)Option.some((Object)((Object)SlaAuditLogReason.FORCED_CONSISTENCY_CHECK)));
    }
}

