/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.task;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskCompletionCallback;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskManager;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskProgress;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskStartedResult;
import com.atlassian.servicedesk.internal.sla.task.SlaConsistencyCheckState;
import com.atlassian.servicedesk.internal.sla.task.SlaConsistencyCheckStatus;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaDataConsistencyManagerImpl
implements SlaDataConsistencyManager,
ConsistencyTaskCompletionCallback {
    private static final Logger log = LoggerFactory.getLogger(SlaDataConsistencyManagerImpl.class);
    private final ConsistencyTaskManager consistencyTaskManager;
    private final ProjectManager projectManager;
    private final List<QueueEntry> queue;
    private QueueEntry currentEntry;

    @Autowired
    public SlaDataConsistencyManagerImpl(ConsistencyTaskManager consistencyTaskManager, ProjectManager projectManager) {
        this.consistencyTaskManager = consistencyTaskManager;
        this.projectManager = projectManager;
        this.queue = new LinkedList<QueueEntry>();
        this.currentEntry = null;
    }

    @Override
    public synchronized SlaConsistencyCheckStatus getConsistencyCheckStatus(ServiceDesk serviceDesk) {
        QueueEntry entry = this.findByServiceDesk(serviceDesk);
        if (entry == null) {
            return new SlaConsistencyCheckStatus(SlaConsistencyCheckState.NOT_RUNNING, 100);
        }
        if (entry.taskId == null) {
            return new SlaConsistencyCheckStatus(SlaConsistencyCheckState.RUN_REQUESTED, 0);
        }
        Either<ErrorCollection, ConsistencyTaskProgress> consistencyTaskProgress = this.consistencyTaskManager.getConsistencyTaskProgress(entry.taskId);
        if (consistencyTaskProgress.isLeft()) {
            return new SlaConsistencyCheckStatus(SlaConsistencyCheckState.NOT_RUNNING, null);
        }
        return new SlaConsistencyCheckStatus(SlaConsistencyCheckState.IN_PROGRESS, (int)((ConsistencyTaskProgress)consistencyTaskProgress.right().get()).percentageComplete);
    }

    @Override
    public synchronized SlaConsistencyCheckStatus requestConsistencyCheck(ApplicationUser user, ServiceDesk serviceDesk, Option<SlaAuditLogReason> reason) {
        this.cancelConsistencyCheck(serviceDesk);
        Project project = this.projectManager.getProjectObj(Long.valueOf(serviceDesk.getProjectId()));
        QueueEntry newEntry = new QueueEntry();
        newEntry.user = user;
        newEntry.project = project;
        newEntry.serviceDesk = serviceDesk;
        this.queue.add(newEntry);
        this.startTask(reason);
        return this.getConsistencyCheckStatus(serviceDesk);
    }

    @Override
    public synchronized void cancelConsistencyCheck(ServiceDesk serviceDesk) {
        if (this.currentEntry != null && this.currentEntry.serviceDesk.equals(serviceDesk)) {
            this.cancelTask();
        }
        this.removeFromQueueList(serviceDesk);
    }

    @Override
    public synchronized void taskComplete(ServiceDesk serviceDesk, Long taskId, Option<SlaAuditLogReason> reason) {
        if (this.currentEntry == null || !this.currentEntry.taskId.equals(taskId)) {
            log.warn("Task completed, but not known as the currently running task.");
            return;
        }
        this.currentEntry = null;
        this.startTask(reason);
    }

    private QueueEntry findByServiceDesk(ServiceDesk serviceDesk) {
        if (this.currentEntry != null && this.currentEntry.serviceDesk.equals(serviceDesk)) {
            return this.currentEntry;
        }
        for (QueueEntry entry : this.queue) {
            if (!entry.serviceDesk.equals(serviceDesk)) continue;
            return entry;
        }
        return null;
    }

    private void removeFromQueueList(ServiceDesk serviceDesk) {
        Iterator<QueueEntry> it = this.queue.iterator();
        while (it.hasNext()) {
            QueueEntry next = it.next();
            if (!next.serviceDesk.equals(serviceDesk)) continue;
            it.remove();
        }
    }

    private void startTask(Option<SlaAuditLogReason> reason) {
        if (this.currentEntry != null) {
            return;
        }
        if (this.queue.isEmpty()) {
            return;
        }
        QueueEntry newCurrent = this.queue.remove(0);
        ConsistencyTaskStartedResult result = this.consistencyTaskManager.runConsistencyTask(newCurrent.user, newCurrent.project, newCurrent.serviceDesk, this, reason);
        newCurrent.taskId = result.getTaskId();
        this.currentEntry = newCurrent;
    }

    private void cancelTask() {
        if (this.currentEntry == null) {
            return;
        }
        Long taskId = this.currentEntry.taskId;
        this.consistencyTaskManager.cancelConsistencyTask(taskId);
    }

    private static class QueueEntry {
        ApplicationUser user;
        Project project;
        ServiceDesk serviceDesk;
        Long taskId;

        private QueueEntry() {
        }
    }
}

