/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.task;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.GenericTaskContext;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.task.TaskProgressIndicator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractor;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTask;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskCompletionCallback;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskManager;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskProgress;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskResult;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskStartedResult;
import com.atlassian.servicedesk.internal.sla.task.OutdatedIssueFinder;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsistencyTaskManagerImpl
implements ConsistencyTaskManager {
    @Autowired
    private I18nHelper.BeanFactory i18nFactory;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private OutdatedIssueFinder outdatedIssueFinder;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private MetricStateHistoryExtractor metricStateHistoryExtractor;
    @Autowired
    private IssueIndexManager issueIndexManager;

    @Override
    public ConsistencyTaskStartedResult runConsistencyTask(ApplicationUser user, Project project, ServiceDesk sd, ConsistencyTaskCompletionCallback consistencyTaskCompletionCallback, Option<SlaAuditLogReason> reason) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        ConsistencyTask task = new ConsistencyTask(user, i18n, this.metricStateHistoryExtractor, this.issueManager, this.outdatedIssueFinder, consistencyTaskCompletionCallback, project, sd, this.issueIndexManager, reason);
        String baseProgressUrl = this.makeBaseProgressUrl(project.getKey());
        String taskContextUrl = baseProgressUrl + "/?id=" + UUID.randomUUID().toString();
        GenericTaskContext taskContext = new GenericTaskContext(taskContextUrl, "com.atlassian.servicedesk.internal.sla.task");
        String taskDesc = i18n.getText("sd.sla.configuration.slas.update.task", project.getKey());
        this.taskManager.getLiveTasks().stream().filter(td -> this.isConsistencyTaskOfSameProject(td.getTaskContext(), baseProgressUrl)).findFirst().ifPresent(td -> this.cancelConsistencyTask(td.getTaskId()));
        TaskDescriptor taskDescriptor = this.taskManager.submitTask((Callable)task, taskDesc, (TaskContext)taskContext, true);
        ConsistencyTaskStartedResult result = new ConsistencyTaskStartedResult();
        result.serviceDesk = sd;
        result.progress = new ConsistencyTaskProgress(taskDescriptor.getTaskId(), 0L);
        result.taskId = taskDescriptor.getTaskId();
        return result;
    }

    private boolean isConsistencyTaskOfSameProject(TaskContext taskContext, String baseProgressUrl) {
        if (taskContext instanceof GenericTaskContext) {
            GenericTaskContext genericTaskContext = (GenericTaskContext)taskContext;
            return genericTaskContext.getTaskContextName().equals("com.atlassian.servicedesk.internal.sla.task") && baseProgressUrl.equals(genericTaskContext.buildProgressURL(Long.valueOf(0L)));
        }
        return false;
    }

    private String makeBaseProgressUrl(String projectKey) {
        return "/rest/servicedesk/1.0/servicedesk/" + projectKey + "/sla/consistency";
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> cancelConsistencyTask(long taskId) {
        TaskDescriptor taskDescriptor = this.taskManager.getTask(Long.valueOf(taskId));
        if (taskDescriptor == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.time.metric.service.update.task-not-found", (Object[])new Object[0]));
        }
        this.taskManager.cancelTask(Long.valueOf(taskId));
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, ConsistencyTaskProgress> getConsistencyTaskProgress(long taskId) {
        TaskProgressEvent lastProgressEvent;
        TaskDescriptor taskDescriptor = this.taskManager.getTask(Long.valueOf(taskId));
        if (taskDescriptor == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.time.metric.service.update.task-not-found", (Object[])new Object[0]));
        }
        TaskContext context = taskDescriptor.getTaskContext();
        if (!(context instanceof GenericTaskContext) || !"com.atlassian.servicedesk.internal.sla.task".equals(((GenericTaskContext)context).getTaskContextName())) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR, (String)"sd.time.metric.service.update.task-not-found", (Object[])new Object[0]));
        }
        TaskProgressIndicator taskProgressIndicator = taskDescriptor.getTaskProgressIndicator();
        long migratedIssueCount = 0L;
        if (taskProgressIndicator != null && (lastProgressEvent = taskProgressIndicator.getLastProgressEvent()) != null) {
            migratedIssueCount = lastProgressEvent.getTaskProgress();
        }
        if (!taskDescriptor.isFinished()) {
            return io.atlassian.fugue.Either.right((Object)new ConsistencyTaskProgress(taskId, migratedIssueCount));
        }
        HashMap rawMigrationResult = (HashMap)taskDescriptor.getResult();
        ConsistencyTaskResult migrationResult = this.convertRawResultToConsistencyTaskResult(rawMigrationResult);
        return io.atlassian.fugue.Either.right((Object)new ConsistencyTaskProgress(taskId, migratedIssueCount, true, migrationResult.isMigrationSucceeded()));
    }

    private ConsistencyTaskResult convertRawResultToConsistencyTaskResult(HashMap<String, Serializable> rawMigrationResult) {
        return new ConsistencyTaskResult((Boolean)rawMigrationResult.get("migrationSucceeded"), (Integer)rawMigrationResult.get("numberOfMigratedIssues"));
    }
}

