/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher.sorter;

import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.api.sla.searcher.SlaCycleState;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRange;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeOrderingIndexData;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeSortingData;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.SlaOrderingCalculationService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaOrderingCalculationServiceImpl
implements SlaOrderingCalculationService {
    private final Log log = Log.with(this.getClass());
    @Autowired
    private GoalManager goalManager;
    @Autowired
    private CalendarReferenceManager calendarReferenceManager;

    @Override
    public RemainingTimeSortingData getRemainingTimeSortingData(RemainingTimeOrderingIndexData data, DateTime now) {
        if (data == null) {
            return null;
        }
        RemainingTimeSortingData sortingData = new RemainingTimeSortingData();
        SlaCycleState slaCycleState = SlaCycleState.forIndexValue((String)data.cycleState);
        if (slaCycleState == null) {
            return null;
        }
        sortingData.slaCycleState = slaCycleState;
        switch (slaCycleState) {
            case PAUSED: {
                sortingData.remainingTime = data.remainingTime;
                break;
            }
            case COMPLETED: {
                break;
            }
            case RUNNING: {
                DateTimeRange dateTimeRange = new DateTimeRange(new DateTime((Object)data.shiftedStartDate), now);
                Option<Long> longOption = this.calculateOngoingRemainingTime(dateTimeRange.toInterval(), data.goalId);
                if (longOption.isEmpty()) {
                    return null;
                }
                sortingData.remainingTime = (Long)longOption.get();
                break;
            }
            default: {
                return null;
            }
        }
        return sortingData;
    }

    private Option<Long> calculateOngoingRemainingTime(Interval interval, Integer goalId) {
        Either<ErrorCollection, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal> goalResult = this.goalManager.getGoal(goalId);
        if (goalResult.isLeft()) {
            this.log.debug("Error while ordering issues: cannot get goal with id '%d' : %s", new Object[]{goalId, goalResult.left().get()});
            return Option.none();
        }
        com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal = (com.atlassian.servicedesk.internal.sla.configuration.goal.Goal)((Object)goalResult.right().get());
        if (!goal.hasDuration()) {
            this.log.debug("Error while ordering issues: goal with id '%d' does not have any duration defined.", new Object[]{goalId});
            return Option.none();
        }
        WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForGoal((Goal)goal);
        long workedDuration = this.getDuration(calculator.getActiveRanges(interval));
        return Option.some((Object)(goal.getDuration() - workedDuration));
    }

    private long getDuration(List<Interval> intervals) {
        long duration = 0L;
        for (Interval interval : intervals) {
            duration += interval.getEndMillis() - interval.getStartMillis();
        }
        return duration;
    }
}

