/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher.sorter;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.sla.customfield.SLAValueSerializer;
import com.atlassian.servicedesk.internal.sla.searcher.SLACustomFieldIndexer;
import com.atlassian.servicedesk.internal.sla.searcher.SlaJqlQueryingHelper;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeComparator;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeOrderingIndexData;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeSortingData;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Suppliers;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class RemainingTimeSorter
implements LuceneFieldSorter<RemainingTimeSortingData> {
    private static final Log log = Log.with(RemainingTimeSorter.class);
    private static final SLAValueSerializer SERIALIZER = new SLAValueSerializer();
    private static final RemainingTimeComparator REMAINING_TIME_COMPARATOR = new RemainingTimeComparator();
    private final Supplier<List<Integer>> allVisibleTimeMetricIdsSupplier;
    private final String customFieldId;
    private final DateTime now;
    private final boolean slaAgentSecurityFeatureEnabled;

    public RemainingTimeSorter(ApplicationUser applicationUser, CustomField customField, SlaJqlQueryingHelper slaJqlQueryingHelper, FeatureManager featureManager) {
        this.customFieldId = customField.getId();
        this.slaAgentSecurityFeatureEnabled = featureManager.isEnabled(SDFeatureFlags.SLA_JQL_AGENT_SECURITY_RESTRICTED);
        this.allVisibleTimeMetricIdsSupplier = Suppliers.memoize(() -> ImmutableList.copyOf(slaJqlQueryingHelper.getAllVisibleTimeMetricIdsForSlaQuerying(applicationUser, customField)));
        this.now = DateTime.now();
    }

    public String getDocumentConstant() {
        return SLACustomFieldIndexer.getOrderByFieldId(this.customFieldId);
    }

    public RemainingTimeSortingData getValueFromLuceneField(String documentValue) {
        RemainingTimeOrderingIndexData data = SERIALIZER.unserializeOrderingData(documentValue);
        if (data == null || this.slaAgentSecurityFeatureEnabled && !this.allVisibleTimeMetricIdsSupplier.get().contains(data.metricId)) {
            return null;
        }
        RemainingTimeSortingData sortingData = ServiceDeskComponentAccessor.slaOrderingCalculationService().getRemainingTimeSortingData(data, this.now);
        if (sortingData == null) {
            log.warn("Invalid order-by data '%s'", new Object[]{data});
        }
        return sortingData;
    }

    public Comparator<RemainingTimeSortingData> getComparator() {
        return REMAINING_TIME_COMPARATOR;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemainingTimeSorter that = (RemainingTimeSorter)o;
        return this.slaAgentSecurityFeatureEnabled == that.slaAgentSecurityFeatureEnabled && Objects.equals(this.customFieldId, that.customFieldId) && Objects.equals(this.now, that.now) && Objects.equals(this.allVisibleTimeMetricIdsSupplier, that.allVisibleTimeMetricIdsSupplier);
    }

    public int hashCode() {
        return Objects.hash(this.customFieldId, this.now, this.slaAgentSecurityFeatureEnabled, this.allVisibleTimeMetricIdsSupplier);
    }
}

