/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher.function;

import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.servicedesk.internal.api.sla.searcher.SlaCycleState;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class SlaJqlFunctionHelper {
    private static final Set<String> STATEFUL_FUNCTIONS = Sets.newHashSet((Object[])new String[]{"running", "paused", "completed"});

    public static Set<SlaCycleState> getCycles(Operand operand) {
        HashSet result = Sets.newHashSet();
        if (!SlaJqlFunctionHelper.isStateFunctionOperand(operand)) {
            return result;
        }
        String name = operand.getName();
        if ("running".equals(name)) {
            result.add(SlaCycleState.RUNNING);
        } else if ("paused".equals(name)) {
            result.add(SlaCycleState.PAUSED);
        } else if ("completed".equals(name)) {
            result.add(SlaCycleState.COMPLETED);
        }
        return result;
    }

    public static boolean isEverBreachedFunctionOperand(Operand operand) {
        return operand instanceof FunctionOperand && "everBreached".equals(operand.getName());
    }

    public static boolean isBreachedFunctionOperand(Operand operand) {
        return operand instanceof FunctionOperand && "breached".equals(operand.getName());
    }

    public static boolean isStateFunctionOperand(Operand operand) {
        if (!(operand instanceof FunctionOperand)) {
            return false;
        }
        return STATEFUL_FUNCTIONS.contains(operand.getName());
    }

    public static boolean isWithinCalendarHoursOperand(Operand operand) {
        return operand instanceof FunctionOperand && "withinCalendarHours".equals(operand.getName());
    }

    public static boolean isRawValueOrRemainingTimeFunctionOperand(Operand operand) {
        boolean isFunction = operand instanceof FunctionOperand;
        return !isFunction || SlaJqlFunctionHelper.isRemainingTimeFunctionOperand(operand);
    }

    public static boolean isRemainingTimeFunctionOperand(Operand operand) {
        return operand instanceof FunctionOperand && "remaining".equals(operand.getName());
    }

    public static boolean isElapsedTimeFunctionOperand(Operand operand) {
        return operand instanceof FunctionOperand && "elapsed".equals(operand.getName());
    }
}

