/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.ao.dao.AbstractModel;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class SlaJqlQueryingHelper {
    private final TimeMetricManager timeMetricManager;
    private final InternalServiceDeskService internalServiceDeskService;
    private final UserFactory userFactory;

    @Autowired
    public SlaJqlQueryingHelper(TimeMetricManager timeMetricManager, InternalServiceDeskService internalServiceDeskService, UserFactory userFactory) {
        this.timeMetricManager = timeMetricManager;
        this.internalServiceDeskService = internalServiceDeskService;
        this.userFactory = userFactory;
    }

    public List<Integer> getAllVisibleTimeMetricIdsForSlaQuerying(ApplicationUser user, CustomField customField) {
        Either userEither = this.userFactory.wrap(user);
        if (userEither.isLeft()) {
            return Collections.emptyList();
        }
        List allServiceDeskVisibleAsAgent = this.internalServiceDeskService.getAllServiceDeskVisibleAsAgent((CheckedUser)userEither.right().get());
        return this.timeMetricManager.getAllTimeMetricByCustomFieldForServiceDesks(customField, allServiceDeskVisibleAsAgent).stream().map(AbstractModel::getId).collect(Collectors.toList());
    }
}

