/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher;

import io.atlassian.fugue.Option;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class SlaDurationParser {
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    private static final String MINUTE_DELIMITER = "m";
    private static final String HOUR_DELIMITER = "h";
    private static final String ALL_DELIMITERS = "hm";

    public static Option<Long> parseDuration(String value) {
        String durationStr = StringUtils.trimToEmpty((String)value).toLowerCase();
        if (durationStr.isEmpty()) {
            return Option.none();
        }
        if (durationStr.equals("0")) {
            return Option.some((Object)0L);
        }
        long duration = 0L;
        StringTokenizer st = new StringTokenizer(durationStr, ALL_DELIMITERS, true);
        while (st.hasMoreTokens()) {
            try {
                int numericValue = Integer.parseInt(st.nextToken().trim());
                if (st.hasMoreTokens()) {
                    String delimiter = st.nextToken();
                    if (delimiter.equals(HOUR_DELIMITER)) {
                        duration += (long)numericValue * 3600000L;
                        continue;
                    }
                    if (delimiter.equals(MINUTE_DELIMITER)) {
                        duration += (long)numericValue * 60000L;
                        continue;
                    }
                    return Option.none();
                }
                return Option.none();
            }
            catch (NumberFormatException e) {
                return Option.none();
            }
        }
        return Option.some((Object)duration);
    }
}

