/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.api.sla.searcher.SlaCycleState;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaConditionBuilder;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilder;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilderFactory;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRange;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRangeList;
import com.atlassian.servicedesk.internal.sla.searcher.SlaClauseQueryGenerationService;
import com.atlassian.servicedesk.internal.sla.searcher.SlaJqlQueryingHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaClauseQueryGenerationServiceImpl
implements SlaClauseQueryGenerationService {
    private static final Log log = Log.with(SlaClauseQueryGenerationServiceImpl.class);
    private static final List<Long> ZERO_LIST = ImmutableList.of((Object)0L);
    private final TimeMetricManager timeMetricManager;
    private final GoalManager goalManager;
    private final CalendarReferenceManager calendarReferenceManager;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final SlaQueryBuilderFactory slaQueryBuilderFactory;
    private final FeatureManager featureManager;
    private final SlaJqlQueryingHelper slaJqlQueryingHelper;

    @Autowired
    public SlaClauseQueryGenerationServiceImpl(TimeMetricManager timeMetricManager, GoalManager goalManager, CalendarReferenceManager calendarReferenceManager, I18nHelper.BeanFactory i18nHelperFactory, SlaQueryBuilderFactory slaQueryBuilderFactory, FeatureManager featureManager, SlaJqlQueryingHelper slaJqlQueryingHelper) {
        this.timeMetricManager = timeMetricManager;
        this.goalManager = goalManager;
        this.calendarReferenceManager = calendarReferenceManager;
        this.i18nHelperFactory = i18nHelperFactory;
        this.slaQueryBuilderFactory = slaQueryBuilderFactory;
        this.featureManager = featureManager;
        this.slaJqlQueryingHelper = slaJqlQueryingHelper;
    }

    @Override
    public QueryFactoryResult getQueryForElapsedTime(ApplicationUser user, CustomField field, DateTime now, Operator operator, long duration) {
        SlaQueryBuilder builder = this.slaQueryBuilderFactory.newBuilder(field);
        builder.or();
        builder.sub().and().slaCycleState(SlaCycleState.PAUSED).elapsedTime().applyOperator(SlaClauseQueryGenerationServiceImpl.convertOperator(operator)).number(duration).endSub();
        builder.sub().and().slaCycleState(SlaCycleState.RUNNING);
        builder.sub().or();
        for (GoalCalendarGroup goalCalendarGroup : this.groupGoalsByCalendar(field)) {
            WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForReference(goalCalendarGroup.calendarReference);
            Option<DateTime> targetDate = this.getTargetDate(calculator, now, -duration);
            if (targetDate.isDefined()) {
                builder.sub().and().goalId(goalCalendarGroup.goalIds).shiftedStartDate().applyOperator(SlaClauseQueryGenerationServiceImpl.reverseOperator(operator)).date((DateTime)targetDate.get()).endSub();
                continue;
            }
            log.warn("Calendar '%s' with id %s did not return a valid target date for %s + %d", new Object[]{goalCalendarGroup.calendarReference.getName(this.i18nHelperFactory.getInstance(user)), goalCalendarGroup.calendarReference.getId(), now, -duration});
        }
        builder.endSub();
        builder.endSub();
        return new QueryFactoryResult(builder.build());
    }

    @Override
    public QueryFactoryResult getQueryForRemainingTime(ApplicationUser user, CustomField field, DateTime now, Operator operator, List<Long> durations) {
        Query query = this.getRemainingTimeQuery(user, field, now, operator, durations);
        return new QueryFactoryResult(query);
    }

    private Query getRemainingTimeQuery(ApplicationUser user, CustomField field, DateTime now, Operator operator, List<Long> durations) {
        boolean multipleValues;
        Assertions.containsNoNulls((String)"durations", (Iterable)Assertions.notEmpty((String)"durations", durations));
        SlaQueryBuilder builder = this.slaQueryBuilderFactory.newBuilder(field);
        boolean bl = multipleValues = durations.size() > 1;
        if (multipleValues) {
            if (this.isPositiveOperator(operator)) {
                builder.or();
            } else {
                builder.and();
            }
        } else {
            builder.or();
        }
        for (long duration : durations) {
            if (multipleValues) {
                builder.sub().or();
            }
            builder.sub().and().slaCycleState(SlaCycleState.PAUSED).remainingTime().applyOperator(SlaClauseQueryGenerationServiceImpl.convertOperator(operator)).number(duration).endSub();
            builder.sub().and().slaCycleState(SlaCycleState.RUNNING);
            builder.sub().or();
            for (GoalCalendarAndDurationGroup goalCalendarGroup : this.groupGoalsByCalendarAndDuration(field)) {
                WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForReference(goalCalendarGroup.calendarReference);
                Option<DateTime> targetDate = this.getTargetDate(calculator, now, duration - goalCalendarGroup.goalDuration);
                if (targetDate.isDefined()) {
                    builder.sub().and().goalId(goalCalendarGroup.goalIds).shiftedStartDate().applyOperator(SlaClauseQueryGenerationServiceImpl.convertOperator(operator)).date((DateTime)targetDate.get()).endSub();
                    continue;
                }
                log.warn("Calendar '%s' with id %s did not return a valid target date for %s + %d", new Object[]{goalCalendarGroup.calendarReference.getName(this.i18nHelperFactory.getInstance(user)), goalCalendarGroup.calendarReference.getId(), now, duration - goalCalendarGroup.goalDuration});
            }
            builder.endSub();
            builder.endSub();
            if (!multipleValues) continue;
            builder.endSub();
        }
        return builder.build();
    }

    @Override
    public QueryFactoryResult getQueryForEverBreached(ApplicationUser user, CustomField field, DateTime now, Operator operator) {
        boolean isPositiveQuery = this.isPositiveOperator(operator);
        if (isPositiveQuery) {
            return this.generateEverBreached(user, field, now, operator);
        }
        return this.generateNeverBreached(user, field, now, operator);
    }

    private QueryFactoryResult generateEverBreached(ApplicationUser user, CustomField field, DateTime now, Operator operator) {
        SlaQueryBuilder builder = this.slaQueryBuilderFactory.newBuilder(field);
        Query remainingQuery = this.getBreachedOnRemainingTimeIndex(user, field, now, operator);
        builder.or();
        builder.everBreached(true);
        builder.add(remainingQuery);
        return new QueryFactoryResult(builder.build());
    }

    private QueryFactoryResult generateNeverBreached(ApplicationUser user, CustomField field, DateTime now, Operator operator) {
        SlaQueryBuilder builder = this.slaQueryBuilderFactory.newBuilder(field);
        Query remainingQuery = this.getBreachedOnRemainingTimeIndex(user, field, now, operator);
        builder.or();
        builder.sub().and().slaCycleState(SlaCycleState.COMPLETED).everBreached(false).endSub();
        builder.sub().and();
        builder.sub().or().slaCycleState(SlaCycleState.RUNNING).slaCycleState(SlaCycleState.PAUSED).endSub();
        builder.add(remainingQuery);
        builder.endSub();
        return new QueryFactoryResult(builder.build());
    }

    @Override
    public QueryFactoryResult getQueryForBreached(ApplicationUser user, CustomField field, DateTime now, Operator operator) {
        SlaQueryBuilder builder = this.slaQueryBuilderFactory.newBuilder(field);
        boolean isPositiveQuery = this.isPositiveOperator(operator);
        Query remainingQuery = this.getBreachedOnRemainingTimeIndex(user, field, now, operator);
        builder.or();
        builder.sub().and().slaCycleState(SlaCycleState.COMPLETED).breached(isPositiveQuery).endSub();
        builder.add(remainingQuery);
        return new QueryFactoryResult(builder.build());
    }

    @Override
    public QueryFactoryResult getQueryForState(ApplicationUser user, CustomField field, DateTime now, Operator operator, Set<SlaCycleState> states) {
        SlaQueryBuilder builder = this.slaQueryBuilderFactory.newBuilder(field);
        builder.slaCycleState(this.normalizeWithOperator(operator, states));
        return new QueryFactoryResult(builder.build());
    }

    @Override
    public QueryFactoryResult getQueryForWithinCalendarHours(ApplicationUser user, CustomField field, DateTime now, Operator operator) {
        SlaQueryBuilder builder = this.slaQueryBuilderFactory.newBuilder(field);
        builder.or();
        boolean positiveOperator = this.isPositiveOperator(operator);
        for (GoalCalendarGroup goalCalendarGroup : this.groupGoalsByCalendar(field)) {
            WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForReference(goalCalendarGroup.calendarReference);
            boolean active = calculator.isActive(now);
            if (positiveOperator) {
                if (!active) continue;
                builder.sub().goalId(goalCalendarGroup.goalIds).endSub();
                continue;
            }
            if (active) continue;
            builder.sub().goalId(goalCalendarGroup.goalIds).endSub();
        }
        return new QueryFactoryResult(builder.build());
    }

    @Override
    public QueryFactoryResult wrapResultQueryWithSecurity(ApplicationUser user, QueryFactoryResult queryFactoryResult, boolean securityOverriden, CustomField field) {
        if (!securityOverriden && this.featureManager.isEnabled(SDFeatureFlags.SLA_JQL_AGENT_SECURITY_RESTRICTED)) {
            List<Integer> metricIds = this.slaJqlQueryingHelper.getAllVisibleTimeMetricIdsForSlaQuerying(user, field);
            if (metricIds.isEmpty()) {
                return QueryFactoryResult.createFalseResult();
            }
            SlaQueryBuilder metricQueryBuilder = this.slaQueryBuilderFactory.newBuilder(field);
            if (metricIds.size() == 1) {
                metricQueryBuilder.metricId().eq().string(String.valueOf(Iterables.getOnlyElement(metricIds)));
            } else {
                metricQueryBuilder.sub().or();
                for (Integer id : metricIds) {
                    metricQueryBuilder.metricId().eq().string(String.valueOf(id));
                }
                metricQueryBuilder.endSub();
            }
            SlaQueryBuilder mainQuery = this.slaQueryBuilderFactory.newBuilder(field);
            mainQuery.and();
            mainQuery.add(queryFactoryResult.getLuceneQuery());
            mainQuery.add(metricQueryBuilder.build());
            return new QueryFactoryResult(mainQuery.build());
        }
        return queryFactoryResult;
    }

    private Query getBreachedOnRemainingTimeIndex(ApplicationUser user, CustomField field, DateTime now, Operator operator) {
        boolean isPositiveQuery = this.isPositiveOperator(operator);
        if (isPositiveQuery) {
            return this.getRemainingTimeQuery(user, field, now, Operator.LESS_THAN, ZERO_LIST);
        }
        return this.getRemainingTimeQuery(user, field, now, Operator.GREATER_THAN_EQUALS, ZERO_LIST);
    }

    private boolean isPositiveOperator(Operator operator) {
        return OperatorClasses.POSITIVE_EQUALITY_OPERATORS.contains(operator);
    }

    private boolean isNegativeOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains(operator);
    }

    private Set<SlaCycleState> normalizeWithOperator(Operator operator, Set<SlaCycleState> states) {
        EnumSet result = Sets.newEnumSet(states, SlaCycleState.class);
        if (this.isNegativeOperator(operator)) {
            result = EnumSet.complementOf(result);
        }
        return result;
    }

    private Option<DateTime> getTargetDate(WorkingHoursCalculator calculator, DateTime startDate, long duration) {
        if (duration == 0L) {
            return Option.some((Object)startDate);
        }
        DateTimeRangeList activeRanges = DateTimeRangeList.fromIntervals(calculator.getActiveRanges(startDate, duration));
        if (activeRanges == null || activeRanges.size() == 0) {
            return Option.none();
        }
        if (duration > 0L) {
            Option<DateTimeRange> last = activeRanges.last();
            if (last.isDefined()) {
                return Option.some((Object)((DateTimeRange)last.get()).getStop());
            }
        } else {
            Option<DateTimeRange> first = activeRanges.first();
            if (first.isDefined()) {
                return Option.some((Object)((DateTimeRange)first.get()).getStart());
            }
        }
        return Option.none();
    }

    private Collection<GoalCalendarGroup> groupGoalsByCalendar(CustomField field) {
        HashMap result = Maps.newHashMap();
        List<TimeMetric> timeMetrics = this.timeMetricManager.getTimeMetricsByCustomField(field);
        for (TimeMetric timeMetric : timeMetrics) {
            for (com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal : this.goalManager.getAllByTimeMetric(timeMetric)) {
                if (!goal.hasDuration()) continue;
                CalendarReference calendarReference = this.calendarReferenceManager.getReferenceForGoal((Goal)goal);
                GoalCalendarGroup group = (GoalCalendarGroup)result.get(calendarReference.getId());
                if (group == null) {
                    group = new GoalCalendarGroup();
                    group.calendarReference = calendarReference;
                    result.put(calendarReference.getId(), group);
                }
                group.goalIds.add(goal.getId());
            }
        }
        return result.values();
    }

    private Collection<GoalCalendarAndDurationGroup> groupGoalsByCalendarAndDuration(CustomField field) {
        HashMap result = Maps.newHashMap();
        List<TimeMetric> timeMetrics = this.timeMetricManager.getTimeMetricsByCustomField(field);
        for (TimeMetric timeMetric : timeMetrics) {
            for (com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal : this.goalManager.getAllByTimeMetric(timeMetric)) {
                if (!goal.hasDuration()) continue;
                long goalDuration = goal.getDuration();
                CalendarReference calendarReference = this.calendarReferenceManager.getReferenceForGoal((Goal)goal);
                String key = calendarReference.getId() + "-" + goalDuration;
                GoalCalendarAndDurationGroup group = (GoalCalendarAndDurationGroup)result.get(key);
                if (group == null) {
                    group = new GoalCalendarAndDurationGroup();
                    group.calendarReference = calendarReference;
                    group.goalDuration = goalDuration;
                    result.put(key, group);
                }
                group.goalIds.add(goal.getId());
            }
        }
        return result.values();
    }

    private static SlaConditionBuilder.Operator convertOperator(Operator jqlOperator) {
        switch (jqlOperator) {
            case EQUALS: 
            case IN: 
            case IS: {
                return SlaConditionBuilder.Operator.EQ;
            }
            case NOT_EQUALS: 
            case NOT_IN: 
            case IS_NOT: {
                return SlaConditionBuilder.Operator.NOT_EQ;
            }
            case LESS_THAN: {
                return SlaConditionBuilder.Operator.LT;
            }
            case LESS_THAN_EQUALS: {
                return SlaConditionBuilder.Operator.LT_EQ;
            }
            case GREATER_THAN: {
                return SlaConditionBuilder.Operator.GT;
            }
            case GREATER_THAN_EQUALS: {
                return SlaConditionBuilder.Operator.GT_EQ;
            }
        }
        throw new IllegalArgumentException("Unable to process operator " + jqlOperator.name());
    }

    private static SlaConditionBuilder.Operator reverseOperator(Operator jqlOperator) {
        SlaConditionBuilder.Operator slqQueryOperator = SlaClauseQueryGenerationServiceImpl.convertOperator(jqlOperator);
        switch (jqlOperator) {
            case LESS_THAN: {
                return SlaConditionBuilder.Operator.GT;
            }
            case LESS_THAN_EQUALS: {
                return SlaConditionBuilder.Operator.GT_EQ;
            }
            case GREATER_THAN: {
                return SlaConditionBuilder.Operator.LT;
            }
            case GREATER_THAN_EQUALS: {
                return SlaConditionBuilder.Operator.LT_EQ;
            }
        }
        return slqQueryOperator;
    }

    private static class GoalCalendarAndDurationGroup {
        public Set<Integer> goalIds = Sets.newHashSet();
        public long goalDuration;
        public CalendarReference calendarReference;

        private GoalCalendarAndDurationGroup() {
        }
    }

    private static class GoalCalendarGroup {
        public Set<Integer> goalIds = Sets.newHashSet();
        public CalendarReference calendarReference;

        private GoalCalendarGroup() {
        }
    }
}

