/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.sla.searcher.SlaClauseQueryGenerationService;
import com.atlassian.servicedesk.internal.sla.searcher.SlaDurationParser;
import com.atlassian.servicedesk.internal.sla.searcher.function.SlaJqlFunctionHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlaClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SlaClauseQueryFactory.class);
    private final CustomField customField;
    private final JqlOperandResolver jqlOperandResolver;

    public SlaClauseQueryFactory(CustomField customField, JqlOperandResolver jqlOperandResolver) {
        this.customField = customField;
        this.jqlOperandResolver = jqlOperandResolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public QueryFactoryResult getQuery(@Nonnull QueryCreationContext queryCreationContext, @Nonnull TerminalClause terminalClause) {
        QueryFactoryResult queryFactoryResult;
        ApplicationUser user = queryCreationContext.getApplicationUser();
        SlaClauseQueryGenerationService slaClauseQueryGenerationService = ServiceDeskComponentAccessor.slaClauseQueryGenerationService();
        if (!this.hasValidAgentLicense(user)) {
            return QueryFactoryResult.createFalseResult();
        }
        DateTime now = DateTime.now();
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        boolean securityOverriden = queryCreationContext.isSecurityOverriden();
        if (SlaJqlFunctionHelper.isRawValueOrRemainingTimeFunctionOperand(operand)) {
            List<Long> durations = this.getDurations(user, terminalClause);
            if (durations.isEmpty()) return QueryFactoryResult.createFalseResult();
            queryFactoryResult = slaClauseQueryGenerationService.getQueryForRemainingTime(user, this.customField, now, operator, durations);
            return slaClauseQueryGenerationService.wrapResultQueryWithSecurity(user, queryFactoryResult, securityOverriden, this.customField);
        } else if (SlaJqlFunctionHelper.isElapsedTimeFunctionOperand(operand)) {
            Option duration = Option.option((Object)Iterables.getOnlyElement(this.getDurations(user, terminalClause), null));
            if (!duration.isDefined()) return QueryFactoryResult.createFalseResult();
            queryFactoryResult = slaClauseQueryGenerationService.getQueryForElapsedTime(user, this.customField, now, operator, (Long)duration.get());
            return slaClauseQueryGenerationService.wrapResultQueryWithSecurity(user, queryFactoryResult, securityOverriden, this.customField);
        } else if (SlaJqlFunctionHelper.isStateFunctionOperand(operand)) {
            queryFactoryResult = slaClauseQueryGenerationService.getQueryForState(user, this.customField, now, operator, SlaJqlFunctionHelper.getCycles(operand));
            return slaClauseQueryGenerationService.wrapResultQueryWithSecurity(user, queryFactoryResult, securityOverriden, this.customField);
        } else if (SlaJqlFunctionHelper.isWithinCalendarHoursOperand(operand)) {
            queryFactoryResult = slaClauseQueryGenerationService.getQueryForWithinCalendarHours(user, this.customField, now, operator);
            return slaClauseQueryGenerationService.wrapResultQueryWithSecurity(user, queryFactoryResult, securityOverriden, this.customField);
        } else if (SlaJqlFunctionHelper.isEverBreachedFunctionOperand(operand)) {
            queryFactoryResult = slaClauseQueryGenerationService.getQueryForEverBreached(user, this.customField, now, operator);
            return slaClauseQueryGenerationService.wrapResultQueryWithSecurity(user, queryFactoryResult, securityOverriden, this.customField);
        } else if (SlaJqlFunctionHelper.isBreachedFunctionOperand(operand)) {
            queryFactoryResult = slaClauseQueryGenerationService.getQueryForBreached(user, this.customField, now, operator);
            return slaClauseQueryGenerationService.wrapResultQueryWithSecurity(user, queryFactoryResult, securityOverriden, this.customField);
        } else {
            LOG.warn("Unknown SLA JQL ({}) function {} - {}", (Object)operand.getName(), (Object)operand.getDisplayString());
            return QueryFactoryResult.createFalseResult();
        }
    }

    private boolean hasValidAgentLicense(ApplicationUser user) {
        return ServiceDeskComponentAccessor.getServiceDeskUserLicenseService().hasValidAgentLicense(user);
    }

    private List<Long> getDurations(ApplicationUser user, TerminalClause aClause) {
        List literals = this.jqlOperandResolver.getValues(user, aClause.getOperand(), aClause);
        if (literals == null || literals.isEmpty()) {
            throw new IllegalStateException("The literal cannot be null (or empty) in '" + aClause.toString() + "' , as validation should already have dealt with that.");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (QueryLiteral literal : literals) {
            Long duration = literal.getLongValue();
            if (duration != null) {
                builder.add((Object)duration);
                continue;
            }
            String durationStr = literal.getStringValue();
            if (durationStr == null) continue;
            SlaDurationParser.parseDuration(durationStr).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }
}

