/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.sla.searcher.SlaCycleState;
import com.atlassian.servicedesk.internal.api.sla.searcher.TimelineCycleState;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLAValueSerializer;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.model.TimelineEvent;
import com.atlassian.servicedesk.internal.sla.model.TimelineEventType;
import com.atlassian.servicedesk.internal.sla.searcher.LastCompleteCycleData;
import com.atlassian.servicedesk.internal.sla.searcher.OngoingCycleIndexingData;
import com.atlassian.servicedesk.internal.sla.searcher.SlaIndexingData;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeOrderingIndexData;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import io.atlassian.fugue.Option;
import java.util.EnumSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.joda.time.DateTime;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.Indexer)
public class SLACustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private static final SLAValueSerializer SERIALIZER = new SLAValueSerializer();
    public static final int NO_GOAL_ID_INDEX_VALUE = -1;
    private static final boolean NUMERIC_FIELD_INDEXED = true;
    private static final int NO_METRIC_ID_INDEX_VALUE = -1;
    private static final String TIMELINE_SUFFIX = "_timeline";
    private static final String LAST_TIMELINE_CYCLE_END_DATE_SUFFIX = "_last_cycle_end_date";
    private static final String LAST_TIMELINE_CYCLE_STATE_SUFFIX = "_last_timeline_cycle_state";
    private static final String LAST_CYCLE_STATE_SUFFIX = "_last_cycle_state";
    private static final String ANY_COMPLETE_CYCLE_FAILED_SUFFIX = "_any_complete_cycle_failed";
    private static final String LAST_COMPLETE_CYCLE_FAILED_SUFFIX = "_last_complete_cycle_failed";
    private static final String LAST_COMPLETE_CYCLE_END_DATE_SUFFIX = "_last_complete_cycle_end_date";
    private static final String PAUSED_CYCLE_ELAPSED_TIME_SUFFIX = "_paused_cycle_elapsed_time";
    private static final String PAUSED_CYCLE_REMAINING_TIME_SUFFIX = "_paused_cycle_remaining_time";
    private static final String SHIFTED_START_DATE_SUFFIX = "_shifted_start_date";
    private static final String GOAL_ID_SUFFIX = "_goal_id";
    private static final String METRIC_ID_SUFFIX = "_mid";
    private static final String DEFINITION_CHANGE_SUFFIX = "_dcd";
    private static final String THRESHOLDS_CONFIG_CHANGE_SUFFIX = "_tccd";
    private static final String GOALS_CHANGE_SUFFIX = "_gcd";
    private static final String GOAL_CHECK_ID_SUFFIX = "_gid";
    private static final String GOAL_TIME_UPDATED_SUFFIX = "_gtd";
    private final CustomField field;
    private final SLAFieldManager slaFieldManager;

    protected SLACustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, SLAFieldManager slaFieldManager) {
        super(fieldVisibilityManager, customField);
        this.field = customField;
        this.slaFieldManager = slaFieldManager;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.getSafeRunner().run(() -> this.addDocumentFields(doc, issue));
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.getSafeRunner().run(() -> this.addDocumentFields(doc, issue));
    }

    void addDocumentFields(Document doc, Issue issue) {
        Option<SlaIndexingData> indexingDataOption;
        SLAValue value = (SLAValue)this.slaFieldManager.getOptionalFieldValue(issue, this.field).getOrNull();
        if (value != null && !ServiceDeskComponentAccessor.getServiceDeskInternalManager().hasServiceDesk(issue.getProjectObject(), false)) {
            value = null;
        }
        this.addConsistencyStateFields(doc, issue, value);
        if (value != null) {
            Timeline timeline = value.getTimeline();
            doc.add((Fieldable)new Field(SLACustomFieldIndexer.getTimelineFieldId(this.field), SERIALIZER.serialize(value.getTimeline()), this.getStoreYes(), Field.Index.NO));
            Option<TimelineEvent> lastStartStop = timeline.getLastOccurenceOfEvent(EnumSet.of(TimelineEventType.START, TimelineEventType.STOP));
            if (lastStartStop.isDefined()) {
                boolean stopped = ((TimelineEvent)lastStartStop.get()).getTypes().contains((Object)TimelineEventType.STOP);
                if (stopped) {
                    DateTime stopDate = ((TimelineEvent)lastStartStop.get()).getDate();
                    doc.add((Fieldable)this.createLongNumericField(SLACustomFieldIndexer.getLastTimelineCycleEndDateFieldId(this.field), stopDate.getMillis(), this.getStoreNo(), true));
                    doc.add((Fieldable)new Field(SLACustomFieldIndexer.getLastTimelineCycleStateFieldId(this.field), TimelineCycleState.COMPLETED.getLuceneIndexValue(), this.getStoreNo(), Field.Index.NOT_ANALYZED));
                } else {
                    doc.add((Fieldable)new Field(SLACustomFieldIndexer.getLastTimelineCycleStateFieldId(this.field), TimelineCycleState.ONGOING.getLuceneIndexValue(), this.getStoreNo(), Field.Index.NOT_ANALYZED));
                }
            } else {
                doc.add((Fieldable)new Field(SLACustomFieldIndexer.getLastTimelineCycleStateFieldId(this.field), TimelineCycleState.NOT_STARTED.getLuceneIndexValue(), this.getStoreNo(), Field.Index.NOT_ANALYZED));
            }
        }
        if ((indexingDataOption = ServiceDeskComponentAccessor.slaIndexingDataManager().getIndexingData(value, this.field, issue)).isEmpty()) {
            return;
        }
        SlaIndexingData slaIndexingData = (SlaIndexingData)indexingDataOption.get();
        String lastSlaCycleState = this.getLastSlaCycleState(slaIndexingData);
        doc.add((Fieldable)new Field(SLACustomFieldIndexer.getLastCycleStateFieldId(this.field), lastSlaCycleState, this.getStoreNo(), Field.Index.NOT_ANALYZED));
        RemainingTimeOrderingIndexData remainingTimeOrderingIndexData = new RemainingTimeOrderingIndexData();
        remainingTimeOrderingIndexData.cycleState = lastSlaCycleState;
        remainingTimeOrderingIndexData.metricId = SLACustomFieldIndexer.prepareMetricId(value == null ? null : value.getMetricId());
        if (slaIndexingData.getOngoingCycleIndexingData().isDefined()) {
            OngoingCycleIndexingData ongoingIndexingData = (OngoingCycleIndexingData)slaIndexingData.getOngoingCycleIndexingData().get();
            if (ongoingIndexingData.isPaused()) {
                doc.add((Fieldable)this.createLongNumericField(SLACustomFieldIndexer.getPausedCycleElapsedTimeFieldId(this.field), ongoingIndexingData.getElapsedTime(), this.getStoreNo(), true));
                doc.add((Fieldable)this.createLongNumericField(SLACustomFieldIndexer.getPausedCycleRemainingTimeFieldId(this.field), ongoingIndexingData.getRemainingTime(), this.getStoreNo(), true));
                remainingTimeOrderingIndexData.remainingTime = ongoingIndexingData.getRemainingTime();
            } else {
                doc.add((Fieldable)this.createLongNumericField(SLACustomFieldIndexer.getShiftedStartDateFieldId(this.field), ongoingIndexingData.getShiftedStartDate().getMillis(), this.getStoreNo(), true));
                doc.add((Fieldable)this.createIntNumericField(SLACustomFieldIndexer.getGoalIdFieldId(this.field), ongoingIndexingData.getGoalId(), this.getStoreNo(), true));
                remainingTimeOrderingIndexData.goalId = ongoingIndexingData.getGoalId();
                remainingTimeOrderingIndexData.shiftedStartDate = ongoingIndexingData.getShiftedStartDate().getMillis();
            }
        }
        if (slaIndexingData.getLastCompleteCycleData().isDefined()) {
            LastCompleteCycleData lastCompleteCycleData = (LastCompleteCycleData)slaIndexingData.getLastCompleteCycleData().get();
            doc.add((Fieldable)new Field(SLACustomFieldIndexer.getLastCompletedCycleBreachedFieldId(this.field), this.getLastCompleteCycleFailedState(lastCompleteCycleData), this.getStoreNo(), Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)this.createLongNumericField(SLACustomFieldIndexer.getLastCompletedCycleEndDateFieldId(this.field), this.getLastCompleteCycleEndDate(lastCompleteCycleData), this.getStoreNo(), true));
        }
        doc.add((Fieldable)new Field(SLACustomFieldIndexer.getAnyCyclesBreachedFieldId(this.field), this.getAnyCompleteCyclesFailedState(slaIndexingData), this.getStoreNo(), Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(SLACustomFieldIndexer.getOrderByFieldId(this.field), SERIALIZER.serialize(remainingTimeOrderingIndexData), this.getStoreYes(), Field.Index.NOT_ANALYZED));
    }

    private NumericField createLongNumericField(String fieldId, long value, Field.Store store, boolean index) {
        NumericField field = new NumericField(fieldId, store, index);
        field.setLongValue(value);
        return field;
    }

    private NumericField createIntNumericField(String fieldId, int value, Field.Store store, boolean index) {
        NumericField field = new NumericField(fieldId, store, index);
        field.setIntValue(value);
        return field;
    }

    private String getAnyCompleteCyclesFailedState(SlaIndexingData slaIndexingData) {
        return Boolean.toString(slaIndexingData.isAnyCompleteCycleFailed());
    }

    private String getLastCompleteCycleFailedState(LastCompleteCycleData lastCompleteCycleData) {
        return Boolean.toString(lastCompleteCycleData.isLastCompleteCycleFailed());
    }

    public long getLastCompleteCycleEndDate(LastCompleteCycleData lastCompleteCycleData) {
        return lastCompleteCycleData.getLastCompleteCycleEndDate().getMillis();
    }

    private String getLastSlaCycleState(SlaIndexingData slaIndexingData) {
        if (slaIndexingData.getOngoingCycleIndexingData().isDefined()) {
            if (((OngoingCycleIndexingData)slaIndexingData.getOngoingCycleIndexingData().get()).isPaused()) {
                return SlaCycleState.PAUSED.getLuceneIndexValue();
            }
            return SlaCycleState.RUNNING.getLuceneIndexValue();
        }
        return SlaCycleState.COMPLETED.getLuceneIndexValue();
    }

    private void addConsistencyStateFields(Document doc, Issue issue, SLAValue value) {
        if (value == null) {
            this.addMetricId(doc, null);
            return;
        }
        this.addMetricId(doc, value.getMetricId());
        String definitionChangeMsEpochString = Long.toString(this.defaultLong(value.getDefinitionChangeMsEpoch()));
        doc.add((Fieldable)new Field(SLACustomFieldIndexer.getDefinitionChangeDateFieldId(this.field), definitionChangeMsEpochString, this.getStoreNo(), Field.Index.NOT_ANALYZED));
        OngoingSLAData ongoingSLAData = value.getOngoingSLAData();
        if (ongoingSLAData == null) {
            this.addGoalIdCheck(doc, null);
            return;
        }
        this.addGoalIdCheck(doc, ongoingSLAData.getGoalId());
        String goalsChangeMsEpochString = Long.toString(this.defaultLong(value.getGoalsChangeMsEpoch()));
        doc.add((Fieldable)new Field(SLACustomFieldIndexer.getGoalsChangeDateFieldId(this.field), goalsChangeMsEpochString, this.getStoreNo(), Field.Index.NOT_ANALYZED));
        String goalTimeUpdatedMsEpochString = Long.toString(this.defaultLong(value.getGoalTimeUpdatedMsEpoch()));
        doc.add((Fieldable)new Field(SLACustomFieldIndexer.getGoalTimeUpdatedFieldId(this.field), goalTimeUpdatedMsEpochString, this.getStoreNo(), Field.Index.NOT_ANALYZED));
        value.getOngoingSLAData().getThresholdData().forEach(data -> {
            String thresholdsConfigChangeMsEpochString = Long.toString(this.defaultLong(data.getThresholdsConfigChangeMsEpoch()));
            doc.add((Fieldable)new Field(SLACustomFieldIndexer.getThresholdsConfigChangeDateFieldId(this.field), thresholdsConfigChangeMsEpochString, this.getStoreNo(), Field.Index.NOT_ANALYZED));
        });
    }

    private Field.Store getStoreNo() {
        return Field.Store.NO;
    }

    private Field.Store getStoreYes() {
        return Field.Store.YES;
    }

    private long defaultLong(Long t) {
        return t != null ? t : 0L;
    }

    private void addMetricId(Document doc, Integer value) {
        int id = SLACustomFieldIndexer.prepareMetricId(value);
        doc.add((Fieldable)new Field(SLACustomFieldIndexer.getMetricIdFieldId(this.field), Integer.toString(id), this.getStoreNo(), Field.Index.NOT_ANALYZED));
    }

    private void addGoalIdCheck(Document doc, Integer value) {
        int id = SLACustomFieldIndexer.prepareGoalId(value);
        doc.add((Fieldable)new Field(SLACustomFieldIndexer.getGoalCheckFieldId(this.field), Integer.toString(id), this.getStoreNo(), Field.Index.NOT_ANALYZED));
    }

    public static int prepareGoalId(Integer value) {
        return value != null ? value : -1;
    }

    public static int prepareMetricId(Integer value) {
        return value != null ? value : -1;
    }

    public static String getTimelineFieldId(CustomField field) {
        return field.getId() + TIMELINE_SUFFIX;
    }

    public static String getMetricIdFieldId(CustomField field) {
        return field.getId() + METRIC_ID_SUFFIX;
    }

    public static String getLastTimelineCycleEndDateFieldId(CustomField field) {
        return field.getId() + LAST_TIMELINE_CYCLE_END_DATE_SUFFIX;
    }

    public static String getLastTimelineCycleStateFieldId(CustomField field) {
        return field.getId() + LAST_TIMELINE_CYCLE_STATE_SUFFIX;
    }

    public static String getDefinitionChangeDateFieldId(CustomField field) {
        return field.getId() + DEFINITION_CHANGE_SUFFIX;
    }

    public static String getThresholdsConfigChangeDateFieldId(CustomField field) {
        return field.getId() + THRESHOLDS_CONFIG_CHANGE_SUFFIX;
    }

    public static String getGoalsChangeDateFieldId(CustomField field) {
        return field.getId() + GOALS_CHANGE_SUFFIX;
    }

    public static String getGoalCheckFieldId(CustomField field) {
        return field.getId() + GOAL_CHECK_ID_SUFFIX;
    }

    public static String getGoalTimeUpdatedFieldId(CustomField field) {
        return field.getId() + GOAL_TIME_UPDATED_SUFFIX;
    }

    public static String getLastCycleStateFieldId(CustomField field) {
        return field.getId() + LAST_CYCLE_STATE_SUFFIX;
    }

    public static String getAnyCyclesBreachedFieldId(CustomField field) {
        return field.getId() + ANY_COMPLETE_CYCLE_FAILED_SUFFIX;
    }

    public static String getLastCompletedCycleBreachedFieldId(CustomField field) {
        return field.getId() + LAST_COMPLETE_CYCLE_FAILED_SUFFIX;
    }

    public static String getLastCompletedCycleEndDateFieldId(CustomField field) {
        return field.getId() + LAST_COMPLETE_CYCLE_END_DATE_SUFFIX;
    }

    public static String getPausedCycleElapsedTimeFieldId(CustomField field) {
        return field.getId() + PAUSED_CYCLE_ELAPSED_TIME_SUFFIX;
    }

    public static String getPausedCycleRemainingTimeFieldId(CustomField field) {
        return field.getId() + PAUSED_CYCLE_REMAINING_TIME_SUFFIX;
    }

    public static String getShiftedStartDateFieldId(CustomField field) {
        return field.getId() + SHIFTED_START_DATE_SUFFIX;
    }

    public static String getGoalIdFieldId(CustomField field) {
        return field.getId() + GOAL_ID_SUFFIX;
    }

    public static String getOrderByFieldId(CustomField field) {
        return SLACustomFieldIndexer.getOrderByFieldId(field.getId());
    }

    public static String getOrderByFieldId(String customFieldId) {
        return customFieldId;
    }

    private SafeRunner getSafeRunner() {
        return ServiceDeskComponentAccessor.getSafeRunner();
    }
}

