/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.FreeTextCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.sla.searcher.SLACustomFieldIndexer;
import com.atlassian.servicedesk.internal.sla.searcher.SlaClauseQueryFactory;
import com.atlassian.servicedesk.internal.sla.searcher.SlaClauseValidator;
import com.atlassian.servicedesk.internal.sla.searcher.SlaDataTypes;
import com.atlassian.servicedesk.internal.sla.searcher.SlaJqlQueryingHelper;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeSorter;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;

public class SLACFSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher {
    private static final String CACHE_KEY = SLACFSearcher.class.getName() + ".remainingTimeSorterCache";
    private static final String CACHE_SORTER_KEY_FORMAT = "remainingTimeSorter_%s";
    private final FieldVisibilityManager fieldVisibilityManager;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final FeatureManager featureManager;
    private final RequestCache<String, RemainingTimeSorter> requestAlignedSorterCache;
    private ServiceDeskUserLicenseService sdUserLicenseService;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private volatile SlaJqlQueryingHelper slaJqlQueryingHelper;

    private static String createCacheSorterKey(CustomField customField) {
        return String.format(CACHE_SORTER_KEY_FORMAT, customField.getId());
    }

    public SLACFSearcher(FieldVisibilityManager fieldVisibilityManager, CustomFieldInputHelper customFieldInputHelper, I18nHelper.BeanFactory i18nHelperFactory, JiraAuthenticationContext authenticationContext, FeatureManager featureManager, VCacheFactory vCacheFactory) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.customFieldInputHelper = customFieldInputHelper;
        this.i18nHelperFactory = i18nHelperFactory;
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
        this.requestAlignedSorterCache = vCacheFactory.getRequestCache(CACHE_KEY);
    }

    public void init(CustomField field) {
        this.sdUserLicenseService = ServiceDeskComponentAccessor.getServiceDeskUserLicenseService();
        JqlOperandResolver jqlOperandResolver = ServiceDeskComponentAccessor.getJqlOperandResolver();
        ServiceDeskOperationalStatus serviceDeskOperationalStatus = ServiceDeskComponentAccessor.getServiceDeskOperationalStatus();
        ClauseNames names = field.getClauseNames();
        SLACustomFieldIndexer indexer = new SLACustomFieldIndexer(this.fieldVisibilityManager, field, ServiceDeskComponentAccessor.getSlaFieldManager());
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(names, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new FreeTextCustomFieldSearchInputTransformer(field, names, this.searcherInformation.getId(), this.customFieldInputHelper);
        this.slaJqlQueryingHelper = ServiceDeskComponentAccessor.getSlaJqlQueryingHelper();
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldSearcherClauseHandler((ClauseValidator)new SlaClauseValidator(jqlOperandResolver, this.i18nHelperFactory, this.sdUserLicenseService, serviceDeskOperationalStatus), (ClauseQueryFactory)new SlaClauseQueryFactory(field, jqlOperandResolver), EnumSet.of(Operator.EQUALS, new Operator[]{Operator.NOT_EQUALS, Operator.GREATER_THAN, Operator.GREATER_THAN_EQUALS, Operator.LESS_THAN, Operator.LESS_THAN_EQUALS}), SlaDataTypes.SLA_FUNCTION);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (!this.sdUserLicenseService.hasValidAgentLicense(user)) {
            return null;
        }
        return (LuceneFieldSorter)this.requestAlignedSorterCache.get((Object)SLACFSearcher.createCacheSorterKey(customField), () -> new RemainingTimeSorter(user, customField, this.slaJqlQueryingHelper, this.featureManager));
    }
}

