/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.model;

import com.atlassian.servicedesk.internal.sla.metric.DateTimeRange;
import com.atlassian.servicedesk.internal.sla.model.TimelineEvent;
import com.atlassian.servicedesk.internal.sla.model.TimelineEventType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Timeline {
    public static EnumSet<TimelineEventType> START_AND_STOP = EnumSet.of(TimelineEventType.START, TimelineEventType.STOP);
    public static EnumSet<TimelineEventType> PAUSE_AND_UNPAUSE = EnumSet.of(TimelineEventType.PAUSE, TimelineEventType.UNPAUSE);
    public static final EnumSet<TimelineEventType> START_AND_PAUSE = EnumSet.of(TimelineEventType.START, TimelineEventType.PAUSE);
    @JsonProperty(value="events")
    List<TimelineEvent> events;

    public Timeline(List<TimelineEvent> events) {
        this.events = events;
    }

    public Timeline() {
    }

    public List<TimelineEvent> getEvents() {
        if (this.events == null) {
            this.events = Lists.newArrayList();
        }
        return this.events;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.events == null || this.events.isEmpty();
    }

    @JsonIgnore
    public boolean isStarted() {
        Option<TimelineEventType> type = this.getLastOccurenceOfEventType(START_AND_STOP);
        return type.exists(event -> event == TimelineEventType.START);
    }

    @JsonIgnore
    public boolean isPaused() {
        Option<TimelineEventType> type = this.getLastOccurenceOfEventType(PAUSE_AND_UNPAUSE);
        return type.exists(event -> event == TimelineEventType.PAUSE);
    }

    @JsonIgnore
    public List<DateTimeRange> getPausedRanges(DateTime now) {
        return this.getRanges(now, TimelineEventType.PAUSE, TimelineEventType.UNPAUSE);
    }

    @JsonIgnore
    public List<DateTimeRange> getStartedRanges(DateTime now) {
        return this.getRanges(now, TimelineEventType.START, TimelineEventType.STOP);
    }

    private List<DateTimeRange> getRanges(DateTime now, TimelineEventType startType, TimelineEventType stopType) {
        ArrayList ranges = Lists.newArrayList();
        DateTime lastStartDate = null;
        for (TimelineEvent event : this.getEvents()) {
            if (lastStartDate == null && event.getTypes().contains((Object)startType)) {
                lastStartDate = event.getDate();
                continue;
            }
            if (lastStartDate == null || !event.getTypes().contains((Object)stopType)) continue;
            DateTimeRange range = new DateTimeRange(lastStartDate, event.getDate());
            ranges.add(range);
            lastStartDate = null;
        }
        if (lastStartDate != null && lastStartDate.isBefore((ReadableInstant)now)) {
            DateTimeRange range = new DateTimeRange(lastStartDate, now);
            ranges.add(range);
        }
        return ranges;
    }

    @JsonIgnore
    private Option<TimelineEventType> getLastOccurenceOfEventType(EnumSet<TimelineEventType> types) {
        if (this.events == null) {
            return Option.none();
        }
        for (int index = this.events.size() - 1; index >= 0; --index) {
            TimelineEvent event = this.events.get(index);
            Sets.SetView commonTypes = Sets.intersection(types, event.getTypes());
            if (commonTypes.size() <= 0) continue;
            return Option.some(commonTypes.iterator().next());
        }
        return Option.none();
    }

    @JsonIgnore
    public Option<TimelineEvent> getLastOccurenceOfEvent(EnumSet<TimelineEventType> types) {
        if (this.events == null) {
            return Option.none();
        }
        for (int index = this.events.size() - 1; index >= 0; --index) {
            TimelineEvent event = this.events.get(index);
            Sets.SetView commonTypes = Sets.intersection(types, event.getTypes());
            if (commonTypes.size() <= 0) continue;
            return Option.some((Object)event);
        }
        return Option.none();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("events", this.events).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Timeline value) {
        return new Builder(value);
    }

    public static class Builder
    extends Timeline {
        public Builder() {
        }

        public Builder(Timeline timeline) {
            this();
            if (timeline != null) {
                this.events = Lists.newArrayList(timeline.getEvents());
            }
        }

        public Builder add(TimelineEvent event) {
            this.getEvents().add(event);
            return this;
        }

        public Builder add(DateTime time, EnumSet<TimelineEventType> types) {
            return this.add(new TimelineEvent(time, types));
        }

        public Builder add(DateTime time, TimelineEventType type) {
            return this.add(new TimelineEvent(time, EnumSet.of(type)));
        }

        public Timeline build() {
            return new Timeline(this.getEvents());
        }
    }
}

