/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.model;

import com.atlassian.servicedesk.internal.api.sla.metric.TimeMetricMeasureType;
import com.google.common.base.MoreObjects;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

public class CompleteSLAData {
    @JsonProperty(value="succeeded")
    boolean succeeded;
    @JsonProperty(value="goalTime")
    Long goalTime;
    @JsonProperty(value="elapsedTime")
    Long elapsedTime;
    @JsonProperty(value="remainingTime")
    Long remainingTime;
    @JsonProperty(value="remainingTimeInDaysAndMillis")
    Map<TimeMetricMeasureType, Long> remainingTimeInDaysAndMillis;
    @JsonProperty(value="calendarName")
    String calendarName;
    @JsonProperty(value="startTime")
    DateTime startTime;
    @JsonProperty(value="stopTime")
    DateTime stopTime;

    public CompleteSLAData() {
    }

    public CompleteSLAData(boolean succeeded, Long goalTime, Long elapsedTime, Long remainingTime, Map<TimeMetricMeasureType, Long> remainingTimeInDaysAndMillis, String calendarName, DateTime startTime, DateTime stopTime) {
        this.succeeded = succeeded;
        this.goalTime = goalTime;
        this.elapsedTime = elapsedTime;
        this.remainingTime = remainingTime;
        this.remainingTimeInDaysAndMillis = remainingTimeInDaysAndMillis;
        this.calendarName = calendarName;
        this.startTime = startTime;
        this.stopTime = stopTime;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public Long getGoalTime() {
        return this.goalTime;
    }

    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    public Long getRemainingTime() {
        return this.remainingTime;
    }

    public Map<TimeMetricMeasureType, Long> getRemainingTimeInDaysAndMillis() {
        return this.remainingTimeInDaysAndMillis;
    }

    public String getCalendarName() {
        return this.calendarName;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getStopTime() {
        return this.stopTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("calendarName", (Object)this.calendarName).add("succeeded", this.succeeded).add("goalTime", (Object)this.goalTime).add("elapsedTime", (Object)this.elapsedTime).add("remainingTime", (Object)this.remainingTime).add("remainingTimeInDaysAndMillis", this.remainingTimeInDaysAndMillis).add("startTime", (Object)this.startTime).add("stopTime", (Object)this.stopTime).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CompleteSLAData value) {
        return new Builder(value);
    }

    public static class Builder {
        boolean succeeded;
        Long goalTime;
        Long elapsedTime;
        Long remainingTime;
        Map<TimeMetricMeasureType, Long> remainingTimeInDaysAndMillis;
        String calendarName;
        DateTime startTime;
        DateTime stopTime;

        public Builder() {
        }

        public Builder(CompleteSLAData value) {
            if (value != null) {
                this.succeeded(value.succeeded).calendarName(value.calendarName).elapsedTime(value.elapsedTime);
                this.remainingTime(value.remainingTime).remainingTimeInDaysAndMillis(value.remainingTimeInDaysAndMillis);
                this.goalTime(value.goalTime).startTime(value.startTime).stopTime(value.stopTime);
            }
        }

        public Builder succeeded(boolean succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public Builder goalTime(Long goalTime) {
            this.goalTime = goalTime;
            return this;
        }

        public Builder elapsedTime(Long elapsedTime) {
            this.elapsedTime = elapsedTime;
            return this;
        }

        public Builder remainingTime(Long remainingTime) {
            this.remainingTime = remainingTime;
            return this;
        }

        public Builder remainingTimeInDaysAndMillis(Map<TimeMetricMeasureType, Long> remainingTimeInDaysAndMillis) {
            this.remainingTimeInDaysAndMillis = remainingTimeInDaysAndMillis;
            return this;
        }

        public Builder calendarName(String calendarName) {
            this.calendarName = calendarName;
            return this;
        }

        public Builder startTime(DateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder stopTime(DateTime stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public CompleteSLAData build() {
            return new CompleteSLAData(this.succeeded, this.goalTime, this.elapsedTime, this.remainingTime, this.remainingTimeInDaysAndMillis, this.calendarName, this.startTime, this.stopTime);
        }
    }
}

