/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.metric;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.internal.sla.metric.TimelineManager;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.model.TimelineEvent;
import com.atlassian.servicedesk.internal.sla.model.TimelineEventType;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class TimelineManagerImpl
implements TimelineManager {
    @Override
    public TimelineManager.RelevantEventTypes getRelevantEventTypes(Timeline timeline) {
        boolean start = !timeline.isStarted();
        boolean pause = true;
        boolean stop = !start;
        return new TimelineManager.RelevantEventTypes(start, pause, stop);
    }

    @Override
    public Timeline appendToTimeline(Timeline timeline, TimelineEvent timelineEvent) {
        Timeline.Builder updatingTimeline = Timeline.builder(timeline);
        updatingTimeline.add(timelineEvent.getDate(), timelineEvent.getTypes());
        return updatingTimeline.build();
    }

    @Override
    public Timeline buildFromHistoryData(TimelineManager.ConditionHistoryData data) {
        List<TimelineEvent> events = this.buildTimelineEventList(data);
        return this.buildTimeline(events);
    }

    private Timeline buildTimeline(List<TimelineEvent> events) {
        Timeline.Builder timelineBuilder = Timeline.builder();
        for (TimelineEvent event : events) {
            Option<TimelineEvent> timelineEventOption = this.getTimelineEvent(timelineBuilder, event.getDate(), event.getTypes());
            if (!timelineEventOption.isDefined()) continue;
            TimelineEvent timelineEvent = (TimelineEvent)timelineEventOption.get();
            timelineBuilder.add(timelineEvent.getDate(), timelineEvent.getTypes());
        }
        return timelineBuilder.build();
    }

    @Override
    public Option<TimelineEvent> getTimelineEvent(Timeline timeline, DateTime date, Set<TimelineEventType> types) {
        EnumSet<TimelineEventType> validTypes = this.filterEvent(timeline, types);
        if (validTypes.isEmpty()) {
            return Option.none();
        }
        return Option.some((Object)new TimelineEvent(date, validTypes));
    }

    private EnumSet<TimelineEventType> filterEvent(Timeline timeline, Set<TimelineEventType> eventTypes) {
        if (timeline.isEmpty()) {
            EnumSet copy = Sets.newEnumSet(eventTypes, TimelineEventType.class);
            copy.retainAll(Timeline.START_AND_PAUSE);
            return copy;
        }
        HashSet<TimelineEventType> validTypes = new HashSet<TimelineEventType>();
        if (timeline.isStarted()) {
            if (eventTypes.contains((Object)TimelineEventType.STOP)) {
                validTypes.add(TimelineEventType.STOP);
            }
        } else if (eventTypes.contains((Object)TimelineEventType.START)) {
            validTypes.add(TimelineEventType.START);
        }
        if (timeline.isPaused()) {
            if (eventTypes.contains((Object)TimelineEventType.UNPAUSE)) {
                validTypes.add(TimelineEventType.UNPAUSE);
            }
        } else if (eventTypes.contains((Object)TimelineEventType.PAUSE)) {
            validTypes.add(TimelineEventType.PAUSE);
        }
        return Sets.newEnumSet(validTypes, TimelineEventType.class);
    }

    private List<TimelineEvent> buildTimelineEventList(TimelineManager.ConditionHistoryData data) {
        TreeMap<DateTime, Set<TimelineEventType>> events = new TreeMap<DateTime, Set<TimelineEventType>>();
        this.addTransitionEvents(events, data.getStartData(), TimelineEventType.START);
        this.addPauseEvents(events, data.getPauseData());
        this.addTransitionEvents(events, data.getStopData(), TimelineEventType.STOP);
        return this.toEventList(events);
    }

    private List<TimelineEvent> toEventList(SortedMap<DateTime, Set<TimelineEventType>> events) {
        ArrayList<TimelineEvent> eventsList = new ArrayList<TimelineEvent>();
        for (Map.Entry<DateTime, Set<TimelineEventType>> entry : events.entrySet()) {
            EnumSet types = Sets.newEnumSet((Iterable)entry.getValue(), TimelineEventType.class);
            eventsList.add(new TimelineEvent(entry.getKey(), types));
        }
        return eventsList;
    }

    private void addTransitionEvents(Map<DateTime, Set<TimelineEventType>> events, List<HitConditionHistory> histories, TimelineEventType type) {
        for (HitConditionHistory history : histories) {
            List hits = history.getHits();
            for (DateTime hit : hits) {
                this.addEventType(events, hit, type);
            }
        }
    }

    private void addPauseEvents(Map<DateTime, Set<TimelineEventType>> events, List<MatchConditionHistory> histories) {
        TreeMap<DateTime, PauseEntry> sortedPauseEntries = new TreeMap<DateTime, PauseEntry>();
        int temporaryConditionId = 1;
        for (MatchConditionHistory history : histories) {
            for (Object entry : history.getEntries()) {
                DateTime entryTime = entry.getDateTime();
                PauseEntry pauseEntry = (PauseEntry)sortedPauseEntries.get(entryTime);
                if (pauseEntry == null) {
                    pauseEntry = new PauseEntry(entryTime);
                    sortedPauseEntries.put(entryTime, pauseEntry);
                }
                pauseEntry.keyToEvent.put(temporaryConditionId, entry.getMatchEvent());
            }
            ++temporaryConditionId;
        }
        HashSet<Integer> pausedConditions = new HashSet<Integer>();
        boolean firstEntry = true;
        for (Object entry : sortedPauseEntries.values()) {
            boolean pausedAfter;
            boolean pausedBefore = !pausedConditions.isEmpty();
            for (Map.Entry<Integer, MatchEvent> pluginKeyToEvent : entry.keyToEvent.entrySet()) {
                if (pluginKeyToEvent.getValue().isMatch()) {
                    pausedConditions.add(pluginKeyToEvent.getKey());
                    continue;
                }
                pausedConditions.remove(pluginKeyToEvent.getKey());
            }
            boolean bl = pausedAfter = !pausedConditions.isEmpty();
            if (firstEntry || pausedBefore != pausedAfter) {
                this.addEventType(events, entry.dateTime, pausedAfter ? TimelineEventType.PAUSE : TimelineEventType.UNPAUSE);
            }
            firstEntry = false;
        }
    }

    private void addEventType(Map<DateTime, Set<TimelineEventType>> events, DateTime date, TimelineEventType type) {
        Set types = events.computeIfAbsent(date, k -> new HashSet());
        types.add(type);
    }

    private static class PauseEntry {
        DateTime dateTime;
        @TenantAware(value=TenancyScope.TENANTED)
        Map<Integer, MatchEvent> keyToEvent = new HashMap<Integer, MatchEvent>();

        public PauseEntry(DateTime dateTime) {
            this.dateTime = dateTime;
            this.keyToEvent = new HashMap<Integer, MatchEvent>();
        }
    }
}

