/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.metric;

import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.servicedesk.internal.api.sla.metric.TimeMetricMeasureType;
import com.atlassian.servicedesk.internal.sla.metric.CycleMetricData;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRange;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRangeList;
import com.atlassian.servicedesk.internal.sla.metric.TimeMetricCalculationService;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.springframework.stereotype.Component;

@Component
public class TimeMetricCalculationServiceImpl
implements TimeMetricCalculationService {
    @Override
    public List<CycleMetricData> getAllCycleMetricData(Timeline timeline, WorkingHoursCalculator calculator, DateTime now) {
        ArrayList results = Lists.newArrayList();
        List<DateTimeRange> cycles = timeline.getStartedRanges(now);
        DateTimeRangeList pauses = DateTimeRangeList.fromRanges(timeline.getPausedRanges(now));
        for (DateTimeRange cycle : cycles) {
            DateTimeRangeList activeHours = DateTimeRangeList.fromIntervals(calculator.getActiveRanges(cycle.toInterval()));
            DateTimeRangeList activeHoursWithPauses = pauses.inverse(cycle);
            DateTimeRangeList activeInCycle = activeHoursWithPauses.intersect(activeHours);
            CycleMetricData timeDuration = new CycleMetricData();
            timeDuration.setRange(cycle);
            timeDuration.setDuration(activeInCycle.getDuration());
            timeDuration.setActiveRangeWithPauses(activeHoursWithPauses);
            if (cycle.getStop().equals((Object)now)) {
                timeDuration.setOngoing(true);
            }
            results.add(timeDuration);
        }
        return results;
    }

    @Override
    public CycleMetricData getRemainingTimeInDaysAndMillisForCompletedGoal(Timeline timeline, WorkingHoursCalculator calculator, long remaining, CycleMetricData cycleMetricData) {
        DateTime now = cycleMetricData.getRange().getStop();
        DateTime expectedCompleteDate = (DateTime)this.getGoalThresholdExceededDate(timeline, calculator, remaining, 0L, cycleMetricData.getRange().getStart(), now).getOrNull();
        DateTime completedDate = cycleMetricData.getRange().getStop();
        DateTimeRangeList activeInCycleFromNowToEnd = this.getActiveHoursInCycleFromNowToEnd(calculator, cycleMetricData.getActiveRangeWithPauses(), completedDate, expectedCompleteDate);
        List<DateTimeRange> activeInCycleFromNowToEndRanges = activeInCycleFromNowToEnd.getRanges();
        if (activeInCycleFromNowToEndRanges.size() > 0) {
            DateTime firstDayActive = activeInCycleFromNowToEndRanges.get(0).getStart();
            DateTimeRange firstDayActiveRange = this.getCompleteActiveRangesForDay(firstDayActive, calculator);
            DateTime lastDayActive = activeInCycleFromNowToEndRanges.get(activeInCycleFromNowToEndRanges.size() - 1).getStop();
            DateTimeRange lastDayActiveRange = this.getCompleteActiveRangesForDay(lastDayActive, calculator);
            Map<TimeMetricMeasureType, Long> remainingTimeInDaysAndMillis = this.getDaysAndMillisForCycle(activeInCycleFromNowToEnd, firstDayActiveRange, lastDayActiveRange, null);
            remainingTimeInDaysAndMillis.put(TimeMetricMeasureType.BREACHED, this.isBreached(completedDate, expectedCompleteDate));
            cycleMetricData.setRemainingTimeInDaysAndMillis(remainingTimeInDaysAndMillis);
        }
        return cycleMetricData;
    }

    @Override
    public long getElapsedTime(Timeline timeline, WorkingHoursCalculator calculator, DateTimeRange dateTimeRange) {
        DateTimeRangeList cycles = DateTimeRangeList.fromRanges(timeline.getStartedRanges(dateTimeRange.getStop()));
        cycles = cycles.intersect(dateTimeRange);
        DateTimeRangeList pauses = DateTimeRangeList.fromRanges(timeline.getPausedRanges(dateTimeRange.getStop()));
        long elapsedTime = 0L;
        for (DateTimeRange cycle : cycles.getRanges()) {
            DateTimeRangeList activeHours = DateTimeRangeList.fromIntervals(calculator.getActiveRanges(cycle.toInterval()));
            DateTimeRangeList activeInCycle = pauses.inverse(cycle).intersect(activeHours);
            elapsedTime += activeInCycle.getDuration();
        }
        return elapsedTime;
    }

    @Override
    public Option<DateTime> getGoalThresholdExceededDate(Timeline timeline, WorkingHoursCalculator calculator, long remainingTime, long thresholdDuration, DateTime startDate, DateTime now) {
        long timeUntilNextThreshold = remainingTime - thresholdDuration;
        if (timeUntilNextThreshold > 0L) {
            DateTimeRangeList dateTimeRangeList = DateTimeRangeList.fromIntervals(calculator.getActiveRanges(now, timeUntilNextThreshold));
            Option<DateTimeRange> last = dateTimeRangeList.last();
            if (last.isEmpty()) {
                return Option.none();
            }
            return Option.some((Object)((DateTimeRange)last.get()).getStop());
        }
        DateTimeRange cycle = new DateTimeRange(startDate, now);
        DateTimeRangeList activeHours = DateTimeRangeList.fromIntervals(calculator.getActiveRanges(cycle.toInterval()));
        DateTimeRangeList pauses = DateTimeRangeList.fromRanges(timeline.getPausedRanges(cycle.getStop()));
        DateTimeRangeList activeInCycle = pauses.inverse(cycle).intersect(activeHours);
        List<DateTimeRange> activeInCycleRanges = activeInCycle.getRanges();
        Collections.reverse(activeInCycleRanges);
        long tmpElapsedTime = -timeUntilNextThreshold;
        for (int j = 0; j < activeInCycleRanges.size(); ++j) {
            DateTimeRange currentCycle = activeInCycleRanges.get(j);
            long cycleDuration = currentCycle.getDuration();
            if (cycleDuration < tmpElapsedTime) {
                tmpElapsedTime -= cycleDuration;
                continue;
            }
            return Option.some((Object)currentCycle.getStop().withDurationAdded(-tmpElapsedTime, 1));
        }
        return Option.none();
    }

    @Override
    public Map<TimeMetricMeasureType, Long> getRemainingTimeInDaysAndMillis(Timeline timeline, WorkingHoursCalculator calculator, DateTime now, DateTime dateGoalShouldBeCompleteBy) {
        DateTimeRangeList cycles = DateTimeRangeList.fromRanges(timeline.getStartedRanges(dateGoalShouldBeCompleteBy));
        Map<TimeMetricMeasureType, Long> remainingTimeInDaysAndMillis = new HashMap<TimeMetricMeasureType, Long>();
        remainingTimeInDaysAndMillis.put(TimeMetricMeasureType.DAYS, 0L);
        remainingTimeInDaysAndMillis.put(TimeMetricMeasureType.REMAINING_MILLIS_WITHIN_DAY, 0L);
        for (DateTimeRange cycle : cycles.getRanges()) {
            DateTimeRangeList pauses = DateTimeRangeList.fromRanges(timeline.getPausedRanges(dateGoalShouldBeCompleteBy));
            DateTimeRangeList activeInCycleFromNowToEnd = this.getActiveHoursInCycleFromNowToEnd(calculator, pauses.inverse(cycle), now, dateGoalShouldBeCompleteBy);
            List<DateTimeRange> activeInCycleFromNowToEndRanges = activeInCycleFromNowToEnd.getRanges();
            if (activeInCycleFromNowToEndRanges.size() <= 0) continue;
            DateTime firstDayActive = activeInCycleFromNowToEndRanges.get(0).getStart();
            DateTimeRange firstDayActiveRange = this.getCompleteActiveRangesForDay(firstDayActive, calculator);
            DateTime lastDayActive = activeInCycleFromNowToEndRanges.get(activeInCycleFromNowToEndRanges.size() - 1).getStop();
            DateTimeRange lastDayActiveRange = this.getCompleteActiveRangesForDay(lastDayActive, calculator);
            remainingTimeInDaysAndMillis = this.getDaysAndMillisForCycle(activeInCycleFromNowToEnd, firstDayActiveRange, lastDayActiveRange, remainingTimeInDaysAndMillis);
        }
        remainingTimeInDaysAndMillis.put(TimeMetricMeasureType.BREACHED, this.isBreached(now, dateGoalShouldBeCompleteBy));
        return remainingTimeInDaysAndMillis;
    }

    private Map<TimeMetricMeasureType, Long> getDaysAndMillisForCycle(DateTimeRangeList activeInCycleFromNowToEnd, DateTimeRange firstDayCompleteActiveHours, DateTimeRange lastDayCompleteActiveHours, Map<TimeMetricMeasureType, Long> pastResults) {
        List<DateTimeRange> activeRangesFromNowToEnd;
        int activeRangesFromNowToEndSize;
        Long days = 0L;
        Long remainingTimeWithinDay = 0L;
        if (pastResults != null) {
            days = pastResults.get(TimeMetricMeasureType.DAYS);
            remainingTimeWithinDay = pastResults.get(TimeMetricMeasureType.REMAINING_MILLIS_WITHIN_DAY);
        }
        if ((activeRangesFromNowToEndSize = (activeRangesFromNowToEnd = activeInCycleFromNowToEnd.getRanges()).size()) > 0 && firstDayCompleteActiveHours != null && lastDayCompleteActiveHours != null) {
            Long l;
            DateTimeRange activeInCycleFirst = activeRangesFromNowToEnd.get(0);
            if (activeInCycleFirst.getDuration() != firstDayCompleteActiveHours.getDuration()) {
                remainingTimeWithinDay = remainingTimeWithinDay + activeInCycleFirst.getDuration();
            } else {
                Long l2 = days;
                l = days = Long.valueOf(days + 1L);
            }
            if (activeRangesFromNowToEndSize > 2) {
                days = days + (long)(activeRangesFromNowToEndSize - 2);
            }
            if (activeRangesFromNowToEndSize > 1) {
                DateTimeRange activeInCycleLast = activeRangesFromNowToEnd.get(activeRangesFromNowToEndSize - 1);
                if (activeInCycleLast.getDuration() != lastDayCompleteActiveHours.getDuration()) {
                    remainingTimeWithinDay = remainingTimeWithinDay + activeInCycleLast.getDuration();
                } else {
                    l = days;
                    Long l3 = days = Long.valueOf(days + 1L);
                }
            }
        }
        HashMap<TimeMetricMeasureType, Long> result = new HashMap<TimeMetricMeasureType, Long>();
        result.put(TimeMetricMeasureType.DAYS, days);
        result.put(TimeMetricMeasureType.REMAINING_MILLIS_WITHIN_DAY, remainingTimeWithinDay);
        return result;
    }

    private DateTimeRange getCompleteActiveRangesForDay(DateTime date, WorkingHoursCalculator calculator) {
        DateTimeRangeList dayCompleteActiveHours = DateTimeRangeList.fromIntervals(calculator.getIntervalsForDay(date.toLocalDate(), date.dayOfMonth().roundFloorCopy(), date.dayOfMonth().roundCeilingCopy()));
        return dayCompleteActiveHours.getRanges().size() > 0 ? dayCompleteActiveHours.getRanges().get(0) : null;
    }

    private DateTimeRangeList getActiveHoursInCycleFromNowToEnd(WorkingHoursCalculator calculator, DateTimeRangeList pausesWithCycle, DateTime completedDate, DateTime expectedCompleteDate) {
        if (completedDate.isAfter((ReadableInstant)expectedCompleteDate)) {
            Interval activeRangesInterval = new Interval((ReadableInstant)expectedCompleteDate, (ReadableInstant)completedDate);
            return DateTimeRangeList.fromIntervals(calculator.getActiveRanges(activeRangesInterval));
        }
        Interval activeRangesInterval = new Interval((ReadableInstant)completedDate, (ReadableInstant)expectedCompleteDate);
        if (pausesWithCycle.size() == 0 || pausesWithCycle.getRanges().get(pausesWithCycle.size() - 1).getStop().isBefore((ReadableInstant)expectedCompleteDate)) {
            return DateTimeRangeList.fromIntervals(calculator.getActiveRanges(activeRangesInterval));
        }
        return pausesWithCycle.intersect(DateTimeRangeList.fromIntervals(calculator.getActiveRanges(activeRangesInterval)));
    }

    private long isBreached(DateTime completedDate, DateTime expectedCompleteDate) {
        return completedDate.isAfter((ReadableInstant)expectedCompleteDate) ? 1L : 0L;
    }
}

