/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.metric;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.sla.metric.BasicCycleData;
import com.atlassian.servicedesk.internal.api.sla.metric.SLALuceneDocumentDataManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLAValueSerializer;
import com.atlassian.servicedesk.internal.sla.metric.CycleMetricData;
import com.atlassian.servicedesk.internal.sla.metric.TimeMetricCalculationService;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.searcher.SLACustomFieldIndexer;
import io.atlassian.fugue.Option;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class SLALuceneDocumentDataManagerImpl
implements SLALuceneDocumentDataManager {
    private static final SLAValueSerializer SERIALIZER = new SLAValueSerializer();
    private final TimeMetricCalculationService calculationManager;

    @Autowired
    public SLALuceneDocumentDataManagerImpl(TimeMetricCalculationService calculationManager) {
        this.calculationManager = calculationManager;
    }

    public String getTimelineFieldIdForIndexing(CustomField customField) {
        return SLACustomFieldIndexer.getTimelineFieldId(customField);
    }

    public Option<BasicCycleData> getDataFromMostRecentCycle(WorkingHoursCalculator defaultCalculator, String rawTimeline, Long issueId, DateTime now) {
        Timeline timeline = SERIALIZER.unserializeTimeline(rawTimeline);
        List<CycleMetricData> allCycleMetricData = this.calculationManager.getAllCycleMetricData(timeline, defaultCalculator, now);
        if (allCycleMetricData.isEmpty()) {
            return Option.none();
        }
        CycleMetricData c = allCycleMetricData.get(allCycleMetricData.size() - 1);
        BasicCycleData data = new BasicCycleData(c.isOngoing, c.getDuration(), c.getRange().getStart(), c.getRange().getStop());
        return Option.some((Object)data);
    }
}

