/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.metric;

import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.api.sla.condition.HitEvent;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogDataHelper;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogInput;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogManager;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinition;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateEventExtractor;
import com.atlassian.servicedesk.internal.sla.metric.TimelineManager;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.model.TimelineEvent;
import com.atlassian.servicedesk.internal.sla.model.TimelineEventType;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricStateEventExtractorImpl
implements MetricStateEventExtractor {
    private static final Log log = Log.with(MetricStateEventExtractorImpl.class);
    private final TimelineManager timelineManager;
    private final TimeMetricDefinitionManager timeMetricDefinitionManager;
    private final SlaAuditLogManager slaAuditLogManager;
    private final SlaAuditLogDataHelper slaAuditLogDataHelper;
    private final SafeRunner safeRunner;

    @Autowired
    public MetricStateEventExtractorImpl(TimelineManager timelineManager, TimeMetricDefinitionManager timeMetricDefinitionManager, SlaAuditLogManager slaAuditLogManager, SlaAuditLogDataHelper slaAuditLogDataHelper, SafeRunner safeRunner) {
        this.timelineManager = timelineManager;
        this.timeMetricDefinitionManager = timeMetricDefinitionManager;
        this.slaAuditLogManager = slaAuditLogManager;
        this.slaAuditLogDataHelper = slaAuditLogDataHelper;
        this.safeRunner = safeRunner;
    }

    @Override
    public Timeline updateTimeline(Timeline timeline, TimelineEvent timelineEvent) {
        return this.timelineManager.appendToTimeline(timeline, timelineEvent);
    }

    @Override
    public Option<TimelineEvent> getTimelineEvent(TimeMetric timeMetric, SLAChangeEvent event, Timeline timeline) {
        TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition> definition = this.timeMetricDefinitionManager.loadDefinition(timeMetric);
        Map<TimelineEventType, Option<TimeMetricCondition>> types = this.calculateTimelineEventTypes(definition, timeline, event);
        DateTime date = this.getIssueEventDate(event);
        Option<TimelineEvent> timelineEvent = this.timelineManager.getTimelineEvent(timeline, date, types.keySet());
        timelineEvent.forEach(tlEvent -> this.safeRunner.run(() -> this.logAuditRecord((TimelineEvent)tlEvent, types, timeMetric, event)));
        return timelineEvent;
    }

    private DateTime getIssueEventDate(SLAChangeEvent event) {
        return new DateTime((Object)event.getTime());
    }

    private Map<TimelineEventType, Option<TimeMetricCondition>> calculateTimelineEventTypes(TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition> definition, Timeline timeline, SLAChangeEvent event) {
        String issueKey = "";
        if (event.getIssue() != null) {
            issueKey = event.getIssue().getKey();
        }
        if (log.isDebugEnabled()) {
            log.debug("Calculating timeline event types for: %s", new Object[]{issueKey});
        }
        TimelineManager.RelevantEventTypes relevantEventTypes = this.timelineManager.getRelevantEventTypes(timeline);
        HashMap matchedTypes = new HashMap();
        if (log.isDebugEnabled()) {
            log.debug("%s: Determined the following relevant event types: Start - %s , Pause - %s, Stop - %s", new Object[]{issueKey, relevantEventTypes.isStart(), relevantEventTypes.isPause(), relevantEventTypes.isStop()});
        }
        if (relevantEventTypes.isStart()) {
            Set<TimeMetricHitCondition> startConditions = definition.getStartConditions();
            if (log.isDebugEnabled()) {
                log.debug("%s: number of start conditions - %s", new Object[]{issueKey, startConditions.size()});
                startConditions.forEach(hitCondition -> log.debug(this.safeClass(hitCondition), new Object[0]));
            }
            this.isHit(startConditions, event).forEach(condition -> matchedTypes.put(TimelineEventType.START, Option.some((Object)condition)));
        }
        if (relevantEventTypes.isPause()) {
            Set<TimeMetricMatchCondition> pauseConditions = definition.getPauseConditions();
            if (log.isDebugEnabled()) {
                log.debug("%s: number of pause conditions - %s", new Object[]{issueKey, pauseConditions.size()});
                pauseConditions.forEach(matchCondition -> log.debug(this.safeClass(matchCondition), new Object[0]));
            }
            this.isMatch(pauseConditions, event).fold(() -> matchedTypes.put(TimelineEventType.UNPAUSE, Option.none()), condition -> matchedTypes.put(TimelineEventType.PAUSE, Option.some((Object)condition)));
        }
        if (relevantEventTypes.isStop()) {
            Set<TimeMetricHitCondition> stopConditions = definition.getStopConditions();
            if (log.isDebugEnabled()) {
                log.debug("%s: number of stop conditions - %s", new Object[]{issueKey, stopConditions.size()});
                stopConditions.forEach(hitCondition -> log.debug(this.safeClass(hitCondition), new Object[0]));
            }
            this.isHit(stopConditions, event).forEach(condition -> matchedTypes.put(TimelineEventType.STOP, Option.some((Object)condition)));
        }
        return Collections.unmodifiableMap(matchedTypes);
    }

    private Option<TimeMetricHitCondition> isHit(Set<TimeMetricHitCondition> conditions, SLAChangeEvent event) {
        for (TimeMetricHitCondition condition : conditions) {
            if (this.safeEvaluate(event, condition) != HitEvent.HIT) continue;
            return Option.some((Object)condition);
        }
        return Option.none();
    }

    private Option<TimeMetricMatchCondition> isMatch(Set<TimeMetricMatchCondition> conditions, SLAChangeEvent event) {
        for (TimeMetricMatchCondition condition : conditions) {
            if (this.safeEvaluate(event, condition) != MatchEvent.MATCH) continue;
            return Option.some((Object)condition);
        }
        return Option.none();
    }

    private HitEvent safeEvaluate(SLAChangeEvent event, TimeMetricHitCondition condition) {
        try {
            return condition.evaluate(event.getIssue(), event);
        }
        catch (Exception e) {
            log.warnDebug(e, "An %s exception was thrown evaluating hit condition of type %s", new Object[]{e.getMessage(), this.safeClass(condition)});
            return HitEvent.NO_HIT;
        }
    }

    private MatchEvent safeEvaluate(SLAChangeEvent event, TimeMetricMatchCondition condition) {
        try {
            return condition.evaluate(event.getIssue(), event);
        }
        catch (Exception e) {
            log.warnDebug(e, "An %s exception was thrown evaluating match condition of type %s", new Object[]{e.getMessage(), this.safeClass(condition)});
            return MatchEvent.INVERSE_MATCH;
        }
    }

    private String safeClass(Object condition) {
        return condition == null ? "Null Condition" : condition.getClass().getName();
    }

    private void logAuditRecord(TimelineEvent timelineEvent, Map<TimelineEventType, Option<TimeMetricCondition>> eventTypes, TimeMetric timeMetric, SLAChangeEvent event) {
        List<SlaAuditLogInput> inputs = timelineEvent.getTypes().stream().map(type -> this.createInput(timelineEvent, (TimelineEventType)((Object)type), (Option<TimeMetricCondition>)((Option)eventTypes.get(type)), timeMetric, event)).collect(Collectors.toList());
        this.slaAuditLogManager.createAuditLogRecords(inputs);
    }

    private SlaAuditLogInput createInput(TimelineEvent timelineEvent, TimelineEventType type, Option<TimeMetricCondition> condition, TimeMetric timeMetric, SLAChangeEvent event) {
        return new SlaAuditLogInput((Option<Long>)Option.some((Object)event.getIssue().getId()), (Option<Long>)Option.some((Object)timeMetric.getId().longValue()), (Option<SlaAuditLogReason>)Option.some((Object)((Object)SlaAuditLogReason.ISSUE_EVENT)), timelineEvent.getDate().getMillis(), (Option<Map<String, String>>)Option.some(this.getIssueEventAuditData(type, condition, event.getIssue())));
    }

    private Map<String, String> getIssueEventAuditData(TimelineEventType type, Option<TimeMetricCondition> condition, Issue issue) {
        return this.slaAuditLogDataHelper.determineIssueEventAuditData(type, condition, issue);
    }
}

