/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.listener;

import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.data.SlaDataManager;
import com.atlassian.servicedesk.internal.sla.listener.SLAChangeEventImpl;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractor;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractorConfig;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseHelper;
import com.atlassian.servicedesk.internal.util.IssueIndexingHelper;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaCycleUpdater {
    private final ServiceDeskManager serviceDeskManager;
    private final IssueEventHelper issueEventUtil;
    private final IssueIndexManager issueIndexManager;
    private final MetricStateHistoryExtractor metricStateHistoryExtractor;
    private final SafeRunner safeRunner;
    private final SlaDataManager slaDataManager;
    private final TimedPromiseHelper timedPromiseHelper;
    private final IssueManager issueManager;

    @Autowired
    public SlaCycleUpdater(ServiceDeskManager serviceDeskManager, IssueEventHelper issueEventUtil, IssueIndexManager issueIndexManager, MetricStateHistoryExtractor metricStateHistoryExtractor, SafeRunner safeRunner, SlaDataManager slaDataManager, TimedPromiseHelper timedPromiseHelper, IssueManager issueManager) {
        this.serviceDeskManager = serviceDeskManager;
        this.issueEventUtil = issueEventUtil;
        this.issueIndexManager = issueIndexManager;
        this.metricStateHistoryExtractor = metricStateHistoryExtractor;
        this.safeRunner = safeRunner;
        this.slaDataManager = slaDataManager;
        this.timedPromiseHelper = timedPromiseHelper;
        this.issueManager = issueManager;
    }

    public void onIssueEvent(IssueEvent event) {
        this.safeRunner.run(() -> this.runCycleUpdate(event));
    }

    public void onIssueChangedEvent(IssueChangedEvent event) {
        this.safeRunner.run(() -> this.processEvent(new SLAChangeEventImpl(event)));
    }

    public void onCommentCreatedEvent(CommentCreatedEvent event) {
        this.safeRunner.run(() -> this.processEvent(new SLAChangeEventImpl(event)));
    }

    private void runCycleUpdate(IssueEvent event) {
        if (this.issueEventUtil.isDeletedEvent(event)) {
            this.processIssueDeletedEvent(event);
            return;
        }
        Option reloadedIssue = Option.option((Object)event.getIssue()).map(Issue::getId).map(arg_0 -> ((IssueManager)this.issueManager).getIssueObject(arg_0));
        this.processEvent(new SLAChangeEventImpl(event, this.issueEventUtil.isCreatedEvent(event), this.issueEventUtil.getChangeItemBeans(event), (Option<Issue>)reloadedIssue));
    }

    private void processIssueDeletedEvent(IssueEvent event) {
        this.timedPromiseHelper.unscheduleSlaThresholdEventTimedPromise(event.getIssue(), "SLA Threshold Events - unscheduled timed promise for issue " + event.getIssue().getKey() + ", as it has just been deleted");
    }

    private void processEvent(SLAChangeEvent event) {
        Option.option((Object)event.getProject()).flatMap(project -> this.serviceDeskManager.getServiceDeskForProject(project).toOption()).fold(() -> this.processJiraProjectEvent(event), serviceDesk -> this.processServiceDeskProjectEvent(event, (ServiceDesk)serviceDesk));
    }

    private Unit processJiraProjectEvent(SLAChangeEvent event) {
        this.slaDataManager.processFromSlaChangeEventIfProjectMoved(event);
        return Unit.Unit();
    }

    private Unit processServiceDeskProjectEvent(SLAChangeEvent event, ServiceDesk serviceDesk) {
        boolean moveEvent = this.slaDataManager.processFromSlaChangeEventIfProjectMoved(event);
        if (moveEvent) {
            this.handleIssueMovedBetweenProjects(event, serviceDesk);
        } else {
            this.slaDataManager.processSlasFromIssueEvent(event, serviceDesk);
        }
        return Unit.Unit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIssueMovedBetweenProjects(SLAChangeEvent event, ServiceDesk serviceDesk) {
        IssueIndexingHelper.reindexIssue(event.getIssue(), this.issueIndexManager);
        IssueIndexingHelper.IndexingContext indexingContext = IssueIndexingHelper.activateIndexing(this.issueIndexManager);
        try {
            MetricStateHistoryExtractorConfig config = this.metricStateHistoryExtractor.loadConfiguration(serviceDesk);
            this.metricStateHistoryExtractor.extractTimeMetricHistory(event.getIssue(), config, (Option<SlaAuditLogReason>)Option.some((Object)((Object)SlaAuditLogReason.MOVED_ISSUE_BETWEEN_PROJECTS)));
        }
        finally {
            IssueIndexingHelper.resetIndexingToPrevious(indexingContext, this.issueIndexManager);
        }
    }
}

