/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.listener;

import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SLAChangeEventImpl
implements SLAChangeEvent {
    private final Collection<ChangeItemBean> changeItems;
    private final Optional<Comment> comment;
    private final boolean issueCreatedEvent;
    private final Issue issue;
    private final Project project;
    private final Date time;

    SLAChangeEventImpl(IssueChangedEvent issueChangedEvent) {
        this.changeItems = issueChangedEvent.getChangeItems();
        this.comment = issueChangedEvent.getComment();
        this.issue = issueChangedEvent.getIssue();
        this.issueCreatedEvent = false;
        this.project = issueChangedEvent.getIssue().getProjectObject();
        this.time = issueChangedEvent.getTime();
    }

    SLAChangeEventImpl(CommentCreatedEvent commentCreatedEvent) {
        this.changeItems = Collections.emptyList();
        this.comment = Optional.of(commentCreatedEvent.getComment());
        this.issue = commentCreatedEvent.getComment().getIssue();
        this.issueCreatedEvent = false;
        this.project = commentCreatedEvent.getComment().getIssue().getProjectObject();
        this.time = commentCreatedEvent.getComment().getCreated();
    }

    SLAChangeEventImpl(IssueEvent issueEvent, boolean isCreatedEvent, List<ChangeItemBean> changeItems, Option<Issue> issue) {
        this.changeItems = changeItems;
        this.comment = Optional.ofNullable(issueEvent.getComment());
        this.issue = (Issue)issue.getOr(() -> ((IssueEvent)issueEvent).getIssue());
        this.project = issueEvent.getProject();
        this.time = issueEvent.getTime();
        this.issueCreatedEvent = isCreatedEvent;
    }

    @Nonnull
    public Optional<Comment> getComment() {
        return this.comment;
    }

    @Nonnull
    public Issue getIssue() {
        return this.issue;
    }

    public boolean isIssueCreatedEvent() {
        return this.issueCreatedEvent;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    @Nonnull
    public Date getTime() {
        return this.time;
    }

    @Nonnull
    public Collection<ChangeItemBean> getChangeItems() {
        return this.changeItems;
    }

    @Nonnull
    public Optional<ChangeItemBean> getChangeItemForField(@Nonnull String fieldName) {
        return this.changeItems.stream().filter(change -> Objects.equals(change.getField(), fieldName)).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLAChangeEventImpl that = (SLAChangeEventImpl)o;
        return this.issueCreatedEvent == that.issueCreatedEvent && com.google.common.base.Objects.equal(this.changeItems, that.changeItems) && com.google.common.base.Objects.equal(this.comment, that.comment) && com.google.common.base.Objects.equal((Object)this.issue, (Object)that.issue) && com.google.common.base.Objects.equal((Object)this.project, (Object)that.project) && com.google.common.base.Objects.equal((Object)this.time, (Object)that.time);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.changeItems, this.comment, this.issueCreatedEvent, this.issue, this.project, this.time});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changeItems", this.changeItems).add("comment", this.comment).add("issueCreatedEvent", this.issueCreatedEvent).add("issue", (Object)this.issue).add("project", (Object)this.project).add("time", (Object)this.time).toString();
    }
}

