/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.info;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorCollectionHelper;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.api.sla.info.SlaInformationCompletedCycle;
import com.atlassian.servicedesk.api.sla.info.SlaInformationOngoingCycle;
import com.atlassian.servicedesk.api.sla.info.SlaInformationQuery;
import com.atlassian.servicedesk.api.sla.info.SlaInformationService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.sla.util.SlaDurationFormatter;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueManager;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import com.atlassian.servicedesk.internal.sla.goal.GoalCalculationService;
import com.atlassian.servicedesk.internal.sla.goal.OngoingGoalStatus;
import com.atlassian.servicedesk.internal.sla.info.SlaInformationCompletedCycleImpl;
import com.atlassian.servicedesk.internal.sla.info.SlaInformationImpl;
import com.atlassian.servicedesk.internal.sla.info.SlaInformationOngoingCycleImpl;
import com.atlassian.servicedesk.internal.sla.info.SlaInformationQueryImpl;
import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class SlaInformationServiceImpl
implements SlaInformationService {
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final GoalCalculationService goalCalculationService;
    private final InternalServiceDeskService internalServiceDeskService;
    private final InternalTimeMetricService timeMetricService;
    private final UserFactory userFactory;
    private final ServiceDeskIssueManager sdIssueManager;
    private final CustomFieldManager customFieldManager;
    private final GoalService goalService;
    private final SlaDurationFormatter slaDurationFormatter;
    private final ErrorResultHelper errorResultHelper;
    private final SLAFieldManager slaFieldManager;

    @Autowired
    public SlaInformationServiceImpl(ServiceDeskPermissionService serviceDeskPermissionService, GoalCalculationService goalCalculationService, InternalServiceDeskService internalServiceDeskService, InternalTimeMetricService timeMetricService, UserFactory userFactory, ServiceDeskIssueManager sdIssueManager, CustomFieldManager customFieldManager, GoalService goalService, SlaDurationFormatter slaDurationFormatter, ErrorResultHelper errorResultHelper, SLAFieldManager slaFieldManager) {
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.userFactory = userFactory;
        this.sdIssueManager = sdIssueManager;
        this.goalCalculationService = goalCalculationService;
        this.internalServiceDeskService = internalServiceDeskService;
        this.timeMetricService = timeMetricService;
        this.customFieldManager = customFieldManager;
        this.goalService = goalService;
        this.slaDurationFormatter = slaDurationFormatter;
        this.errorResultHelper = errorResultHelper;
        this.slaFieldManager = slaFieldManager;
    }

    public SlaInformationQuery.Builder newInfoQueryBuilder() {
        return SlaInformationQueryImpl.builder();
    }

    public SlaInformationService.DurationFormatter getDurationFormatter() {
        return new SlaInformationService.DurationFormatter(){

            public String format(ApplicationUser user, long durationMS) {
                return SlaInformationServiceImpl.this.slaDurationFormatter.getLongFormattedRemainingDuration(durationMS, user);
            }

            public String formatShort(ApplicationUser user, long durationMS) {
                return SlaInformationServiceImpl.this.slaDurationFormatter.getShortFormattedRemainingDuration(durationMS, user);
            }
        };
    }

    public Either<AnError, PagedResponse<SlaInformation>> getInfo(ApplicationUser user, SlaInformationQuery query) {
        Long issueId = query.issue();
        return Steps.begin((Either)this.userFactory.wrap(user)).then(agent -> StepsConverters.olderEither(this.sdIssueManager.getIssueById(issueId))).then(this::validateSLAAccess).then((agent, issue, serviceDesk) -> this.getSlaInfoForQuery((CheckedUser)agent, (Issue)issue, (ServiceDesk)serviceDesk, query)).yield((agent, issue, serviceDesk, slaInfo) -> slaInfo);
    }

    private Either<AnError, PagedResponse<SlaInformation>> getSlaInfoForQuery(CheckedUser agent, Issue issue, ServiceDesk serviceDesk, SlaInformationQuery query) {
        ImmutableList timeMetrics;
        Object specificTimeMetric;
        DateTime dtNow = new DateTime();
        ArrayList slaInformation = new ArrayList();
        Optional specifiedCF = query.customField();
        if (query.id().isPresent()) {
            specificTimeMetric = StepsConverters.olderEither(this.timeMetricService.getTimeMetric(agent.forJIRA(), serviceDesk, ((Long)query.id().get()).intValue()));
            if (specificTimeMetric.isLeft()) {
                return this.exitLeft(specificTimeMetric.leftMap(ErrorCollectionHelper::toAnError));
            }
            timeMetrics = ImmutableList.of((Object)specificTimeMetric.right().get());
        } else if (specifiedCF.isPresent()) {
            specificTimeMetric = StepsConverters.olderEither(this.timeMetricService.getTimeMetric(agent.forJIRA(), serviceDesk, (CustomField)specifiedCF.get()));
            if (specificTimeMetric.isLeft()) {
                return this.exitLeft(specificTimeMetric.leftMap(ErrorCollectionHelper::toAnError));
            }
            timeMetrics = ImmutableList.of((Object)specificTimeMetric.right().get());
        } else {
            timeMetrics = this.timeMetricService.getTimeMetrics(agent.forJIRA(), serviceDesk);
        }
        for (TimeMetric timeMetric : timeMetrics) {
            Long customFieldId = timeMetric.getCustomFieldId();
            Option<CustomField> customField = this.getCustomFieldWithId(customFieldId);
            if (!customField.isDefined()) continue;
            Either<AnError, Option<SlaInformation>> slaInfoForCustomField = this.getSlaInfoForCustomField(agent, issue, serviceDesk, (CustomField)customField.get(), timeMetric, dtNow);
            if (slaInfoForCustomField.isLeft()) {
                return this.exitLeft(slaInfoForCustomField);
            }
            Option slaInfo = (Option)slaInfoForCustomField.right().get();
            slaInfo.foreach(slaInformation::add);
        }
        PagedResponse pagedResponse = PagedResponseImpl.sortAndToPagedResponse((LimitedPagedRequest)query.pagedRequest(), slaInformation, this.sortByNameComparator());
        return Either.right((Object)pagedResponse);
    }

    private Either<AnError, Option<SlaInformation>> getSlaInfoForCustomField(CheckedUser agent, Issue issue, ServiceDesk serviceDesk, CustomField customField, TimeMetric timeMetric, DateTime dtNow) {
        Option slaValueResult = StepsConverters.olderOption(this.slaFieldManager.getOptionalFieldValue(issue, customField));
        if (slaValueResult.isDefined()) {
            SLAValue slaValue = (SLAValue)slaValueResult.get();
            Either<AnError, Option<Goal>> goalResult = this.getGoal(agent, serviceDesk, customField, slaValue, timeMetric);
            if (goalResult.isLeft()) {
                return this.exitLeft(goalResult);
            }
            Option goalDef = (Option)goalResult.right().get();
            Option ongoingGoalStatusResult = goalDef.flatMap(goal -> StepsConverters.olderOption(this.goalCalculationService.getOngoingGoalStatus((Goal)((Object)goal), slaValue, dtNow)));
            SlaInformation slaInfo = this.buildSlaInfo(timeMetric, (Option<OngoingGoalStatus>)ongoingGoalStatusResult, slaValue.getCompleteSLAData());
            return Either.right((Object)Option.some((Object)slaInfo));
        }
        return Either.right((Object)Option.none());
    }

    private Either<AnError, ServiceDesk> validateSLAAccess(CheckedUser checkedUser, Issue issue) {
        return Steps.begin((Either)StepsConverters.olderEither((io.atlassian.fugue.Either)this.internalServiceDeskService.getServiceDeskForProject(checkedUser, issue.getProjectObject(), false))).then(sd -> this.isAgent(checkedUser, (ServiceDesk)sd)).yield((sd, validAgent) -> sd);
    }

    private Either<AnError, Boolean> isAgent(CheckedUser checkedUser, ServiceDesk sd) {
        Either agentCheck = this.serviceDeskPermissionService.isAgent(checkedUser.forJIRA(), sd);
        return agentCheck.flatMap(isAgent2 -> isAgent2 != false ? Either.right((Object)true) : this.slaAccessNotAllowed(checkedUser));
    }

    private Either<AnError, Boolean> slaAccessNotAllowed(CheckedUser checkedUser) {
        return this.errorResultHelper.error(checkedUser.forJIRA(), HttpStatusCode.FORBIDDEN, "sd.sla.field.service.permission.error.fetch", new Object[0]);
    }

    private Either<AnError, Option<Goal>> getGoal(CheckedUser checkedUser, ServiceDesk serviceDesk, CustomField slaField, SLAValue slaValue, TimeMetric timeMetric) {
        OngoingSLAData ongoingSLAData = slaValue.getOngoingSLAData();
        if (ongoingSLAData == null) {
            return Either.right((Object)Option.none());
        }
        Either timeMetricResult = StepsConverters.olderEither(this.timeMetricService.getTimeMetric(checkedUser.forJIRA(), serviceDesk, slaField));
        if (timeMetricResult.isLeft()) {
            return this.exitLeft(timeMetricResult.leftMap(ErrorCollectionHelper::toAnError));
        }
        Either goal = StepsConverters.olderEither(this.goalService.getGoal(checkedUser.forJIRA(), timeMetric, ongoingSLAData.getGoalId()));
        if (goal.isLeft()) {
            return this.exitLeft(goal.leftMap(ErrorCollectionHelper::toAnError));
        }
        return Either.right((Object)goal.right().toOption());
    }

    private SlaInformation buildSlaInfo(TimeMetric timeMetric, Option<OngoingGoalStatus> ongoingGoalStatusResult, List<CompleteSLAData> completeSLAData) {
        SlaInformationImpl.Builder builder = SlaInformationImpl.builder();
        builder.setId(timeMetric.getId().longValue());
        builder.setName(timeMetric.getName());
        List completedCycles = FpKit.map(completeSLAData, this::toCompletedCycle);
        builder.addCompletedCycles(completedCycles);
        Optional<SlaInformationOngoingCycle> ongoingCycle = this.toOptional(ongoingGoalStatusResult.map(this::toOngoingCycle));
        builder.setOngoingCycle(ongoingCycle);
        return builder.build();
    }

    private SlaInformationCompletedCycle toCompletedCycle(CompleteSLAData input) {
        Long goalMillis = input.getGoalTime();
        Long started = input.getStartTime().getMillis();
        Long ended = started + input.getElapsedTime();
        Long remaining = started + goalMillis - ended;
        return SlaInformationCompletedCycleImpl.builder().setBreached(!input.isSucceeded()).setElapsedTime(input.getElapsedTime()).setGoalDuration(goalMillis).setRemainingTime(remaining).setStartTime(this.asInstant(input.getStartTime())).setStopTime(this.asInstant(input.getStopTime())).build();
    }

    private SlaInformationOngoingCycle toOngoingCycle(OngoingGoalStatus input) {
        return SlaInformationOngoingCycleImpl.builder().setBreached(input.isBreached()).setBreachTime(Optional.ofNullable(input.getBreachedDate()).map(this::asInstant)).setElapsedTime(input.getElapsedTime()).setGoalDuration(input.getTargetTime()).setRemainingTime(input.getRemainingTime()).setPaused(input.isPaused()).setStartTime(this.asInstant(input.getStartDate())).setWithinCalendarHours(input.isActive()).build();
    }

    private Option<CustomField> getCustomFieldWithId(Long customFieldId) {
        return Option.option((Object)this.customFieldManager.getCustomFieldObject(customFieldId));
    }

    private Comparator<SlaInformation> sortByNameComparator() {
        return Comparator.comparing(SlaInformation::getName);
    }

    private Instant asInstant(DateTime dateTime) {
        return Instant.ofEpochMilli(dateTime.getMillis());
    }

    private <T> Optional<T> toOptional(Option<T> option) {
        return Optional.ofNullable(option.getOrNull());
    }

    private <T, S> Either<AnError, T> exitLeft(Either<AnError, S> leftEither) {
        return Either.left((Object)leftEither.left().get());
    }
}

