/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.info;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.servicedesk.api.sla.info.SlaInformationQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.google.common.base.Preconditions;
import java.util.Optional;

class SlaInformationQueryImpl
implements SlaInformationQuery {
    private final Long issueId;
    private final Optional<Long> slaMetricId;
    private final Optional<CustomField> customField;
    private final LimitedPagedRequest limitedPagedRequest;

    private SlaInformationQueryImpl(Long issueId, Optional<CustomField> customField, LimitedPagedRequest limitedPagedRequest, Optional<Long> slaMetricId) {
        this.slaMetricId = slaMetricId;
        this.issueId = (Long)Preconditions.checkNotNull((Object)issueId);
        this.customField = (Optional)Preconditions.checkNotNull(customField);
        this.limitedPagedRequest = (LimitedPagedRequest)Preconditions.checkNotNull((Object)limitedPagedRequest);
    }

    public Long issue() {
        return this.issueId;
    }

    public Optional<CustomField> customField() {
        return this.customField;
    }

    public Optional<Long> id() {
        return this.slaMetricId;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.limitedPagedRequest;
    }

    static SlaInformationQuery.Builder builder() {
        return new SlaInformationQuery.Builder(){
            Long issueId;
            Optional<Long> slaMetricId = Optional.empty();
            Optional<CustomField> customField = Optional.empty();
            LimitedPagedRequest limitedPagedRequest = LimitedPagedRequestImpl.create((int)50);

            public SlaInformationQuery.Builder issue(Long issueId) {
                this.issueId = (Long)Preconditions.checkNotNull((Object)issueId);
                return this;
            }

            public SlaInformationQuery.Builder customField(CustomField customField) {
                this.customField = Optional.of(customField);
                return this;
            }

            public SlaInformationQuery.Builder pagedRequest(PagedRequest pagedRequest) {
                this.limitedPagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)50);
                return this;
            }

            public SlaInformationQuery.Builder id(Long slaMetricId) {
                this.slaMetricId = Optional.of(slaMetricId);
                return this;
            }

            public SlaInformationQuery build() {
                Preconditions.checkNotNull((Object)this.issueId);
                return new SlaInformationQueryImpl(this.issueId, this.customField, this.limitedPagedRequest, this.slaMetricId);
            }
        };
    }
}

