/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.info;

import com.atlassian.servicedesk.api.sla.info.SlaInformationOngoingCycle;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Optional;

class SlaInformationOngoingCycleImpl
implements SlaInformationOngoingCycle {
    private final Instant startTime;
    private final Optional<Instant> breachTime;
    private final boolean breached;
    private final boolean paused;
    private final boolean withinCalendarHours;
    private final Long goalDuration;
    private final Long elapsedTime;
    private final Long remainingTime;

    private SlaInformationOngoingCycleImpl(Instant startTime, Optional<Instant> breachTime, boolean breached, boolean paused, boolean withinCalendarHours, Long goalDuration, Long elapsedTime, Long remainingTime) {
        this.startTime = (Instant)Preconditions.checkNotNull((Object)startTime);
        this.breachTime = (Optional)Preconditions.checkNotNull(breachTime);
        this.breached = breached;
        this.paused = paused;
        this.withinCalendarHours = withinCalendarHours;
        this.goalDuration = (Long)Preconditions.checkNotNull((Object)goalDuration);
        this.elapsedTime = (Long)Preconditions.checkNotNull((Object)elapsedTime);
        this.remainingTime = (Long)Preconditions.checkNotNull((Object)remainingTime);
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Optional<Instant> getBreachTime() {
        return this.breachTime;
    }

    public boolean getBreached() {
        return this.breached;
    }

    public boolean getPaused() {
        return this.paused;
    }

    public boolean getWithinCalendarHours() {
        return this.withinCalendarHours;
    }

    public Long getGoalDuration() {
        return this.goalDuration;
    }

    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    public Long getRemainingTime() {
        return this.remainingTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SlaInformationOngoingCycleImpl data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlaInformationOngoingCycleImpl that = (SlaInformationOngoingCycleImpl)o;
        return Objects.equal((Object)this.startTime, (Object)that.startTime) && Objects.equal(this.breachTime, that.breachTime) && Objects.equal((Object)this.breached, (Object)that.breached) && Objects.equal((Object)this.paused, (Object)that.paused) && Objects.equal((Object)this.withinCalendarHours, (Object)that.withinCalendarHours) && Objects.equal((Object)this.goalDuration, (Object)that.goalDuration) && Objects.equal((Object)this.elapsedTime, (Object)that.elapsedTime) && Objects.equal((Object)this.remainingTime, (Object)that.remainingTime);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.startTime, this.breachTime, this.breached, this.paused, this.withinCalendarHours, this.goalDuration, this.elapsedTime, this.remainingTime});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("startTime", (Object)this.startTime).add("breachTime", this.breachTime).add("breached", this.breached).add("paused", this.paused).add("withinCalendarHours", this.withinCalendarHours).add("goalDuration", (Object)this.goalDuration).add("elapsedTime", (Object)this.elapsedTime).add("remainingTime", (Object)this.remainingTime).toString();
    }

    public static final class Builder {
        private Instant startTime;
        private Optional<Instant> breachTime;
        private boolean breached;
        private boolean paused;
        private boolean withinCalendarHours;
        private Long goalDuration;
        private Long elapsedTime;
        private Long remainingTime;

        private Builder() {
        }

        private Builder(SlaInformationOngoingCycleImpl initialData) {
            this.startTime = initialData.startTime;
            this.breachTime = initialData.breachTime;
            this.breached = initialData.breached;
            this.paused = initialData.paused;
            this.withinCalendarHours = initialData.withinCalendarHours;
            this.goalDuration = initialData.goalDuration;
            this.elapsedTime = initialData.elapsedTime;
            this.remainingTime = initialData.remainingTime;
        }

        public Builder setStartTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder setBreachTime(Optional<Instant> breachTime) {
            this.breachTime = breachTime;
            return this;
        }

        public Builder setBreached(boolean breached) {
            this.breached = breached;
            return this;
        }

        public Builder setPaused(boolean paused) {
            this.paused = paused;
            return this;
        }

        public Builder setWithinCalendarHours(boolean withinCalendarHours) {
            this.withinCalendarHours = withinCalendarHours;
            return this;
        }

        public Builder setGoalDuration(Long goalDuration) {
            this.goalDuration = goalDuration;
            return this;
        }

        public Builder setElapsedTime(Long elapsedTime) {
            this.elapsedTime = elapsedTime;
            return this;
        }

        public Builder setRemainingTime(Long remainingTime) {
            this.remainingTime = remainingTime;
            return this;
        }

        public SlaInformationOngoingCycleImpl build() {
            return new SlaInformationOngoingCycleImpl(this.startTime, this.breachTime, this.breached, this.paused, this.withinCalendarHours, this.goalDuration, this.elapsedTime, this.remainingTime);
        }
    }
}

