/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.goal.view;

import com.atlassian.servicedesk.internal.sla.goal.OngoingGoalStatus;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalColor;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalColorService;
import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import io.atlassian.fugue.Option;
import org.springframework.stereotype.Component;

@Component
public class GoalColorServiceImpl
implements GoalColorService {
    private static final long STANDARD_LOW_REMAINING_TIME = 1800000L;
    private static final long STANDARD_AVG_REMAINING_TIME = 3600000L;

    @Override
    public Option<GoalColor> computeGoalColor(OngoingGoalStatus ongoingGoalStatus) {
        if (ongoingGoalStatus.hasFailed()) {
            return Option.some((Object)((Object)GoalColor.BREACHED));
        }
        if (ongoingGoalStatus.getRemainingTime() < 1800000L) {
            return Option.some((Object)((Object)GoalColor.URGENT));
        }
        if (ongoingGoalStatus.getRemainingTime() < 3600000L) {
            return Option.some((Object)((Object)GoalColor.IMPORTANT));
        }
        return Option.none();
    }

    @Override
    public Option<GoalColor> computeGoalColor(CompleteSLAData data) {
        if (data.isSucceeded()) {
            return Option.none();
        }
        return Option.some((Object)((Object)GoalColor.BREACHED));
    }
}

