/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.goal;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.goal.GoalCalculationService;
import com.atlassian.servicedesk.internal.sla.goal.GoalMatcher;
import com.atlassian.servicedesk.internal.sla.goal.IssueIndexingContext;
import com.atlassian.servicedesk.internal.sla.goal.OngoingGoalStatus;
import com.atlassian.servicedesk.internal.sla.goal.SlaUpdateManager;
import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.model.TimelineEvent;
import com.atlassian.servicedesk.internal.sla.model.TimelineEventType;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaUpdateManagerImpl
implements SlaUpdateManager {
    @Autowired
    private GoalMatcher goalMatcher;
    @Autowired
    private CalendarReferenceManager calendarReferenceManager;
    @Autowired
    private GoalCalculationService calculationManager;
    @Autowired
    private I18nHelper.BeanFactory i18nFactory;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private GoalManager goalManager;
    @Autowired
    private GoalCalculationService goalCalculationService;
    @Autowired
    private FeatureManager featureManager;

    @Override
    public void calculateSlaForSpecialDebugAndAdminPurposes(TimeMetric timeMetric, Issue issue, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal, SLAValue.Builder slaValueBuilder) {
        this.restoreOngoingSLAState(slaValueBuilder);
        if (slaValueBuilder.getOngoingSLAData() != null) {
            this.setOngoingSLAGoal(timeMetric, goal, slaValueBuilder);
        }
    }

    @Override
    public boolean restoreSla(TimeMetric timeMetric, Issue issue, SLAValue.Builder slaValueBuilder, boolean timelineHasChanged) {
        boolean changed = false;
        if (timelineHasChanged) {
            this.restoreOngoingSLAState(slaValueBuilder);
            changed = true;
        }
        if (slaValueBuilder.getOngoingSLAData() != null) {
            changed = this.restoreOngoingSLAGoal(timeMetric, issue, slaValueBuilder) || changed;
        }
        return changed;
    }

    private void restoreOngoingSLAState(SLAValue.Builder builder) {
        Option<TimelineEvent> lastOccurenceOfEvent = builder.getTimeline().getLastOccurenceOfEvent(Timeline.START_AND_STOP);
        if (lastOccurenceOfEvent.isDefined() && ((TimelineEvent)lastOccurenceOfEvent.get()).getTypes().contains((Object)TimelineEventType.START)) {
            TimelineEvent timelineEvent = (TimelineEvent)lastOccurenceOfEvent.get();
            OngoingSLAData data = builder.getOngoingSLADataBuilder().startTime(timelineEvent.getDate()).paused(builder.getTimeline().isPaused()).build();
            builder.ongoingSLAData(data);
        } else {
            builder.clearOngoingSLAData();
        }
    }

    private boolean restoreOngoingSLAGoal(TimeMetric timeMetric, Issue issue, SLAValue.Builder valueBuilder) {
        Either<ErrorCollection, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal> goalEither;
        Integer goalId;
        Long goalsChangeMsEpoch = timeMetric.getGoalsChangeMsEpoch();
        boolean goalsHaveChanged = valueBuilder.getGoalsChangeMsEpoch() == null || !valueBuilder.getGoalsChangeMsEpoch().equals(goalsChangeMsEpoch);
        boolean updateGoalData = true;
        com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal = null;
        if (!goalsHaveChanged && (goalId = valueBuilder.getOngoingSLAData().getGoalId()) != null && (goalEither = this.goalManager.getGoal(timeMetric, goalId)).isRight()) {
            boolean goalTimeIsUpToDate;
            goal = (com.atlassian.servicedesk.internal.sla.configuration.goal.Goal)((Object)goalEither.right().get());
            Long goalTimeUpdatedMsEpoch = goal.getTimeUpdatedMsEpoch();
            Long storedGoalTimeMsEpoch = valueBuilder.getGoalTimeUpdatedMsEpoch();
            boolean bl = goalTimeIsUpToDate = storedGoalTimeMsEpoch != null && storedGoalTimeMsEpoch.equals(goalTimeUpdatedMsEpoch);
            if (goalTimeIsUpToDate) {
                updateGoalData = false;
            }
        }
        if (updateGoalData) {
            if (goal == null) {
                goal = this.goalMatcher.getMatchingGoal(issue, timeMetric, IssueIndexingContext.noIndexing());
            }
            this.setOngoingSLAGoal(timeMetric, goal, valueBuilder);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSla(TimeMetric timeMetric, Issue issue, Option<TimelineEvent> timelineEventResult, SLAValue.Builder slaValueBuilder, IssueIndexingContext issueIndexingContext) {
        if (timelineEventResult.isDefined()) {
            return this.updateOngoingSLAState(timeMetric, issue, (TimelineEvent)timelineEventResult.get(), slaValueBuilder, issueIndexingContext);
        }
        if (slaValueBuilder.getOngoingSLAData() != null) {
            return this.updateOngoingSLAGoal(timeMetric, issue, slaValueBuilder, issueIndexingContext);
        }
        return false;
    }

    private boolean updateOngoingSLAState(TimeMetric timeMetric, Issue issue, TimelineEvent timelineEvent, SLAValue.Builder valueBuilder, IssueIndexingContext issueIndexingContext) {
        boolean isOngoing;
        boolean hasChanged = false;
        boolean bl = isOngoing = valueBuilder.getOngoingSLAData() != null;
        if (!isOngoing) {
            if (this.willStart(timelineEvent)) {
                boolean isPaused = valueBuilder.getTimeline().isPaused();
                OngoingSLAData.Builder builder = OngoingSLAData.builder();
                builder.startTime(timelineEvent.getDate()).paused(isPaused);
                valueBuilder.ongoingSLAData(builder.build());
                com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal = this.goalMatcher.getMatchingGoal(issue, timeMetric, issueIndexingContext);
                this.updateOngoingSLAGoal(timeMetric, goal, valueBuilder);
                hasChanged = true;
            }
        } else {
            com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal = this.goalMatcher.getMatchingGoal(issue, timeMetric, issueIndexingContext);
            hasChanged = this.updateOngoingSLAGoal(timeMetric, goal, valueBuilder) || hasChanged;
            boolean bl2 = hasChanged = this.updateOngoingPauseInfo(timelineEvent, valueBuilder) || hasChanged;
            if (this.willStop(timelineEvent)) {
                Option<CompleteSLAData> completeData = this.buildCompleteDataFromOngoing(goal, valueBuilder, timelineEvent.getDate());
                if (completeData.isDefined()) {
                    valueBuilder.addCompleteSLAData((CompleteSLAData)completeData.get());
                }
                valueBuilder.clearOngoingSLAData();
                hasChanged = true;
            }
        }
        return hasChanged;
    }

    private boolean updateOngoingSLAGoal(TimeMetric timeMetric, Issue issue, SLAValue.Builder valueBuilder, IssueIndexingContext issueIndexingContext) {
        com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal = this.goalMatcher.getMatchingGoal(issue, timeMetric, issueIndexingContext);
        return this.updateOngoingSLAGoal(timeMetric, goal, valueBuilder);
    }

    private boolean updateOngoingSLAGoal(TimeMetric timeMetric, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal, SLAValue.Builder valueBuilder) {
        boolean goalIdHasChanged;
        Long goalsChangeMsEpoch = timeMetric.getGoalsChangeMsEpoch();
        boolean goalsHaveChanged = valueBuilder.getGoalsChangeMsEpoch() == null || !valueBuilder.getGoalsChangeMsEpoch().equals(goalsChangeMsEpoch);
        Long goalTimeUpdatedMsEpoch = goal.getTimeUpdatedMsEpoch();
        boolean goalTimeHasChanged = valueBuilder.getGoalTimeUpdatedMsEpoch() == null || !valueBuilder.getGoalTimeUpdatedMsEpoch().equals(goalTimeUpdatedMsEpoch);
        boolean bl = goalIdHasChanged = !goal.getId().equals(valueBuilder.getOngoingSLAData().getGoalId());
        if (goalsHaveChanged || goalTimeHasChanged || goalIdHasChanged) {
            this.setOngoingSLAGoal(timeMetric, goal, valueBuilder);
            return true;
        }
        return false;
    }

    private void setOngoingSLAGoal(TimeMetric timeMetric, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal, SLAValue.Builder valueBuilder) {
        valueBuilder.ongoingSLAData(valueBuilder.getOngoingSLADataBuilder().goalId(goal.getId()).build());
        DateTime goalsChangedDate = timeMetric.getGoalsChangeDate();
        valueBuilder.setGoalsChangeDate(goalsChangedDate);
        valueBuilder.setGoalsChangeMsEpoch(timeMetric.getGoalsChangeMsEpoch());
        DateTime goalTimeChangedDate = goal.getTimeUpdatedDate();
        valueBuilder.setGoalTimeUpdatedDate(goalTimeChangedDate);
        valueBuilder.setGoalTimeUpdatedMsEpoch(goal.getTimeUpdatedMsEpoch());
    }

    private boolean updateOngoingPauseInfo(TimelineEvent timelineEvent, SLAValue.Builder valueBuilder) {
        boolean hasChanged = false;
        OngoingSLAData.Builder ongoingSLADataBuilder = valueBuilder.getOngoingSLADataBuilder();
        if (this.willPause(timelineEvent)) {
            ongoingSLADataBuilder.paused(true);
            hasChanged = true;
        } else if (this.willUnpause(timelineEvent)) {
            ongoingSLADataBuilder.paused(false);
            hasChanged = true;
        }
        valueBuilder.ongoingSLAData(ongoingSLADataBuilder.build());
        return hasChanged;
    }

    private Option<CompleteSLAData> buildCompleteDataFromOngoing(com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal, SLAValue.Builder slaValueBuilder, DateTime now) {
        OngoingSLAData ongoingSLAData = slaValueBuilder.getOngoingSLAData();
        CalendarReference calendarReference = this.calendarReferenceManager.getReferenceForGoal((Goal)goal);
        SLAValue temporaryValue = slaValueBuilder.build();
        Option<OngoingGoalStatus> ongoingGoalStatus = this.calculationManager.getOngoingGoalStatus(goal, temporaryValue, now);
        if (ongoingGoalStatus.isEmpty()) {
            return Option.none();
        }
        I18nHelper systemI18n = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
        OngoingGoalStatus status = (OngoingGoalStatus)ongoingGoalStatus.get();
        CompleteSLAData complete = CompleteSLAData.builder().calendarName(calendarReference.getName(systemI18n)).startTime(ongoingSLAData.getStartTime()).stopTime(now).elapsedTime(status.getElapsedTime()).remainingTime(status.getRemainingTime()).remainingTimeInDaysAndMillis(status.getRemainingTimeInDaysAndMillis()).goalTime(status.getTargetTime()).succeeded(!status.hasFailed()).build();
        return Option.some((Object)complete);
    }

    private boolean willPause(TimelineEvent timelineEvent) {
        return timelineEvent.getTypes().contains((Object)TimelineEventType.PAUSE);
    }

    private boolean willUnpause(TimelineEvent timelineEvent) {
        return timelineEvent.getTypes().contains((Object)TimelineEventType.UNPAUSE);
    }

    private boolean willStart(TimelineEvent timelineEvent) {
        return timelineEvent.getTypes().contains((Object)TimelineEventType.START);
    }

    private boolean willStop(TimelineEvent timelineEvent) {
        return timelineEvent.getTypes().contains((Object)TimelineEventType.STOP);
    }
}

