/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.goal;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.goal.GoalCalculationService;
import com.atlassian.servicedesk.internal.sla.goal.SlaThresholdDataManager;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.ThresholdData;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaThresholdDataManagerImpl
implements SlaThresholdDataManager {
    @Autowired
    private GoalManager goalManager;
    @Autowired
    private GoalCalculationService goalCalculationService;

    @Override
    public Option<OngoingSLAData> updateThresholdData(TimeMetric timeMetric, Timeline timeline, OngoingSLAData ongoingSLAData, DateTime now) {
        if (ongoingSLAData == null) {
            return Option.none();
        }
        ThresholdData.Builder thresholdDataBuilder = ThresholdData.builder().calculatedAt(now);
        Either<ErrorCollection, Goal> goalResult = this.goalManager.getGoal(ongoingSLAData.getGoalId());
        if (goalResult.isRight()) {
            thresholdDataBuilder.remainingTime(this.goalCalculationService.getRemainingTime(timeline, (Goal)((Object)goalResult.right().get()), ongoingSLAData.getStartTime(), now));
        }
        thresholdDataBuilder.thresholdsConfigChangeDate(timeMetric.getThresholdsConfigChangedDate());
        thresholdDataBuilder.thresholdsConfigChangeMsEpoch(timeMetric.getThresholdsChangedMsEpoch());
        OngoingSLAData.Builder builder = OngoingSLAData.builder(ongoingSLAData);
        builder.thresholdData((Option<ThresholdData>)Option.some((Object)thresholdDataBuilder.build()));
        OngoingSLAData ongoingSlaData = builder.build();
        return Option.some((Object)ongoingSlaData);
    }
}

