/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.goal;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.pocketknife.api.search.issue.service.IssueDataService;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilderFactory;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.goal.GoalIssueStatCounterCallback;
import com.atlassian.servicedesk.internal.sla.goal.GoalStatisticsService;
import com.atlassian.servicedesk.internal.sla.goal.GoalSuccessStatistics;
import com.atlassian.servicedesk.internal.sla.searcher.builder.SlaQueryHelper;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoalStatisticsServiceImpl
implements GoalStatisticsService {
    @Autowired
    private GoalService goalService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private JqlQueryParser jqlQueryParser;
    @Autowired
    private CustomFieldManager customFieldManager;
    @Autowired
    @VisibleForTesting
    SlaQueryBuilderFactory slaQueryBuilderFactory;

    @Override
    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
    public GoalSuccessStatistics getGoalSuccessStatistics(ApplicationUser user, ServiceDesk serviceDesk, TimeMetric timeMetric, ReadablePeriod periodBackInTime) {
        GoalSuccessStatistics goalSuccessStatistics = new GoalSuccessStatistics();
        CustomField cf = this.customFieldManager.getCustomFieldObject(timeMetric.getCustomFieldId());
        if (cf == null) {
            return goalSuccessStatistics;
        }
        DateTime now = DateTime.now();
        DateTime fromDate = now.minus(periodBackInTime);
        GoalIssueStatCounterCallback allRelevantIssuesCallback = new GoalIssueStatCounterCallback();
        GoalIssueStatCounterCallback succeededIssuesCallback = new GoalIssueStatCounterCallback();
        int goalsAllRelevantIssueCount = 0;
        int goalsSucceededIssueCount = 0;
        for (Goal goal : this.goalService.getAllByTimeMetric(user, serviceDesk, timeMetric)) {
            succeededIssuesCallback.resetCount();
            allRelevantIssuesCallback.resetCount();
            org.apache.lucene.search.Query dateQuery = SlaQueryHelper.getSlaStoppedAfter(cf, fromDate, this.slaQueryBuilderFactory);
            this.getAllRelevantIssues(user, cf, goal, serviceDesk, allRelevantIssuesCallback, dateQuery);
            if (goal.hasDuration() && allRelevantIssuesCallback.getCount() > 0) {
                this.getSuccessfulIssues(user, cf, goal, serviceDesk, succeededIssuesCallback, dateQuery);
                goalsAllRelevantIssueCount += allRelevantIssuesCallback.getCount();
                goalsSucceededIssueCount += succeededIssuesCallback.getCount();
                float percentage = this.round(100.0f * (float)succeededIssuesCallback.getCount() / (float)allRelevantIssuesCallback.getCount());
                goalSuccessStatistics.addGoalPercentage(goal, percentage);
            }
            succeededIssuesCallback.setAlreadyMatchedIssues(allRelevantIssuesCallback.getAlreadyMatchedIssues());
        }
        if (goalsAllRelevantIssueCount > 0) {
            float overAllPercentage = this.round(100.0f * (float)goalsSucceededIssueCount / (float)goalsAllRelevantIssueCount);
            goalSuccessStatistics.setOverallPercentage(overAllPercentage);
        }
        return goalSuccessStatistics;
    }

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
    private void getSuccessfulIssues(ApplicationUser user, CustomField customField, Goal goal, ServiceDesk serviceDesk, GoalIssueStatCounterCallback succeededIssuesCallback, org.apache.lucene.search.Query dateQuery) {
        Query succeededGoalQuery = this.buildSucceededGoalQuery(customField, this.getGoalQueryBuilder(serviceDesk, goal));
        this.issueDataService.find(user, succeededGoalQuery, (DataCallback)succeededIssuesCallback, dateQuery);
    }

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
    private void getAllRelevantIssues(ApplicationUser user, CustomField customField, Goal goal, ServiceDesk serviceDesk, GoalIssueStatCounterCallback allRelevantIssuesCallback, org.apache.lucene.search.Query dateQuery) {
        Query allRelevantGoalQuery = this.buildAllRelevantIssuesQuery(customField, this.getGoalQueryBuilder(serviceDesk, goal));
        this.issueDataService.find(user, allRelevantGoalQuery, (DataCallback)allRelevantIssuesCallback, dateQuery);
    }

    private float round(float v) {
        return (float)Math.floor(v);
    }

    private JqlQueryBuilder getGoalQueryBuilder(ServiceDesk serviceDesk, Goal goal) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder builder = queryBuilder.where();
        builder.project(new Long[]{serviceDesk.getProjectId()});
        String goalQuery = StringUtils.defaultString((String)goal.getJqlQuery()).trim();
        if (!goalQuery.isEmpty()) {
            try {
                Clause goalClause = this.jqlQueryParser.parseQuery(goalQuery).getWhereClause();
                if (goalClause != null) {
                    builder.and().addClause(goalClause);
                }
            }
            catch (JqlParseException e) {
                return null;
            }
        }
        return queryBuilder;
    }

    private Query buildSucceededGoalQuery(CustomField cf, JqlQueryBuilder goalBuilder) {
        JqlClauseBuilder builder = goalBuilder.where();
        builder.and().customField(cf.getIdAsLong()).eqFunc("completed");
        builder.and().customField(cf.getIdAsLong()).notEqFunc("breached");
        return builder.buildQuery();
    }

    private Query buildAllRelevantIssuesQuery(CustomField cf, JqlQueryBuilder goalBuilder) {
        JqlClauseBuilder builder = goalBuilder.where();
        Clause clause = JqlQueryBuilder.newBuilder().where().customField(cf.getIdAsLong()).eqFunc("breached").or().customField(cf.getIdAsLong()).eqFunc("completed").buildClause();
        builder.defaultAnd().addClause(clause);
        return builder.buildQuery();
    }
}

