/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.customfield;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SlaFieldUpdateLockManager;
import java.util.concurrent.locks.Lock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaFieldUpdateLockManagerImpl
implements SlaFieldUpdateLockManager {
    private final ClusterLockService clusterLockService;
    private final CustomFieldService customFieldService;

    @Autowired
    public SlaFieldUpdateLockManagerImpl(ClusterLockService clusterLockService, CustomFieldService customFieldService) {
        this.clusterLockService = clusterLockService;
        this.customFieldService = customFieldService;
    }

    @Override
    public void lockSlaUpdate(Issue issue, CustomField customField) {
        this.getLock(issue, customField).lock();
    }

    @Override
    public void lockSlaUpdate(Issue issue, TimeMetric timeMetric) {
        this.lockSlaUpdate(issue, this.getCustomFieldFromTimeMetric(timeMetric));
    }

    @Override
    public void unlockSlaUpdate(Issue issue, CustomField customField) {
        this.getLock(issue, customField).unlock();
    }

    @Override
    public void unlockSlaUpdate(Issue issue, TimeMetric timeMetric) {
        this.unlockSlaUpdate(issue, this.getCustomFieldFromTimeMetric(timeMetric));
    }

    private CustomField getCustomFieldFromTimeMetric(TimeMetric timeMetric) {
        return this.customFieldService.getCustomField(timeMetric.getCustomFieldId());
    }

    private Lock getLock(Issue issue, CustomField customField) {
        return this.clusterLockService.getLockForName(SlaFieldUpdateLockManagerImpl.lockAccessKey(issue, customField));
    }

    private static String lockAccessKey(Issue issue, CustomField customField) {
        return "sla_" + customField.getId() + "_update_" + issue.getId();
    }
}

