/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.customfield;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.internal.api.rest.serializers.OptionSerializer;
import com.atlassian.servicedesk.internal.jackson.serializer.OptionDeserializer;
import com.atlassian.servicedesk.internal.jackson.serializer.OptionFilter;
import com.atlassian.servicedesk.internal.jackson.serializer.OptionFilterAnnotationHoldingMixIn;
import com.atlassian.servicedesk.internal.rest.sla.admin.response.AdminSlaReconstructionResult;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugSLAValue;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeOrderingIndexData;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.BeanPropertyFilter;
import org.codehaus.jackson.map.ser.FilterProvider;
import org.codehaus.jackson.map.ser.impl.SimpleFilterProvider;

public class SLAValueSerializer {
    protected static final Log log = Log.with(SLAValueSerializer.class);
    private static final ObjectMapper SERIALIZER = new ObjectMapper();

    public String serialize(SLAValue slaValue) {
        return this.serializeObject(slaValue);
    }

    public String serialize(DebugSLAValue debugSLAValue) {
        return this.serializeObject(debugSLAValue);
    }

    public String serialize(AdminSlaReconstructionResult adminSlaReconstructionResult) {
        return this.serializeObject(adminSlaReconstructionResult);
    }

    public String serialize(Timeline timeline) {
        return this.serializeObject(timeline);
    }

    public String serialize(RemainingTimeOrderingIndexData remainingTimeOrderingIndexData) {
        return this.serializeObject(remainingTimeOrderingIndexData);
    }

    private String serializeObject(Object value) {
        log.debug("Value about to be serialized : %s", new Object[]{value});
        StringWriter writer = new StringWriter();
        try {
            SERIALIZER.writeValue((Writer)writer, value);
        }
        catch (JsonGenerationException | JsonMappingException e) {
            log.errorDebug((Exception)e, "JSon generation exception", new Object[0]);
        }
        catch (IOException e) {
            log.errorDebug((Exception)e, "IOException exception", new Object[0]);
        }
        String s = ((Object)writer).toString();
        if (s == null) {
            return null;
        }
        log.debug("Value as serialized JSon : %s", new Object[]{s});
        return s;
    }

    public SLAValue unserialize(String text) {
        return this.unserializeValue(text, SLAValue.class);
    }

    public Timeline unserializeTimeline(String text) {
        return this.unserializeValue(text, Timeline.class);
    }

    public RemainingTimeOrderingIndexData unserializeOrderingData(String text) {
        return this.unserializeValue(text, RemainingTimeOrderingIndexData.class);
    }

    private <T> T unserializeValue(String text, Class<T> aClass) {
        log.debug("Value JSon (%s) about to be unserialized : %s", new Object[]{aClass.getCanonicalName(), text});
        Object value = null;
        if (text != null) {
            try {
                value = SERIALIZER.readValue(text, aClass);
            }
            catch (IOException e) {
                log.error("Error deserializing SLA value: %s, '%s'", new Object[]{e.getMessage(), text});
            }
        }
        log.debug("Value unserialized from JSon : %s", new Object[]{value});
        return (T)value;
    }

    static {
        SimpleModule optionModule = new SimpleModule("OptionModule", new Version(1, 0, 0, null));
        optionModule.addDeserializer(Option.class, (JsonDeserializer)new OptionDeserializer());
        optionModule.addSerializer(Option.class, (JsonSerializer)new OptionSerializer(false));
        SERIALIZER.getSerializationConfig().addMixInAnnotations(Object.class, OptionFilterAnnotationHoldingMixIn.class);
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("ignoreEmptyOptions", (BeanPropertyFilter)new OptionFilter());
        SERIALIZER.setFilters((FilterProvider)filters);
        SERIALIZER.registerModule((Module)optionModule);
    }
}

