/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.customfield;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldService;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLACFType;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import com.atlassian.servicedesk.internal.sla.customfield.SlaFieldUpdateLockManager;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SLAFieldManagerImpl
implements SLAFieldManager {
    private static final String PROJECT_MANAGER_SLA_FIELD_CREATION_ENABLED_KEY = "com.atlassian.servicedesk.project.admin.sla.field.creation.enabled";
    private final CustomFieldService customFieldService;
    private final CustomFieldManager customFieldManager;
    private final TimeMetricManager timeMetricManager;
    private final GlobalPropertyDao globalPropertyDao;
    private final SlaFieldUpdateLockManager slaFieldUpdateLockManager;

    @Autowired
    public SLAFieldManagerImpl(CustomFieldService customFieldService, CustomFieldManager customFieldManager, TimeMetricManager timeMetricManager, GlobalPropertyDao globalPropertyDao, SlaFieldUpdateLockManager slaFieldUpdateLockManager) {
        this.customFieldService = customFieldService;
        this.customFieldManager = customFieldManager;
        this.timeMetricManager = timeMetricManager;
        this.globalPropertyDao = globalPropertyDao;
        this.slaFieldUpdateLockManager = slaFieldUpdateLockManager;
    }

    @Override
    public List<CustomField> getAll() {
        return this.customFieldService.getCustomFields(SLACFType.class);
    }

    @Override
    public List<CustomField> getAllUnusedFields() {
        Set<Long> customFieldsInUse = this.timeMetricManager.getSlaCustomFieldIdsInUse();
        List fields = this.customFieldService.getCustomFields(SLACFType.class);
        fields.removeIf(next -> customFieldsInUse.contains(next.getIdAsLong()));
        return fields;
    }

    @Override
    public boolean isProjectAdminFieldCreationEnabled() {
        Boolean value = this.globalPropertyDao.getBooleanProperty(PROJECT_MANAGER_SLA_FIELD_CREATION_ENABLED_KEY);
        if (value == null) {
            return true;
        }
        return value;
    }

    @Override
    public void setProjectAdminFieldCreationEnabled(boolean enabled) {
        this.globalPropertyDao.setBooleanProperty(PROJECT_MANAGER_SLA_FIELD_CREATION_ENABLED_KEY, Boolean.valueOf(enabled));
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, CustomField> getByName(String name) {
        List<CustomField> all = this.getAll();
        for (CustomField field : all) {
            if (!field.getName().equals(name)) continue;
            return io.atlassian.fugue.Either.right((Object)field);
        }
        return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.customfield.error.by.name.not.found", (Object[])new Object[0]));
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, CustomField> getById(long id) {
        CustomField customField = this.customFieldService.getCustomField(Long.valueOf(id));
        if (customField == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.customfield.error.by.id.not.found", (Object[])new Object[0]));
        }
        if (!(customField.getCustomFieldType() instanceof SLACFType)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)("Custom field with id " + id + " is not of correct type"), (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)customField);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, CustomField> createSLAField(String name) {
        io.atlassian.fugue.Either<ErrorCollection, String> fieldName = this.validateFieldName(name);
        if (fieldName.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)fieldName.left().get());
        }
        CustomFieldMetadata customFieldMetadata = CustomFieldMetadata.builder().fieldName((String)fieldName.right().get()).fieldDescription("sd.customfield.type.sla.desc").fieldType("com.atlassian.servicedesk:sd-sla-field").fieldSearcher("com.atlassian.servicedesk:sd-sla-field-searcher").lockField(true).lockFieldDescription("sd.customfield.type.sla.locked.desc").build();
        CustomField globalCustomField = this.customFieldService.createCustomField(customFieldMetadata);
        return io.atlassian.fugue.Either.right((Object)globalCustomField);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteSLAField(CustomField field) {
        List<TimeMetric> timeMetrics = this.timeMetricManager.getTimeMetricsByCustomField(field);
        if (!timeMetrics.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.customfield.error.metrics.still.associated", (Object[])new Object[0]));
        }
        this.customFieldService.removeCustomField(field);
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteUnusedSLAFields() {
        List<CustomField> allUnusedFields = this.getAllUnusedFields();
        for (CustomField customField : allUnusedFields) {
            io.atlassian.fugue.Either<ErrorCollection, Unit> outcome = this.deleteSLAField(customField);
            if (!outcome.isLeft()) continue;
            return outcome;
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    private boolean fieldNameAlreadyExist(String name) {
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByName(name);
        return customFields != null && customFields.size() > 0;
    }

    @Override
    public SLAValue getFieldValue(Issue issue, CustomField customField) {
        return (SLAValue)this.getOptionalFieldValue(issue, customField).getOr(SLAValue::new);
    }

    @Override
    public Option<SLAValue> getOptionalFieldValue(Issue issue, CustomField customField) {
        Object customFieldValue = issue.getCustomFieldValue(customField);
        if (customFieldValue instanceof SLAValue) {
            return Option.some((Object)((SLAValue)customFieldValue));
        }
        return Option.none();
    }

    @Override
    public SLAValue getFieldValue(Issue issue, TimeMetric timeMetric) {
        CustomField cf = this.getCustomFieldFromTimeMetric(timeMetric);
        return this.getFieldValue(issue, cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFieldValue(TimeMetric timeMetric, Issue issue, SLAValue updatingValue) {
        CustomField customField = this.getCustomFieldFromTimeMetric(timeMetric);
        this.slaFieldUpdateLockManager.lockSlaUpdate(issue, customField);
        try {
            customField.getCustomFieldType().updateValue(customField, issue, (Object)updatingValue);
        }
        finally {
            this.slaFieldUpdateLockManager.unlockSlaUpdate(issue, customField);
        }
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, String> validateFieldName(String fieldName) {
        if ((fieldName = StringUtils.defaultString((String)fieldName).trim()).isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.customfield.error.name.empty", (Object[])new Object[0]));
        }
        if (fieldName.length() > 255) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.customfield.error.name.too.long", (Object[])new Object[0]));
        }
        if (this.fieldNameAlreadyExist(fieldName)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.customfield.error.name.already.exists", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)fieldName);
    }

    private CustomField getCustomFieldFromTimeMetric(TimeMetric timeMetric) {
        return this.customFieldService.getCustomField(timeMetric.getCustomFieldId());
    }
}

