/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.timemetric;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.rest.sla.GoalResource;
import com.atlassian.servicedesk.internal.rest.sla.TimeMetricDefinitionResource;
import com.atlassian.servicedesk.internal.rest.sla.agentview.MetricConfigRequest;
import com.atlassian.servicedesk.internal.rest.sla.agentview.MetricRequest;
import com.atlassian.servicedesk.internal.rest.sla.request.TimeMetricDefinitionRequest;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricCreationService;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionService;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricAgentConfigService;
import io.atlassian.fugue.Unit;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimeMetricAgentConfigServiceImpl
implements TimeMetricAgentConfigService {
    @Autowired
    private InternalTimeMetricService timeMetricService;
    @Autowired
    private TimeMetricCreationService timeMetricCreationService;
    @Autowired
    private TimeMetricDefinitionService timeMetricDefinitionService;
    @Autowired
    private GoalService goalService;

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> isValidMetric(ApplicationUser user, ServiceDesk serviceDesk, MetricRequest metricRequest) {
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> metric = this.toMetric(metricRequest);
        if (metric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)metric.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetricDefinitionInfo> definition = this.toDefinition(metricRequest);
        if (definition.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)definition.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, List<Goal>> goals = this.toGoals(metricRequest);
        if (goals.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)goals.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> validMetric = this.timeMetricService.validateMetric(user, serviceDesk, (TimeMetric)((Object)metric.right().get()));
        if (validMetric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validMetric.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> validDefinition = this.timeMetricDefinitionService.validateDefinitionConfiguration(user, serviceDesk, (TimeMetricDefinitionInfo)definition.right().get());
        if (validDefinition.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validDefinition.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> validGoals = this.goalService.validateGoals(user, serviceDesk, (List)goals.right().get());
        if (validGoals.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validGoals.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createMetric(ApplicationUser user, ServiceDesk serviceDesk, MetricRequest metricRequest) {
        String metricName;
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> metric = this.toMetric(metricRequest);
        if (metric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)metric.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetricDefinitionInfo> definition = this.toDefinition(metricRequest);
        if (definition.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)definition.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, List<Goal>> goals = this.toGoals(metricRequest);
        if (goals.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)goals.left().get());
        }
        String customFieldName = metricName = ((TimeMetric)((Object)metric.right().get())).getName();
        io.atlassian.fugue.Either<ErrorCollection, Unit> metricValidate = this.timeMetricCreationService.validateTimeMetric(user, serviceDesk, metricName, customFieldName);
        if (metricValidate.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)metricValidate.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> validDefinition = this.timeMetricDefinitionService.validateDefinitionConfiguration(user, serviceDesk, (TimeMetricDefinitionInfo)definition.right().get());
        if (validDefinition.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validDefinition.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> validGoals = this.goalService.validateGoals(user, serviceDesk, (List)goals.right().get());
        if (validGoals.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validGoals.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetric = this.timeMetricCreationService.createTimeMetric(user, serviceDesk, (String)metricRequest.getName().get(), (String)metricRequest.getName().get());
        if (timeMetric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)timeMetric.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetricDefinitionInfo> definitionUpdateResult = this.timeMetricDefinitionService.updateDefinitionConfiguration(user, serviceDesk, (TimeMetric)((Object)timeMetric.right().get()), (TimeMetricDefinitionInfo)definition.right().get());
        if (definitionUpdateResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)definitionUpdateResult.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, List<Goal>> goalsResult = this.goalService.updateAll(user, serviceDesk, (TimeMetric)((Object)timeMetric.right().get()), (List)goals.right().get());
        if (goalsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)goalsResult.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)timeMetric.right().get());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateMetric(ApplicationUser user, ServiceDesk serviceDesk, Integer metricId, MetricRequest metricRequest) {
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> metric = this.timeMetricService.getTimeMetric(user, serviceDesk, metricId);
        if (metric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)metric.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetricDefinitionInfo> definition = this.toDefinition(metricRequest);
        if (definition.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)definition.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, List<Goal>> goals = this.toGoals(metricRequest);
        if (goals.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)goals.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> validDefinition = this.timeMetricDefinitionService.validateDefinitionConfiguration(user, serviceDesk, (TimeMetricDefinitionInfo)definition.right().get());
        if (validDefinition.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validDefinition.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> validGoals = this.goalService.validateGoals(user, serviceDesk, (List)goals.right().get());
        if (validGoals.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validGoals.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetricDefinitionInfo> definitionUpdateResult = this.timeMetricDefinitionService.updateDefinitionConfiguration(user, serviceDesk, (TimeMetric)((Object)metric.right().get()), (TimeMetricDefinitionInfo)definition.right().get());
        if (definitionUpdateResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)definitionUpdateResult.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, List<Goal>> goalsResult = this.goalService.updateAll(user, serviceDesk, (TimeMetric)((Object)metric.right().get()), (List)goals.right().get());
        if (goalsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)goalsResult.left().get());
        }
        metric = this.timeMetricService.getTimeMetric(user, serviceDesk, metricId);
        if (metric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)metric.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)metric.right().get());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> getMetric(ApplicationUser user, ServiceDesk serviceDesk, Integer metricId) {
        return this.timeMetricService.getTimeMetric(user, serviceDesk, metricId);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteMetric(ApplicationUser user, ServiceDesk serviceDesk, Integer metricId) {
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetricEither = this.timeMetricService.getTimeMetric(user, serviceDesk, metricId);
        if (timeMetricEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)timeMetricEither.left().get());
        }
        return this.timeMetricService.deleteTimeMetric(user, serviceDesk, (TimeMetric)((Object)timeMetricEither.right().get()));
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> toMetric(MetricRequest request) {
        String name = "";
        if (request.getName().isDefined()) {
            name = (String)request.getName().get();
        }
        TimeMetric.TimeMetricBuilder builder = TimeMetric.builder();
        builder.name(name);
        if (request.getId().isDefined()) {
            builder.id((Integer)request.getId().get());
        }
        if (request.getCustomFieldId().isDefined()) {
            builder.customFieldId((Long)request.getCustomFieldId().get());
        }
        return io.atlassian.fugue.Either.right((Object)((Object)builder.build()));
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetricDefinitionInfo> toDefinition(MetricRequest request) {
        if (request.getConfig().isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"config is required", (Object[])new Object[0]));
        }
        if (((MetricConfigRequest)request.getConfig().get()).getDefinition().isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"config.definition is required", (Object[])new Object[0]));
        }
        TimeMetricDefinitionRequest definition = (TimeMetricDefinitionRequest)((MetricConfigRequest)request.getConfig().get()).getDefinition().get();
        return io.atlassian.fugue.Either.right((Object)TimeMetricDefinitionResource.from(definition));
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> toGoals(MetricRequest request) {
        if (request.getConfig().isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"config is required", (Object[])new Object[0]));
        }
        if (((MetricConfigRequest)request.getConfig().get()).getGoals().isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"config.goals is required", (Object[])new Object[0]));
        }
        List goalRequests = (List)((MetricConfigRequest)request.getConfig().get()).getGoals().get();
        return io.atlassian.fugue.Either.right(GoalResource.fromRequest(goalRequests));
    }
}

