/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.timemetric;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdService;
import io.atlassian.fugue.Unit;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalTimeMetricServiceImpl
implements InternalTimeMetricService {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private TimeMetricManager timeMetricManager;
    @Autowired
    private SlaThresholdService slaThresholdService;

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> getTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, int id) {
        return this.timeMetricManager.getTimeMetric(serviceDesk, id);
    }

    @Override
    public List<TimeMetric> getTimeMetrics(ApplicationUser user, ServiceDesk serviceDesk) {
        return this.timeMetricManager.getTimeMetrics(serviceDesk);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> getTimeMetric(ApplicationUser user, ServiceDesk sd, CustomField slaCustomField) {
        return this.timeMetricManager.getTimeMetric(sd, slaCustomField);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, String metricName, CustomField customField) {
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.time.metric.service.permission.error.create", (Object[])new Object[0]));
        }
        TimeMetric timeMetric = new TimeMetric.TimeMetricBuilder().name(metricName).customFieldId(customField.getIdAsLong()).build();
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createdTimeMetric = this.timeMetricManager.createTimeMetric(serviceDesk, timeMetric);
        if (createdTimeMetric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)createdTimeMetric.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, List<SlaThreshold>> addDefaultThresholdsResult = this.createDefaultThresholds(user, (TimeMetric)((Object)createdTimeMetric.right().get()));
        if (addDefaultThresholdsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)addDefaultThresholdsResult.left().get());
        }
        return createdTimeMetric;
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> validateMetric(ApplicationUser user, ServiceDesk serviceDesk, TimeMetric timeMetric) {
        return this.timeMetricManager.validate(serviceDesk, timeMetric);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, TimeMetric timeMetric) {
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.time.metric.service.permission.error.delete", (Object[])new Object[0]));
        }
        return this.timeMetricManager.deleteTimeMetric(serviceDesk, timeMetric);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, ServiceDesk> getServiceDeskForTimeMetric(ApplicationUser user, TimeMetric timeMetric) {
        return this.timeMetricManager.getServiceDeskForTimeMetric(timeMetric);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<SlaThreshold>> createDefaultThresholds(ApplicationUser user, TimeMetric timeMetric) {
        io.atlassian.fugue.Either<ErrorCollection, ApplicationUser> applicationUserResult = this.validateUser(user);
        ApplicationUser applicationUser = (ApplicationUser)applicationUserResult.right().get();
        io.atlassian.fugue.Either<ErrorCollection, List<SlaThreshold>> addThresholdResult = this.addThresholdByRemainingTime(applicationUser, timeMetric, Duration.standardMinutes((long)60L).getMillis());
        if (addThresholdResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)addThresholdResult.left().get());
        }
        addThresholdResult = this.addThresholdByRemainingTime(applicationUser, timeMetric, Duration.standardMinutes((long)30L).getMillis());
        if (addThresholdResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)addThresholdResult.left().get());
        }
        addThresholdResult = this.addThresholdByRemainingTime(applicationUser, timeMetric, Duration.ZERO.getMillis());
        if (addThresholdResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)addThresholdResult.left().get());
        }
        List finalThresholdsList = (List)addThresholdResult.right().get();
        return io.atlassian.fugue.Either.right((Object)finalThresholdsList);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<SlaThreshold>> addThresholdByRemainingTime(ApplicationUser applicationUser, TimeMetric timeMetric, long remainingTime) {
        io.atlassian.fugue.Either<AnError, List<SlaThreshold>> addThresholdResult = this.slaThresholdService.addThreshold(applicationUser, timeMetric, remainingTime);
        if (addThresholdResult.isLeft()) {
            return this.translateEither(addThresholdResult);
        }
        return io.atlassian.fugue.Either.right((Object)addThresholdResult.right().get());
    }

    private io.atlassian.fugue.Either<ErrorCollection, ApplicationUser> validateUser(ApplicationUser user) {
        if (user == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.user.error.missing", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)user);
    }

    private <T> io.atlassian.fugue.Either<ErrorCollection, T> translateEither(io.atlassian.fugue.Either<AnError, T> anErrorEither) {
        if (anErrorEither == null) {
            return null;
        }
        return anErrorEither.left().map(anError -> {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(anError.getMessage().getMessage());
            return errors;
        });
    }
}

