/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.threshold;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.sla.configuration.threshold.SlaThreshold;
import com.atlassian.servicedesk.internal.sla.configuration.threshold.SlaThresholdQStore;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Unit;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaThresholdQStoreImpl
implements SlaThresholdQStore {
    private DatabaseAccessor databaseAccessor;

    @Autowired
    public SlaThresholdQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    private static ConstructorExpression<SlaThreshold> slaThresholdConstructorExpression() {
        return Projections.constructor(SlaThreshold.class, (Expression[])new Expression[]{Tables.SLA_THRESHOLD.ID, Tables.SLA_THRESHOLD.REMAINING_TIME});
    }

    @Override
    public void deleteSlaThresholdForTimeMetric(TimeMetric timeMetric) {
        this.databaseAccessor.runInTransaction(conn -> {
            this.deleteSlaThresholdForTimeMetric((DatabaseConnection)conn, timeMetric);
            return Unit.Unit();
        });
    }

    @Override
    public void deleteSlaThresholdForTimeMetric(DatabaseConnection databaseConnection, TimeMetric timeMetric) {
        databaseConnection.delete((RelationalPath)Tables.SLA_THRESHOLD).where((Predicate)Tables.SLA_THRESHOLD.TIME_METRIC_ID.eq((Object)timeMetric.getId())).execute();
    }

    @Override
    public List<SlaThreshold> getAllSlaThresholdsHighestFirst(TimeMetric timeMetric) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.select(SlaThresholdQStoreImpl.slaThresholdConstructorExpression()).from((Expression)Tables.SLA_THRESHOLD)).where((Predicate)Tables.SLA_THRESHOLD.TIME_METRIC_ID.eq((Object)timeMetric.getId()))).orderBy(Tables.SLA_THRESHOLD.REMAINING_TIME.desc())).fetch());
    }

    @Override
    public void deleteForRemainingTime(TimeMetric timeMetric, long remainingTime) {
        this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.SLA_THRESHOLD).where((Predicate)Tables.SLA_THRESHOLD.TIME_METRIC_ID.eq((Object)timeMetric.getId()).and((Predicate)Tables.SLA_THRESHOLD.REMAINING_TIME.eq((Object)remainingTime))).execute());
    }

    @Override
    public void createSlaThreshold(TimeMetric timeMetric, SlaThreshold slaThreshold) {
        this.databaseAccessor.runInTransaction(conn -> conn.insert((RelationalPath)Tables.SLA_THRESHOLD).set(Tables.SLA_THRESHOLD.REMAINING_TIME, (Object)slaThreshold.getRemainingTime()).set(Tables.SLA_THRESHOLD.TIME_METRIC_ID, (Object)timeMetric.getId()).execute());
    }
}

