/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.threshold;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.sla.configuration.threshold.SlaThreshold;
import com.atlassian.servicedesk.internal.sla.configuration.threshold.SlaThresholdManager;
import com.atlassian.servicedesk.internal.sla.configuration.threshold.SlaThresholdQStore;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevel;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevelService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaThresholdManagerImpl
implements SlaThresholdManager {
    private SlaThresholdQStore slaThresholdQStore;
    private UrgencyLevelService urgencyLevelService;
    private ErrorResultHelper errorResultHelper;
    private TimeMetricManager timeMetricManager;

    @Autowired
    public SlaThresholdManagerImpl(SlaThresholdQStore slaThresholdQStore, UrgencyLevelService urgencyLevelService, ErrorResultHelper errorResultHelper, TimeMetricManager timeMetricManager) {
        this.slaThresholdQStore = slaThresholdQStore;
        this.urgencyLevelService = urgencyLevelService;
        this.errorResultHelper = errorResultHelper;
        this.timeMetricManager = timeMetricManager;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> getThresholds(com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric) {
        TimeMetric internalTimeMetric = (TimeMetric)timeMetric;
        List<SlaThreshold> allThresholds = this.slaThresholdQStore.getAllSlaThresholdsHighestFirst(internalTimeMetric);
        return io.atlassian.fugue.Either.right(this.toApiThresholds(allThresholds));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> getThresholdsInRange(com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long startRemainingTimeExcluding, long endRemainingTimeIncluding) {
        if (startRemainingTimeExcluding < endRemainingTimeIncluding) {
            throw new IllegalArgumentException("startRemainingTimeExcluding needs to be higher than endRemainingTimeIncluding");
        }
        io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> thresholdsResult = this.getThresholds(timeMetric);
        if (thresholdsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thresholdsResult.left().get());
        }
        List thresholds = (List)thresholdsResult.right().get();
        io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> thresholdsAfterTimeExcluding = this.getThresholdsAfterTimeExcluding(thresholds, startRemainingTimeExcluding);
        if (thresholdsAfterTimeExcluding.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thresholdsAfterTimeExcluding.left().get());
        }
        List excludingTooHigh = (List)thresholdsAfterTimeExcluding.right().get();
        io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> thresholdsBeforeTimeIncluding = this.getThresholdsBeforeTimeIncluding(excludingTooHigh, endRemainingTimeIncluding);
        if (thresholdsBeforeTimeIncluding.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thresholdsBeforeTimeIncluding.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)thresholdsBeforeTimeIncluding.right().get());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> getThresholdsBeforeRemainingTimeIncluding(com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long remainingTimeIncluding) {
        io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> thresholdsResult = this.getThresholds(timeMetric);
        if (thresholdsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thresholdsResult.left().get());
        }
        List thresholds = (List)thresholdsResult.right().get();
        return this.getThresholdsBeforeTimeIncluding(thresholds, remainingTimeIncluding);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> getThresholdsAfterRemainingTimeExcluding(com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long remainingTimeExcluding) {
        io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> thresholdsResult = this.getThresholds(timeMetric);
        if (thresholdsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thresholdsResult.left().get());
        }
        List thresholds = (List)thresholdsResult.right().get();
        return this.getThresholdsAfterTimeExcluding(thresholds, remainingTimeExcluding);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> addThreshold(com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long remainingTime) {
        TimeMetric internalTimeMetric = (TimeMetric)timeMetric;
        io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> thresholdsResult = this.getThresholds(timeMetric);
        if (thresholdsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thresholdsResult.left().get());
        }
        List thresholds = (List)thresholdsResult.right().get();
        for (com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold slaThreshold : thresholds) {
            if (slaThreshold.getRemainingTime() != remainingTime) continue;
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.sla.threshold.error.add.existing.threshold", new Object[0]));
        }
        SlaThreshold slaThreshold = SlaThreshold.builder().remainingTime(remainingTime).build();
        this.slaThresholdQStore.createSlaThreshold(internalTimeMetric, slaThreshold);
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> dateUpdateResult = this.timeMetricManager.updateThresholdConfigChangeDateAndMsEpoch(internalTimeMetric);
        if (dateUpdateResult.isLeft()) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "sd.sla.threshold.error.time.metric.threshold.config.date.update.failed", new Object[0]));
        }
        thresholdsResult = this.getThresholds(internalTimeMetric);
        if (thresholdsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thresholdsResult.left().get());
        }
        thresholds = (List)thresholdsResult.right().get();
        return io.atlassian.fugue.Either.right((Object)thresholds);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> removeThreshold(com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long remainingTime) {
        TimeMetric internalTimeMetric = (TimeMetric)timeMetric;
        Option<UrgencyLevel> urgencyLevelMatchingThreshold = this.urgencyLevelService.getUrgencyLevelMatchingThreshold(remainingTime);
        if (urgencyLevelMatchingThreshold.isDefined()) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.sla.threshold.error.remove.existing.urgency.level", new Object[0]));
        }
        this.slaThresholdQStore.deleteForRemainingTime(internalTimeMetric, remainingTime);
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> dateUpdateResult = this.timeMetricManager.updateThresholdConfigChangeDateAndMsEpoch(internalTimeMetric);
        if (dateUpdateResult.isLeft()) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "sd.sla.threshold.error.time.metric.threshold.config.date.update.failed", new Object[0]));
        }
        io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> thresholdsResult = this.getThresholds(internalTimeMetric);
        if (thresholdsResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thresholdsResult.left().get());
        }
        List thresholds = (List)thresholdsResult.right().get();
        return io.atlassian.fugue.Either.right((Object)thresholds);
    }

    private io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> getThresholdsBeforeTimeIncluding(List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold> thresholds, long remainingTime) {
        ImmutableList.Builder thresholdsInRange = ImmutableList.builder();
        for (com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold threshold : thresholds) {
            if (threshold.getRemainingTime() >= remainingTime) {
                thresholdsInRange.add((Object)threshold);
                continue;
            }
            if (threshold.getRemainingTime() >= remainingTime) continue;
            break;
        }
        return io.atlassian.fugue.Either.right((Object)thresholdsInRange.build());
    }

    private io.atlassian.fugue.Either<AnError, List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold>> getThresholdsAfterTimeExcluding(List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold> thresholds, long remainingTime) {
        ImmutableList.Builder thresholdsInRange = ImmutableList.builder();
        for (com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold threshold : thresholds) {
            if (threshold.getRemainingTime() >= remainingTime) continue;
            thresholdsInRange.add((Object)threshold);
        }
        return io.atlassian.fugue.Either.right((Object)thresholdsInRange.build());
    }

    private List<com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold> toApiThresholds(List<SlaThreshold> internalThresholds) {
        ArrayList apiThresholds = Lists.newArrayList();
        for (SlaThreshold internalThreshold : internalThresholds) {
            apiThresholds.add(internalThreshold);
        }
        return apiThresholds;
    }
}

