/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.goal;

import com.atlassian.pocketknife.api.ao.dao.AbstractModel;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.feature.report.series.GoalUpdateInfo;
import com.atlassian.servicedesk.internal.feature.report.series.SeriesQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalMapper;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalQStore;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalWithTimeMetricId;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalWithTimeMetricIdMapper;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GoalQStoreImpl
implements GoalQStore {
    private final DatabaseAccessor databaseAccessor;
    private final SeriesQStore seriesQStore;

    @Autowired
    public GoalQStoreImpl(DatabaseAccessor databaseAccessor, SeriesQStore seriesQStore) {
        this.databaseAccessor = databaseAccessor;
        this.seriesQStore = seriesQStore;
    }

    @Override
    public List<GoalWithTimeMetricId> getAllGoalsWithTimeMetricIdOrderedByPosition() {
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)databaseConnection.select((Expression)new GoalWithTimeMetricIdMapper()).from((Expression)Tables.GOAL)).orderBy(new OrderSpecifier[]{Tables.GOAL.POS.asc(), Tables.GOAL.ID.asc()})).fetch());
    }

    @Override
    public List<Goal> getAllGoalsByCalendarReference(CalendarReference calendarReference) {
        return (List)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)((SQLQuery)databaseConnection.select((Expression)new GoalMapper()).from((Expression)Tables.GOAL)).where((Predicate)Tables.GOAL.CALENDAR_ID.eq((Object)calendarReference.getId()))).fetch());
    }

    @Override
    public long deleteGoalsForTimeMetric(TimeMetric timeMetric) {
        return (Long)this.databaseAccessor.runInTransaction(conn -> this.deleteGoalsForTimeMetric((DatabaseConnection)conn, timeMetric));
    }

    @Override
    public long deleteGoalsForTimeMetric(DatabaseConnection connection, TimeMetric timeMetric) {
        return connection.delete((RelationalPath)Tables.GOAL).where((Predicate)Tables.GOAL.TIME_METRIC_ID.eq((Object)timeMetric.getId())).execute();
    }

    @Override
    public List<Goal> updateAllGoalsForTimeMetric(TimeMetric timeMetric, List<Goal> goalsBeforeUpdate, List<Goal> goals) {
        return (List)this.databaseAccessor.runInTransaction(conn -> {
            this.deleteGoalsForTimeMetric((DatabaseConnection)conn, timeMetric);
            return this.addNewGoalsAndNotifySeries(timeMetric, goalsBeforeUpdate, goals, (DatabaseConnection)conn);
        });
    }

    private List<Goal> addNewGoalsAndNotifySeries(TimeMetric timeMetric, List<Goal> goalsBeforeUpdate, List<Goal> goals, DatabaseConnection conn) {
        List<Goal> newlyAddedGoals = this.addValues(conn, timeMetric, goals);
        HashMap<Integer, Integer> originalIdsToNewIds = new HashMap<Integer, Integer>();
        for (int i = 0; i < goals.size(); ++i) {
            Integer originalGoalId = goals.get(i).getId();
            if (originalGoalId == null) continue;
            originalIdsToNewIds.put(originalGoalId, newlyAddedGoals.get(i).getId());
        }
        GoalUpdateInfo goalUpdateInfo = new GoalUpdateInfo(this.getDeletedGoalIds(goalsBeforeUpdate, goals), originalIdsToNewIds);
        this.seriesQStore.deleteAndUpdateSeriesWithGoalUpdateInfo(goalUpdateInfo, conn);
        return newlyAddedGoals;
    }

    private List<Integer> getDeletedGoalIds(List<Goal> goalsBeforeUpdate, List<Goal> goals) {
        List deletedGoals = ListUtils.subtract(goalsBeforeUpdate, goals);
        return deletedGoals.stream().mapToInt(AbstractModel::getId).boxed().collect(Collectors.toList());
    }

    @Override
    public Option<Goal> getGoal(int goalId) {
        Goal goal = (Goal)((Object)this.databaseAccessor.runInTransaction(conn -> (Goal)((Object)((Object)((SQLQuery)((SQLQuery)conn.select((Expression)new GoalMapper()).from((Expression)Tables.GOAL)).where((Predicate)Tables.GOAL.ID.eq((Object)goalId))).fetchOne()))));
        return Option.option((Object)((Object)goal));
    }

    @Override
    public List<Goal> getGoalsForTimeMetric(TimeMetric timeMetric) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression)new GoalMapper()).from((Expression)Tables.GOAL)).where((Predicate)Tables.GOAL.TIME_METRIC_ID.eq((Object)timeMetric.getId()))).fetch());
    }

    @Override
    public void updateGoalTimeUpdated(Goal updatedGoal) {
        this.databaseAccessor.runInTransaction(conn -> this.updateGoalTimeUpdatedWithConnection(updatedGoal, (DatabaseConnection)conn));
    }

    private long updateGoalTimeUpdatedWithConnection(Goal updatedGoal, DatabaseConnection conn) {
        long rowsUpdated = conn.update((RelationalPath)Tables.GOAL).set(Tables.GOAL.TIME_UPDATED_DATE, (Object)this.toTimestampOrDefault(updatedGoal.getTimeUpdatedDate())).set(Tables.GOAL.TIME_UPDATED_MS_EPOCH, (Object)updatedGoal.getTimeUpdatedMsEpoch()).where((Predicate)Tables.GOAL.ID.eq((Object)updatedGoal.getId())).execute();
        if (rowsUpdated != 1L) {
            throw new RuntimeException(String.format("Expected %d row to be updated, but %d updated", 1, rowsUpdated));
        }
        return rowsUpdated;
    }

    private List<Goal> addValues(DatabaseConnection connection, TimeMetric timeMetric, List<Goal> goals) {
        if (goals.isEmpty()) {
            return new ArrayList<Goal>();
        }
        SQLInsertClause insert = connection.insert((RelationalPath)Tables.GOAL);
        for (Goal goal : goals) {
            insert.set(Tables.GOAL.CALENDAR_ID, (Object)goal.getCalendarId()).set((Path)Tables.GOAL.DEFAULT_GOAL, (Object)goal.isDefaultGoal()).set((Path)Tables.GOAL.JQL_QUERY, (Object)goal.getJqlQuery()).set(Tables.GOAL.POS, (Object)goal.getPosition()).set(Tables.GOAL.TARGET_DURATION, (Object)goal.getDuration()).set(Tables.GOAL.TIME_METRIC_ID, (Object)timeMetric.getId()).set(Tables.GOAL.TIME_UPDATED_DATE, (Object)this.toTimestampOrDefault(goal.getTimeUpdatedDate())).set(Tables.GOAL.TIME_UPDATED_MS_EPOCH, (Object)goal.getTimeUpdatedMsEpoch()).addBatch();
        }
        insert.execute();
        return this.getGoalsForTimeMetric(connection, timeMetric);
    }

    private List<Goal> getGoalsForTimeMetric(DatabaseConnection connection, TimeMetric timeMetric) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression)new GoalMapper()).from((Expression)Tables.GOAL)).where((Predicate)Tables.GOAL.TIME_METRIC_ID.eq((Object)timeMetric.getId()))).orderBy(new OrderSpecifier[]{Tables.GOAL.POS.asc(), Tables.GOAL.ID.asc()})).fetch();
    }

    private Timestamp toTimestampOrDefault(DateTime dateTime) {
        return (Timestamp)Option.option((Object)dateTime).map(dt -> new Timestamp(dateTime.getMillis())).getOrElse((Object)new Timestamp(0L));
    }
}

