/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.goal;

import com.atlassian.pocketknife.api.ao.dao.AbstractModel;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class Goal
extends AbstractModel
implements com.atlassian.servicedesk.internal.api.sla.goal.Goal {
    private final String jqlQuery;
    private final Long duration;
    private final Integer calendarId;
    private final boolean defaultGoal;
    private final int position;
    private final DateTime timeUpdatedDate;
    private final Long timeUpdatedMsEpoch;

    public Goal(Integer id, String jqlQuery, Long duration, Integer calendarId, boolean defaultGoal, int position, DateTime timeUpdatedDate, Long timeUpdatedMsEpoch) {
        super(id);
        this.jqlQuery = jqlQuery;
        this.duration = duration;
        this.calendarId = calendarId;
        this.defaultGoal = defaultGoal;
        this.position = position;
        this.timeUpdatedDate = timeUpdatedDate;
        this.timeUpdatedMsEpoch = timeUpdatedMsEpoch;
    }

    public String getJqlQuery() {
        return this.jqlQuery;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Integer getCalendarId() {
        return this.calendarId;
    }

    public boolean isDefaultGoal() {
        return this.defaultGoal;
    }

    public int getPosition() {
        return this.position;
    }

    public DateTime getTimeUpdatedDate() {
        return this.timeUpdatedDate;
    }

    public Long getTimeUpdatedMsEpoch() {
        return this.timeUpdatedMsEpoch;
    }

    public static GoalBuilder builder() {
        return new GoalBuilder();
    }

    public static GoalBuilder builder(Goal goal) {
        return new GoalBuilder(goal);
    }

    public boolean hasDuration() {
        return this.duration != null && this.duration > 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Goal)) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.jqlQuery != null ? this.jqlQuery.hashCode() : 0);
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        result = 31 * result + (this.calendarId != null ? this.calendarId.hashCode() : 0);
        result = 31 * result + (this.defaultGoal ? 1 : 0);
        result = 31 * result + this.position;
        result = 31 * result + (this.timeUpdatedDate != null ? this.timeUpdatedDate.hashCode() : 0);
        result = 31 * result + (this.timeUpdatedMsEpoch != null ? this.timeUpdatedMsEpoch.hashCode() : 0);
        return result;
    }

    public static class GoalBuilder {
        private Integer id;
        private String jqlQuery;
        private Long duration;
        private Integer calendarId;
        private boolean defaultGoal;
        private int position;
        private DateTime timeUpdatedDate;
        private Long timeUpdatedMsEpoch;

        public GoalBuilder() {
        }

        public GoalBuilder(Goal goal) {
            this.id(goal.id).jqlQuery(goal.jqlQuery).duration(goal.duration).calendarId(goal.calendarId).defaultGoal(goal.defaultGoal).position(goal.position).timeUpdatedDate(goal.timeUpdatedDate).timeUpdatedMsEpoch(goal.timeUpdatedMsEpoch);
        }

        public GoalBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public GoalBuilder jqlQuery(String jqlQuery) {
            this.jqlQuery = jqlQuery;
            return this;
        }

        public GoalBuilder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public GoalBuilder calendarId(Integer calendarId) {
            this.calendarId = calendarId;
            return this;
        }

        public GoalBuilder defaultGoal(boolean defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        public GoalBuilder position(int position) {
            this.position = position;
            return this;
        }

        public GoalBuilder timeUpdatedDate(DateTime timeUpdatedDate) {
            this.timeUpdatedDate = timeUpdatedDate;
            return this;
        }

        public GoalBuilder timeUpdatedMsEpoch(Long timeUpdatedMsEpoch) {
            this.timeUpdatedMsEpoch = timeUpdatedMsEpoch;
            return this;
        }

        public Goal build() {
            return new Goal(this.id, StringUtils.defaultString((String)this.jqlQuery), this.duration, this.calendarId, this.defaultGoal, this.position, this.timeUpdatedDate, this.timeUpdatedMsEpoch);
        }
    }
}

