/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.condition;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefMapper;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefQStore;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricConditionRefQStoreImpl
implements MetricConditionRefQStore {
    private DatabaseAccessor databaseAccessor;

    @Autowired
    public MetricConditionRefQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public Option<MetricConditionRef> createMetricCondition(TimeMetric timeMetric, MetricConditionRef metricConditionRef) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.createMetricCondition((DatabaseConnection)conn, timeMetric, metricConditionRef).flatMap(id -> this.getMetricCondition((DatabaseConnection)conn, timeMetric, (int)id)));
    }

    private Option<Integer> createMetricCondition(DatabaseConnection connection, TimeMetric timeMetric, MetricConditionRef metricConditionRef) {
        Integer insertedId = (Integer)connection.insert((RelationalPath)Tables.METRIC_CONDITION_REF).set((Path)Tables.METRIC_CONDITION_REF.CONDITION_ID, (Object)metricConditionRef.getConditionId()).set((Path)Tables.METRIC_CONDITION_REF.FACTORY_KEY, (Object)metricConditionRef.getFactoryKey()).set((Path)Tables.METRIC_CONDITION_REF.PLUGIN_KEY, (Object)metricConditionRef.getPluginKey()).set((Path)Tables.METRIC_CONDITION_REF.TYPE_NAME, (Object)metricConditionRef.getType().getName()).set(Tables.METRIC_CONDITION_REF.TIME_METRIC_ID, (Object)timeMetric.getId()).executeWithKey(Tables.METRIC_CONDITION_REF.ID);
        return Option.option((Object)insertedId);
    }

    @Override
    public List<MetricConditionRef> getMetricConditionsForTimeMetric(TimeMetric timeMetric) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression)new MetricConditionRefMapper()).from((Expression)Tables.METRIC_CONDITION_REF)).where((Predicate)Tables.METRIC_CONDITION_REF.TIME_METRIC_ID.eq((Object)timeMetric.getId()))).fetch());
    }

    @Override
    public Option<MetricConditionRef> getMetricCondition(TimeMetric timeMetric, int metricConditionId) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.getMetricCondition((DatabaseConnection)conn, timeMetric, metricConditionId));
    }

    private Option<MetricConditionRef> getMetricCondition(DatabaseConnection connection, TimeMetric timeMetric, int metricConditionId) {
        MetricConditionRef metricConditionRef = (MetricConditionRef)((Object)((SQLQuery)((SQLQuery)connection.select((Expression)new MetricConditionRefMapper()).from((Expression)Tables.METRIC_CONDITION_REF)).where((Predicate)Tables.METRIC_CONDITION_REF.TIME_METRIC_ID.eq((Object)timeMetric.getId()).and((Predicate)Tables.METRIC_CONDITION_REF.ID.eq((Object)metricConditionId)))).fetchOne());
        return Option.option((Object)((Object)metricConditionRef));
    }

    @Override
    public long deleteMetricCondition(TimeMetric timeMetric, MetricConditionRef metricConditionRef) {
        return (Long)this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.METRIC_CONDITION_REF).where((Predicate)Tables.METRIC_CONDITION_REF.TIME_METRIC_ID.eq((Object)timeMetric.getId()).and((Predicate)Tables.METRIC_CONDITION_REF.PLUGIN_KEY.eq((Object)metricConditionRef.getPluginKey())).and((Predicate)Tables.METRIC_CONDITION_REF.FACTORY_KEY.eq((Object)metricConditionRef.getFactoryKey())).and((Predicate)Tables.METRIC_CONDITION_REF.CONDITION_ID.eq((Object)metricConditionRef.getConditionId())).and((Predicate)Tables.METRIC_CONDITION_REF.TYPE_NAME.eq((Object)metricConditionRef.getType().getName()))).execute());
    }

    @Override
    public void deleteMetricConditionsByTimeMetric(TimeMetric timeMetric) {
        this.databaseAccessor.runInTransaction(conn -> {
            this.deleteMetricConditionsByTimeMetric((DatabaseConnection)conn, timeMetric);
            return Unit.Unit();
        });
    }

    @Override
    public void deleteMetricConditionsByTimeMetric(DatabaseConnection databaseConnection, TimeMetric timeMetric) {
        databaseConnection.delete((RelationalPath)Tables.METRIC_CONDITION_REF).where((Predicate)Tables.METRIC_CONDITION_REF.TIME_METRIC_ID.eq((Object)timeMetric.getId())).execute();
    }
}

