/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.calendar;

import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.CalendarInfoCalendarReference;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.CalendarReferenceService;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.ServiceDeskCalendarContextHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarReferenceServiceImpl
implements CalendarReferenceService {
    @Autowired
    private CalendarReferenceManager calendarReferenceManager;
    @Autowired
    private CalendarService calendarService;
    @Autowired
    private ServiceDeskCalendarContextHelper serviceDeskCalendarContextHelper;

    @Override
    public CalendarReference getDefaultReference() {
        return this.calendarReferenceManager.getDefaultReference();
    }

    @Override
    public CalendarReference getReferenceForGoal(Goal goal) {
        return this.calendarReferenceManager.getReferenceForGoal(goal);
    }

    @Override
    public List<CalendarReference> getAllCalendarReferences(ApplicationUser user, ServiceDesk serviceDesk) {
        Map<String, String> filter2 = this.serviceDeskCalendarContextHelper.getContextForServiceDesk(serviceDesk);
        List calendarsByServiceDesk = this.calendarService.getAllByFilter(user, filter2);
        return this.buildCompleteReferenceList(calendarsByServiceDesk);
    }

    private List<CalendarReference> buildCompleteReferenceList(List<Calendar> calendars) {
        ArrayList references = Lists.newArrayList();
        for (Calendar calendar : calendars) {
            references.add(new CalendarInfoCalendarReference((CalendarInfo)calendar));
        }
        references.add(this.getDefaultReference());
        return references;
    }
}

