/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionManager;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import io.atlassian.fugue.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimeMetricDefinitionServiceImpl
implements TimeMetricDefinitionService {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private TimeMetricDefinitionManager timeMetricDefinitionManager;

    @Override
    public TimeMetricDefinitionInfo loadDefinitionConfiguration(ApplicationUser user, TimeMetric timeMetric) {
        return this.timeMetricDefinitionManager.loadDefinitionConfiguration(timeMetric);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> validateDefinitionConfiguration(ApplicationUser user, ServiceDesk serviceDesk, TimeMetricDefinitionInfo definition) {
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.metric.condition.service.permission.error", (Object[])new Object[0]));
        }
        return this.timeMetricDefinitionManager.validateDefinitionConfiguration(serviceDesk, definition);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetricDefinitionInfo> updateDefinitionConfiguration(ApplicationUser user, ServiceDesk serviceDesk, TimeMetric timeMetric, TimeMetricDefinitionInfo definition) {
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.metric.condition.service.permission.error", (Object[])new Object[0]));
        }
        return this.timeMetricDefinitionManager.updateDefinitionConfiguration(serviceDesk, timeMetric, definition);
    }
}

