/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricCreationService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldService;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimeMetricCreationServiceImpl
implements TimeMetricCreationService {
    @Autowired
    private SLAFieldService slaFieldService;
    @Autowired
    private InternalTimeMetricService timeMetricService;

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, String metricName, String customFieldName) {
        CustomField customField;
        io.atlassian.fugue.Either<ErrorCollection, Option<CustomField>> validatedField = this.validate(user, serviceDesk, metricName, customFieldName);
        if (validatedField.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validatedField.left().get());
        }
        if (((Option)validatedField.right().get()).isEmpty()) {
            io.atlassian.fugue.Either<ErrorCollection, CustomField> slaField = this.slaFieldService.createSLAField(user, customFieldName);
            if (slaField.isLeft()) {
                return io.atlassian.fugue.Either.left((Object)slaField.left().get());
            }
            customField = (CustomField)slaField.right().get();
        } else {
            customField = (CustomField)((Option)validatedField.right().get()).get();
        }
        return this.timeMetricService.createTimeMetric(user, serviceDesk, metricName, customField);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, String metricName, long customFieldId) {
        io.atlassian.fugue.Either<ErrorCollection, CustomField> byId = this.slaFieldService.getById(user, customFieldId);
        if (byId.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)byId.left().get());
        }
        return this.timeMetricService.createTimeMetric(user, serviceDesk, metricName, (CustomField)byId.right().get());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> validateTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, String metricName, String customFieldName) {
        String finalName = StringUtils.defaultString((String)metricName).trim();
        if (finalName.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"name", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.metric.name.required", (Object[])new Object[0]));
        }
        io.atlassian.fugue.Either<ErrorCollection, Option<CustomField>> field = this.validate(user, serviceDesk, metricName, customFieldName);
        if (field.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)field.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    private io.atlassian.fugue.Either<ErrorCollection, Option<CustomField>> validate(ApplicationUser user, ServiceDesk serviceDesk, String metricName, String customFieldName) {
        io.atlassian.fugue.Either<ErrorCollection, CustomField> field = this.slaFieldService.getByName(user, customFieldName);
        if (field.isLeft()) {
            if (!this.slaFieldService.canManageField(user)) {
                return StepsConverters.newerEither((Either)ServiceResult.error((String)"name", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.metric.custom.field.forbidden.to.add", (Object[])new Object[0]));
            }
            io.atlassian.fugue.Either<ErrorCollection, String> fieldName = this.slaFieldService.validateFieldName(customFieldName);
            if (fieldName.isLeft()) {
                return io.atlassian.fugue.Either.left((Object)fieldName.left().get());
            }
        }
        long realOrFakeFieldId = field.isLeft() ? 0L : ((CustomField)field.right().get()).getIdAsLong();
        TimeMetric validationMetric = TimeMetric.builder().name(metricName).customFieldId(realOrFakeFieldId).build();
        io.atlassian.fugue.Either<ErrorCollection, Unit> metricValidationResult = this.timeMetricService.validateMetric(user, serviceDesk, validationMetric);
        if (metricValidationResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)metricValidationResult.left().get());
        }
        if (field.isLeft()) {
            return io.atlassian.fugue.Either.right((Object)Option.none());
        }
        return io.atlassian.fugue.Either.right((Object)Option.some((Object)field.right().get()));
    }
}

