/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarBuilder;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarService;
import com.atlassian.jira.plugins.workinghours.api.calendar.Weekday;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTimeBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.user.ServiceDeskUserTimeZoneService;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.CascadingCustomFieldUtil;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.ProjectTemplateCustomFieldsManager;
import com.atlassian.servicedesk.internal.feature.gettingstarted.ServiceDeskProjectTemplateType;
import com.atlassian.servicedesk.internal.feature.jira.issuetype.ServiceDeskIssueTypeManager;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.configuration.SLAGettingStartedService;
import com.atlassian.servicedesk.internal.sla.configuration.condition.ConditionType;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefService;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import com.atlassian.servicedesk.internal.sla.task.SlaConsistencyCheckStatus;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyService;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SLAGettingStartedServiceImpl
implements SLAGettingStartedService {
    private static final String PLUGIN_KEY = "com.atlassian.servicedesk";
    public static final String CONTEXT_OWNER_KEY = "owner";
    public static final String CONTEXT_OWNER_VALUE = "com.atlassian.servicedesk";
    public static final String CONTEXT_SERVICE_DESK_ID_KEY = "serviceDeskId";
    private static final String CLOSED_STATUS_KEY = "sd.workflow.closed";
    private static final String AWAITING_CAB_APPROVAL_STATUS_KEY = "sd.workflow.awaiting.cab.approval";
    private static final String PEER_REVIEW_STATUS_KEY = "sd.workflow.peer.review.change.manager.approval";
    private static final String AWAITING_IMPLEMENTATION_STATUS_KEY = "sd.workflow.awaiting.implementation";
    private static final String CANCELED_STATUS_KEY = "sd.workflow.canceled";
    private static final String DECLINED_STATUS_KEY = "sd.workflow.declined";
    private static final String IMPLEMENTING_STATUS_KEY = "sd.workflow.implementing";
    private static final String PENDING_STATUS_KEY = "sd.workflow.pending";
    private static final String RESOLVED_STATUS_KEY = "sd.workflow.resolved";
    private static final String PLANNING_STATUS_KEY = "sd.workflow.planning";
    @Autowired
    private ServiceDeskService serviceDeskService;
    @Autowired
    private SLAFieldManager slaFieldManager;
    @Autowired
    private InternalTimeMetricService timeMetricService;
    @Autowired
    private MetricConditionRefService metricConditionRefService;
    @Autowired
    private I18nHelper.BeanFactory i18nHelper;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private GoalManager goalManager;
    @Autowired
    private ConstantsService constantsService;
    @Autowired
    private SlaDataConsistencyService slaDataConsistencyService;
    @Autowired
    private PriorityManager priorityManager;
    @Autowired
    private SearchService searchService;
    @Autowired
    private ServiceDeskUserTimeZoneService userTimeZoneService;
    @Autowired
    private CalendarService calendarService;
    @Autowired
    private ServiceDeskIssueTypeManager serviceDeskIssueTypeManager;
    @Autowired
    private ProjectTemplateCustomFieldsManager customFieldsManager;
    @Autowired
    private VpOriginCustomFieldService vpOriginCustomFieldService;

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> createSLAConfigurationForExistingProject(CheckedUser user, Project project) {
        ApplicationUser appUser = user.forJIRA();
        io.atlassian.fugue.Either serviceDeskResult = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(appUser, project));
        if (serviceDeskResult.isLeft()) {
            return StepsConverters.newerEither((Either)com.atlassian.pocketknife.api.util.ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.servicedesk.not.found", (Object[])new Object[0]));
        }
        ServiceDesk sd = (ServiceDesk)serviceDeskResult.right().get();
        io.atlassian.fugue.Either<ErrorCollection, Calendar> calendar = this.createNineToFiveCalendar(user, sd);
        if (calendar.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)calendar.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeToResolutionMetric = this.createTimeToResolutionMetricForExistingProject(appUser, sd, ((Calendar)calendar.right().get()).getId());
        if (timeToResolutionMetric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)timeToResolutionMetric.left().get());
        }
        io.atlassian.fugue.Either<ErrorCollection, SlaConsistencyCheckStatus> consistencyCheckQueueResult = this.slaDataConsistencyService.requestConsistencyCheck(appUser, sd, (io.atlassian.fugue.Option<SlaAuditLogReason>)io.atlassian.fugue.Option.some((Object)((Object)SlaAuditLogReason.PROJECT_MIGRATION)));
        if (consistencyCheckQueueResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)consistencyCheckQueueResult.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    private io.atlassian.fugue.Either<ErrorCollection, io.atlassian.fugue.Option<TimeMetric>> conditionallyCreateTimeMetric(boolean condition, Supplier<io.atlassian.fugue.Either<ErrorCollection, TimeMetric>> supplier) {
        if (condition) {
            return supplier.get().map(io.atlassian.fugue.Option::some);
        }
        return io.atlassian.fugue.Either.right((Object)io.atlassian.fugue.Option.none(TimeMetric.class));
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, List<TimeMetric>> createSLAConfigurationForEmptyProject(CheckedUser user, Project project, ServiceDeskProjectTemplateType templateType) {
        ApplicationUser appUser = user.forJIRA();
        io.atlassian.fugue.Either serviceDeskResult = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(appUser, project));
        if (serviceDeskResult.isLeft()) {
            return StepsConverters.newerEither((Either)com.atlassian.pocketknife.api.util.ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.servicedesk.not.found", (Object[])new Object[0]));
        }
        ServiceDesk sd = (ServiceDesk)serviceDeskResult.right().get();
        return Steps.begin(this.createNineToFiveCalendar(user, sd)).then(calendar -> this.createTimeToResolutionMetricForEmptyProject(appUser, sd, calendar.getId(), templateType)).then((calendar, timeToResolutionMetric) -> {
            boolean condition = ServiceDeskProjectTemplateType.ITIL.equals((Object)templateType) || ServiceDeskProjectTemplateType.ITILV2.equals((Object)templateType) || ServiceDeskProjectTemplateType.CUSTOMER_SUPPORT.equals((Object)templateType) || ServiceDeskProjectTemplateType.BASIC.equals((Object)templateType);
            return this.conditionallyCreateTimeMetric(condition, () -> this.createTimeToFirstResponseMetricForEmptyProject(appUser, sd, calendar.getId(), templateType));
        }).then((calendar, timeToResolutionMetric, timeToFirstResponseMetricOption) -> {
            boolean condition = ServiceDeskProjectTemplateType.ITILV2.equals((Object)templateType);
            return this.conditionallyCreateTimeMetric(condition, () -> this.createTimeToCloseAfterResolveMetricForEmptyProject(appUser, sd, calendar.getId(), templateType));
        }).then((calendar, timeToResolutionMetric, timeToFirstResponseMetricOption, timeToCloseAfterResolveMetricOption) -> {
            boolean condition = ServiceDeskProjectTemplateType.ITILV2.equals((Object)templateType);
            return this.conditionallyCreateTimeMetric(condition, () -> this.createTimeToApproveNormalChangeMetricForEmptyProject(appUser, sd, calendar.getId(), templateType));
        }).yield((calendar, timeToResolutionMetric, timeToFirstResponseMetricOption, timeToCloseAfterResolveMetricOption, timeToApproveNormalChangeMetricOption) -> {
            ArrayList<TimeMetric> slas = new ArrayList<TimeMetric>();
            slas.add((TimeMetric)((Object)timeToResolutionMetric));
            timeToFirstResponseMetricOption.forEach(slas::add);
            timeToCloseAfterResolveMetricOption.forEach(slas::add);
            timeToApproveNormalChangeMetricOption.forEach(slas::add);
            return slas;
        });
    }

    private io.atlassian.fugue.Either<ErrorCollection, Calendar> createNineToFiveCalendar(CheckedUser user, ServiceDesk sd) {
        CalendarBuilder cb = CalendarBuilder.builder();
        cb.name(this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale()).getText("sd.sla.metric.getting.started.calendar.name"));
        cb.timezone(DateTimeZone.forTimeZone((TimeZone)this.userTimeZoneService.getUserTimeZone(user)));
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(CONTEXT_OWNER_KEY, "com.atlassian.servicedesk");
        context.put(CONTEXT_SERVICE_DESK_ID_KEY, Integer.toString(sd.getId()));
        cb.context(context);
        WorkingTimeBuilder wb = WorkingTimeBuilder.builder();
        wb.start(Long.valueOf(TimeUnit.HOURS.toMillis(9L)));
        wb.end(Long.valueOf(TimeUnit.HOURS.toMillis(17L)));
        wb.weekday(Weekday.MONDAY);
        cb.addWorkingTime(wb.build());
        wb.weekday(Weekday.TUESDAY);
        cb.addWorkingTime(wb.build());
        wb.weekday(Weekday.WEDNESDAY);
        cb.addWorkingTime(wb.build());
        wb.weekday(Weekday.THURSDAY);
        cb.addWorkingTime(wb.build());
        wb.weekday(Weekday.FRIDAY);
        cb.addWorkingTime(wb.build());
        return StepsConverters.newerEither((Either)this.calendarService.create(user.forJIRA(), cb.build()));
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeToResolutionMetricForExistingProject(ApplicationUser user, ServiceDesk sd, Integer calendarId) {
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetricResult = this.create(user, sd, "sd.sla.metric.time.to.resolution.name", new ConditionData[]{new ConditionData("com.atlassian.servicedesk", "issue-created-sla-condition-factory", "issue-created-hit-condition", ConditionType.START), new ConditionData("com.atlassian.servicedesk", "resolution-sla-condition-factory", "resolution-cleared-hit-condition", ConditionType.START), new ConditionData("com.atlassian.servicedesk", "resolution-sla-condition-factory", "resolution-set-hit-condition", ConditionType.STOP)});
        if (timeMetricResult.isLeft()) {
            return timeMetricResult;
        }
        io.atlassian.fugue.Either<ErrorCollection, List<Goal>> goals = this.createTimeToResolutionDefaultGoals((TimeMetric)((Object)timeMetricResult.right().get()), calendarId);
        if (goals.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)goals.left().get());
        }
        return timeMetricResult;
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeToResolutionMetricForEmptyProject(ApplicationUser user, ServiceDesk sd, Integer calendarId, ServiceDeskProjectTemplateType templateType) {
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetricResult = this.create(user, sd, "sd.sla.metric.time.to.resolution.name", new ConditionData[]{new ConditionData("com.atlassian.servicedesk", "issue-created-sla-condition-factory", "issue-created-hit-condition", ConditionType.START), new ConditionData("com.atlassian.servicedesk", "resolution-sla-condition-factory", "resolution-cleared-hit-condition", ConditionType.START), new ConditionData("com.atlassian.servicedesk", "resolution-sla-condition-factory", "resolution-set-hit-condition", ConditionType.STOP)});
        if (timeMetricResult.isLeft()) {
            return timeMetricResult;
        }
        TimeMetric metric = (TimeMetric)((Object)timeMetricResult.right().get());
        io.atlassian.fugue.Either<ErrorCollection, List<Goal>> goals = this.timeToResolutionGoalsHelper(calendarId, templateType, metric);
        if (goals.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)goals.left().get());
        }
        return timeMetricResult;
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> timeToResolutionGoalsHelper(Integer calendarId, ServiceDeskProjectTemplateType templateType, TimeMetric metric) {
        if (ServiceDeskProjectTemplateType.CLASSIC.equals((Object)templateType)) {
            return this.createTimeToResolutionDefaultGoals(metric, calendarId);
        }
        if (ServiceDeskProjectTemplateType.ITIL.equals((Object)templateType)) {
            return this.createTimeToResolutionITILGoals(metric, calendarId);
        }
        if (ServiceDeskProjectTemplateType.CUSTOMER_SUPPORT.equals((Object)templateType)) {
            return this.createTimeToResolutionCustomerGoals(metric, calendarId);
        }
        if (ServiceDeskProjectTemplateType.BASIC.equals((Object)templateType)) {
            return this.createTimeToResolutionBasicGoals(metric, calendarId);
        }
        if (ServiceDeskProjectTemplateType.ITILV2.equals((Object)templateType)) {
            return this.createTimeToResolutionITILV2Goals(metric, calendarId);
        }
        return this.createDefaultGoals(metric, calendarId);
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeToFirstResponseMetricForEmptyProject(ApplicationUser user, ServiceDesk sd, Integer calendarId, ServiceDeskProjectTemplateType templateType) {
        ServiceOutcome<Status> waitingForCustomer = this.getWaitingForCustomerStatus(user);
        ArrayList conditionDatas = Lists.newArrayList((Object[])new ConditionData[]{new ConditionData("com.atlassian.servicedesk", "issue-created-sla-condition-factory", "issue-created-hit-condition", ConditionType.START), new ConditionData("com.atlassian.servicedesk", "resolution-sla-condition-factory", "resolution-set-hit-condition", ConditionType.STOP), new ConditionData("com.atlassian.servicedesk", "comment-sla-condition-factory", "comment-for-reporter-hit-condition", ConditionType.STOP)});
        if (waitingForCustomer.isValid()) {
            conditionDatas.add(new ConditionData("com.atlassian.servicedesk", "status-sla-condition-factory", ((Status)waitingForCustomer.getReturnedValue()).getId(), ConditionType.STOP));
        }
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetricResult = this.create(user, sd, "sd.sla.metric.time.to.first.response.name", conditionDatas.toArray(new ConditionData[conditionDatas.size()]));
        return timeMetricResult.flatMap(timeMetric -> {
            if (ServiceDeskProjectTemplateType.CUSTOMER_SUPPORT.equals((Object)templateType)) {
                return this.createTimeToFirstResponseCustomerGoals((TimeMetric)((Object)timeMetric), calendarId).flatMap(goal -> timeMetricResult);
            }
            if (ServiceDeskProjectTemplateType.BASIC.equals((Object)templateType)) {
                return this.createTimeToFirstResponseBasicGoals((TimeMetric)((Object)timeMetric), calendarId).flatMap(goal -> timeMetricResult);
            }
            if (ServiceDeskProjectTemplateType.ITILV2.equals((Object)templateType)) {
                return this.createTimeToFirstResponseItilV2Goals((TimeMetric)((Object)timeMetric), calendarId).flatMap(goal -> timeMetricResult);
            }
            return this.createDefaultGoals((TimeMetric)((Object)timeMetric), calendarId).flatMap(goal -> timeMetricResult);
        });
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeToCloseAfterResolveMetricForEmptyProject(ApplicationUser user, ServiceDesk sd, Integer calendarId, ServiceDeskProjectTemplateType templateType) {
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetricResult;
        ServiceOutcome<Status> closedStatus = this.getStatus(user, CLOSED_STATUS_KEY);
        ArrayList conditionDatas = Lists.newArrayList((Object[])new ConditionData[]{new ConditionData("com.atlassian.servicedesk", "resolution-sla-condition-factory", "resolution-set-hit-condition", ConditionType.START), new ConditionData("com.atlassian.servicedesk", "resolution-sla-condition-factory", "resolution-cleared-hit-condition", ConditionType.STOP)});
        if (closedStatus.isValid()) {
            conditionDatas.add(new ConditionData("com.atlassian.servicedesk", "status-sla-condition-factory", ((Status)closedStatus.getReturnedValue()).getId(), ConditionType.STOP));
        }
        if ((timeMetricResult = this.create(user, sd, "sd.project.template.itil.v2.sla.time.to.close.after.resolve.name", conditionDatas.toArray(new ConditionData[conditionDatas.size()]))).isLeft()) {
            return timeMetricResult;
        }
        return timeMetricResult.flatMap(timeMetric -> this.createTimeToCloseAfterResolveGoals((TimeMetric)((Object)timeMetric), calendarId).flatMap(goal -> timeMetricResult));
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToCloseAfterResolveGoals(TimeMetric timeMetric, Integer calendarId) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        DateTime timeUpdatedDate = DateTime.now();
        ArrayList<Goal> goals = new ArrayList<Goal>();
        ArrayList<io.atlassian.fugue.Option<IssueType>> issueTypeOptions = new ArrayList<io.atlassian.fugue.Option<IssueType>>();
        issueTypeOptions.add(this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.itil.issuetype.incident.name")));
        issueTypeOptions.add(this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.itil.issuetype.service.request.name")));
        issueTypeOptions.add(this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.name")));
        List<String> issueTypeNames = issueTypeOptions.stream().filter(Maybe::isDefined).map(Maybe::get).map(IssueConstant::getName).collect(Collectors.toList());
        goals.add(new Goal.GoalBuilder().position(0).jqlQuery(this.buildMultipleIssueTypeBasedJql(issueTypeNames)).duration(TimeUnit.HOURS.toMillis(24L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
        Goal defaultGoal = new Goal.GoalBuilder().position(1).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        goals.add(defaultGoal);
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeToApproveNormalChangeMetricForEmptyProject(ApplicationUser user, ServiceDesk sd, Integer calendarId, ServiceDeskProjectTemplateType templateType) {
        ArrayList startStatuses = Lists.newArrayList((Object[])new ServiceOutcome[]{this.getStatus(user, AWAITING_CAB_APPROVAL_STATUS_KEY), this.getStatus(user, PEER_REVIEW_STATUS_KEY)});
        ArrayList stopStatuses = Lists.newArrayList((Object[])new ServiceOutcome[]{this.getStatus(user, AWAITING_IMPLEMENTATION_STATUS_KEY), this.getStatus(user, CANCELED_STATUS_KEY), this.getStatus(user, CLOSED_STATUS_KEY), this.getStatus(user, DECLINED_STATUS_KEY), this.getStatus(user, IMPLEMENTING_STATUS_KEY), this.getStatus(user, PENDING_STATUS_KEY), this.getStatus(user, PLANNING_STATUS_KEY), this.getStatus(user, RESOLVED_STATUS_KEY)});
        ArrayList conditionDatas = new ArrayList();
        startStatuses.stream().filter(ServiceResult::isValid).forEach(status -> conditionDatas.add(new ConditionData("com.atlassian.servicedesk", "status-sla-condition-factory", ((Status)status.getReturnedValue()).getId(), ConditionType.START)));
        stopStatuses.stream().filter(ServiceResult::isValid).forEach(status -> conditionDatas.add(new ConditionData("com.atlassian.servicedesk", "status-sla-condition-factory", ((Status)status.getReturnedValue()).getId(), ConditionType.STOP)));
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetricResult = this.create(user, sd, "sd.project.template.itil.v2.sla.time.to.approve.normal.change.name", conditionDatas.toArray(new ConditionData[conditionDatas.size()]));
        if (timeMetricResult.isLeft()) {
            return timeMetricResult;
        }
        return timeMetricResult.flatMap(timeMetric -> this.createTimeToApproveNormalChangeGoals((TimeMetric)((Object)timeMetric), calendarId).flatMap(goal -> timeMetricResult));
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToApproveNormalChangeGoals(TimeMetric timeMetric, Integer calendarId) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        DateTime timeUpdatedDate = DateTime.now();
        ArrayList<Goal> goals = new ArrayList<Goal>();
        this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.itil.issuetype.change.name")).forEach(changeIssueType -> {
            io.atlassian.fugue.Option<Options> optionsOption;
            Query jqlQuery = JqlQueryBuilder.newBuilder().where().issueType().eq(i18n.getText("sd.project.template.itil.issuetype.change.name")).endWhere().buildQuery();
            io.atlassian.fugue.Option<CustomField> changeTypeOption = this.customFieldsManager.getOrCreateChangeTypeCustomField();
            if (changeTypeOption.isDefined() && (optionsOption = CascadingCustomFieldUtil.getOptionsForCustomField((CustomField)changeTypeOption.get())).isDefined()) {
                Options options = (Options)optionsOption.get();
                List normalOption = options.stream().filter(option -> option.toString().equals(i18n.getText("sd.project.template.itil.v2.custom.field.change.type.value.normal"))).collect(Collectors.toList());
                jqlQuery = JqlQueryBuilder.newBuilder((Query)jqlQuery).where().and().field(((CustomField)changeTypeOption.get()).getFieldName()).eq(((Option)normalOption.get(0)).getValue()).endWhere().buildQuery();
            }
            goals.add(new Goal.GoalBuilder().position(0).jqlQuery(this.searchService.getJqlString(jqlQuery)).duration(TimeUnit.HOURS.toMillis(40L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
        });
        Goal defaultGoal = new Goal.GoalBuilder().position(1).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        goals.add(defaultGoal);
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private ServiceOutcome<Status> getWaitingForCustomerStatus(ApplicationUser user) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        String waitingForCustomerStatusName = i18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.customer");
        return this.constantsService.getStatusByName(user, waitingForCustomerStatusName);
    }

    private ServiceOutcome<Status> getWaitingForSupportStatus(ApplicationUser user) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        String waitingForSupportStatusName = i18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.support");
        return this.constantsService.getStatusByName(user, waitingForSupportStatusName);
    }

    private ServiceOutcome<Status> getStatus(ApplicationUser user, String i18nKey) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        String statusName = i18n.getText(i18nKey);
        return this.constantsService.getStatusByName(user, statusName);
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> create(ApplicationUser user, ServiceDesk sd, String name, ConditionData[] conditions) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        io.atlassian.fugue.Either<ErrorCollection, TimeMetric> timeMetric = this.createTimeMetric(user, sd, i18n.getText(name));
        if (timeMetric.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)timeMetric.left().get());
        }
        for (ConditionData conditionData : conditions) {
            MetricConditionRef condition = MetricConditionRef.builder().pluginKey(conditionData.pluginKey).factoryKey(conditionData.factoryKey).conditionId(conditionData.conditionId).type(conditionData.type).build();
            io.atlassian.fugue.Either<ErrorCollection, MetricConditionRef> conditionResult = this.metricConditionRefService.addCondition(user, sd, (TimeMetric)((Object)timeMetric.right().get()), condition);
            if (!conditionResult.isLeft()) continue;
            return io.atlassian.fugue.Either.left((Object)conditionResult.left().get());
        }
        return timeMetric;
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createDefaultGoals(TimeMetric timeMetric, Integer calendarId) {
        DateTime timeUpdatedDate = DateTime.now();
        ArrayList<Goal> goals = new ArrayList<Goal>();
        Goal defaultGoal = new Goal.GoalBuilder().position(2).duration(TimeUnit.HOURS.toMillis(4L)).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        goals.add(defaultGoal);
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToResolutionITILGoals(TimeMetric timeMetric, Integer calendarId) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        DateTime timeUpdatedDate = DateTime.now();
        ArrayList<Goal> goals = new ArrayList<Goal>();
        this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.itil.issuetype.incident.name")).forEach(incidentIssueType -> goals.add(new Goal.GoalBuilder().position(0).jqlQuery(this.buildIssueTypeBasedJql((IssueType)incidentIssueType)).duration(TimeUnit.HOURS.toMillis(4L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build()));
        this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.itil.issuetype.service.request.name")).forEach(serviceRequestIssueType -> goals.add(new Goal.GoalBuilder().position(1).jqlQuery(this.buildIssueTypeBasedJql((IssueType)serviceRequestIssueType)).duration(TimeUnit.HOURS.toMillis(8L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build()));
        Goal defaultGoal = new Goal.GoalBuilder().position(2).duration(TimeUnit.HOURS.toMillis(40L)).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        goals.add(defaultGoal);
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToFirstResponseCustomerGoals(TimeMetric timeMetric, Integer calendarId) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        DateTime timeUpdatedDate = DateTime.now();
        ArrayList<Goal> goals = new ArrayList<Goal>();
        io.atlassian.fugue.Option<IssueType> bugIssueTypeOpt = this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.customer.support.issuetype.bug.name"));
        for (IssueType bugIssueType : bugIssueTypeOpt) {
            List jiraPriorities = this.priorityManager.getPriorities();
            if (jiraPriorities.size() > 0) {
                Priority topPriority = (Priority)jiraPriorities.get(0);
                String criticalBugsJql = this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().issueType(new String[]{bugIssueType.getName()}).and().priority(new String[]{topPriority.getName()}).buildQuery());
                goals.add(new Goal.GoalBuilder().position(0).jqlQuery(criticalBugsJql).duration(TimeUnit.HOURS.toMillis(1L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
            }
            if (jiraPriorities.size() <= 1) continue;
            Priority secondTopPriority = (Priority)jiraPriorities.get(1);
            String highBugsJql = this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().issueType(new String[]{bugIssueType.getName()}).and().priority(new String[]{secondTopPriority.getName()}).buildQuery());
            goals.add(new Goal.GoalBuilder().position(1).jqlQuery(highBugsJql).duration(TimeUnit.HOURS.toMillis(4L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
        }
        goals.add(new Goal.GoalBuilder().position(2).duration(TimeUnit.HOURS.toMillis(8L)).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToResolutionCustomerGoals(TimeMetric timeMetric, Integer calendarId) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        DateTime timeUpdatedDate = DateTime.now();
        ArrayList<Goal> goals = new ArrayList<Goal>();
        this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.customer.support.issuetype.bug.name")).forEach(bugIssueType -> {
            if (this.priorityManager.getPriorities().size() > 0) {
                String criticalIssues = this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().priority(new String[]{((Priority)this.priorityManager.getPriorities().get(0)).getName()}).buildQuery());
                goals.add(new Goal.GoalBuilder().jqlQuery(criticalIssues).position(0).duration(TimeUnit.HOURS.toMillis(4L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
            }
            String technicalSupportJql = this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldService.getVpOriginCustomField().getFieldName()).eq(i18n.getText("sd.project.template.customer.support.requesttype.technical.support.name")).endWhere().buildQuery());
            goals.add(new Goal.GoalBuilder().jqlQuery(technicalSupportJql).position(1).duration(TimeUnit.HOURS.toMillis(16L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
        });
        Goal defaultGoal = new Goal.GoalBuilder().position(2).duration(TimeUnit.HOURS.toMillis(24L)).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        goals.add(defaultGoal);
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToResolutionBasicGoals(TimeMetric timeMetric, Integer calendarId) {
        DateTime timeUpdatedDate = DateTime.now();
        List jiraPriorities = this.priorityManager.getPriorities();
        Priority topPriority = (Priority)jiraPriorities.get(0);
        String topPriorityGoalJql = this.buildPriorityBasedJql(topPriority);
        Goal blocker = new Goal.GoalBuilder().position(0).jqlQuery(topPriorityGoalJql).duration(TimeUnit.HOURS.toMillis(4L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        Goal defaultGoal = new Goal.GoalBuilder().position(1).duration(TimeUnit.HOURS.toMillis(16L)).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        ArrayList goals = Lists.newArrayList((Object[])new Goal[]{blocker, defaultGoal});
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToFirstResponseBasicGoals(TimeMetric timeMetric, Integer calendarId) {
        DateTime timeUpdatedDate = DateTime.now();
        List jiraPriorities = this.priorityManager.getPriorities();
        Priority topPriority = (Priority)jiraPriorities.get(0);
        String topPriorityGoalJql = this.buildPriorityBasedJql(topPriority);
        ArrayList<Goal> goals = new ArrayList<Goal>();
        goals.add(new Goal.GoalBuilder().position(0).jqlQuery(topPriorityGoalJql).duration(TimeUnit.HOURS.toMillis(2L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
        goals.add(new Goal.GoalBuilder().position(1).duration(TimeUnit.HOURS.toMillis(8L)).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToResolutionITILV2Goals(TimeMetric timeMetric, Integer calendarId) {
        return this.createITILV2Goals(timeMetric, calendarId, 4, 8);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToFirstResponseItilV2Goals(TimeMetric timeMetric, Integer calendarId) {
        return this.createITILV2Goals(timeMetric, calendarId, 2, 4);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createITILV2Goals(TimeMetric timeMetric, Integer calendarId, Integer firstGoalHours, Integer secondGoalHours) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        DateTime timeUpdatedDate = DateTime.now();
        ArrayList<Goal> goals = new ArrayList<Goal>();
        this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.itil.issuetype.incident.name")).forEach(incidentIssueType -> goals.add(new Goal.GoalBuilder().position(0).jqlQuery(this.buildIssueTypeBasedJql((IssueType)incidentIssueType)).duration(TimeUnit.HOURS.toMillis(firstGoalHours.intValue())).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build()));
        ArrayList<io.atlassian.fugue.Option<IssueType>> issueTypeOptions = new ArrayList<io.atlassian.fugue.Option<IssueType>>();
        issueTypeOptions.add(this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.project.template.itil.issuetype.service.request.name")));
        issueTypeOptions.add(this.serviceDeskIssueTypeManager.getIssueTypeByName(i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.name")));
        List<String> issueTypeNames = issueTypeOptions.stream().filter(Maybe::isDefined).map(Maybe::get).map(IssueConstant::getName).collect(Collectors.toList());
        goals.add(new Goal.GoalBuilder().position(1).jqlQuery(this.buildMultipleIssueTypeBasedJql(issueTypeNames)).duration(TimeUnit.HOURS.toMillis(secondGoalHours.intValue())).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build());
        Goal defaultGoal = new Goal.GoalBuilder().position(2).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        goals.add(defaultGoal);
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private io.atlassian.fugue.Either<ErrorCollection, List<Goal>> createTimeToResolutionDefaultGoals(TimeMetric timeMetric, Integer calendarId) {
        DateTime timeUpdatedDate = DateTime.now();
        List jiraPriorities = this.priorityManager.getPriorities();
        Priority topPriority = (Priority)jiraPriorities.get(0);
        String topPriorityGoalJql = this.buildPriorityBasedJql(topPriority);
        Goal blocker = new Goal.GoalBuilder().position(0).jqlQuery(topPriorityGoalJql).duration(TimeUnit.HOURS.toMillis(1L)).calendarId(calendarId).defaultGoal(false).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        Goal defaultGoal = new Goal.GoalBuilder().position(2).duration(TimeUnit.HOURS.toMillis(4L)).calendarId(calendarId).defaultGoal(true).timeUpdatedMsEpoch(timeUpdatedDate.getMillis()).build();
        ArrayList goals = Lists.newArrayList((Object[])new Goal[]{blocker, defaultGoal});
        return this.goalManager.updateAll(timeMetric, goals);
    }

    private String buildPriorityBasedJql(Priority priority) {
        if (priority == null) {
            return "";
        }
        Query query = JqlQueryBuilder.newBuilder().where().priority(new String[]{priority.getName()}).buildQuery();
        return this.searchService.getJqlString(query);
    }

    private String buildIssueTypeBasedJql(IssueType issueType) {
        Query query = JqlQueryBuilder.newBuilder().where().issueType(new String[]{issueType.getName()}).buildQuery();
        return this.searchService.getJqlString(query);
    }

    private String buildMultipleIssueTypeBasedJql(List<String> issueTypeNames) {
        Query query = JqlQueryBuilder.newBuilder().where().issueType().in(issueTypeNames.toArray(new String[issueTypeNames.size()])).buildQuery();
        return this.searchService.getJqlString(query);
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeMetric(ApplicationUser user, ServiceDesk sd, String name) {
        io.atlassian.fugue.Either<ErrorCollection, CustomField> byName = this.slaFieldManager.getByName(name);
        if (byName.isLeft() && (byName = this.slaFieldManager.createSLAField(name)).isLeft()) {
            return io.atlassian.fugue.Either.left((Object)byName.left().get());
        }
        return this.timeMetricService.createTimeMetric(user, sd, name, (CustomField)byName.right().get());
    }

    class ConditionData {
        String pluginKey;
        String factoryKey;
        String conditionId;
        ConditionType type;

        ConditionData(String pluginKey, String factoryKey, String conditionId, ConditionType type) {
            this.pluginKey = pluginKey;
            this.factoryKey = factoryKey;
            this.conditionId = conditionId;
            this.type = type;
        }
    }
}

