/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.internal.sla.condition.factory.StatusConditionHelper;
import com.atlassian.servicedesk.internal.sla.condition.factory.StatusHitCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.StatusMatchCondition;
import com.atlassian.servicedesk.internal.workflow.ServiceDeskJiraWorkflowManager;
import com.atlassian.servicedesk.internal.workflow.ServiceDeskManagedJiraWorkflow;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricConditionFactory;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class StatusTimeMetricConditionFactory
implements TimeMetricConditionFactory {
    public static final String FACTORY_ID = "status-sla-condition-factory";
    protected final Log log = Log.with(this.getClass());
    @Autowired
    private ServiceDeskJiraWorkflowManager workflowManager;
    @Autowired
    private WorkflowSchemeManager workflowSchemeManager;
    @Autowired
    private StatusManager statusManager;
    @Autowired
    private StatusConditionHelper statusConditionHelper;

    public StatusMatchCondition getMatchCondition(String id) {
        Status status = this.statusManager.getStatus(id);
        if (status != null) {
            return new StatusMatchCondition(status, this.statusConditionHelper);
        }
        this.log.warn("Cannot find status with id %s. Please remove the unknown status from your time metric configuration", new Object[]{id});
        return null;
    }

    public TimeMetricHitCondition getHitCondition(String id) {
        Status status = this.statusManager.getStatus(id);
        if (status != null) {
            return new StatusHitCondition(status, this.statusConditionHelper);
        }
        this.log.warn("Cannot find status with id %s. Please remove the unknown status from your time metric configuration", new Object[]{id});
        return null;
    }

    public List<StatusMatchCondition> getAllMatchConditions(Project project) {
        ArrayList<StatusMatchCondition> conditions = new ArrayList<StatusMatchCondition>();
        for (Status status : this.findWorkflowStatusObjects(project)) {
            conditions.add(new StatusMatchCondition(status, this.statusConditionHelper));
        }
        return conditions;
    }

    public List<? extends TimeMetricHitCondition> getAllHitConditions(Project project) {
        ArrayList<StatusHitCondition> conditions = new ArrayList<StatusHitCondition>();
        for (Status status : this.findWorkflowStatusObjects(project)) {
            conditions.add(new StatusHitCondition(status, this.statusConditionHelper));
        }
        return conditions;
    }

    private Set<Status> findWorkflowStatusObjects(Project project) {
        HashSet<Status> statuses = new HashSet<Status>();
        AssignableWorkflowScheme schemeForProject = this.workflowSchemeManager.getWorkflowSchemeObj(project);
        Either<AnError, ServiceDeskManagedJiraWorkflow> workflowForProject = this.workflowManager.getWorkflowForName(schemeForProject.getActualDefaultWorkflow());
        if (workflowForProject.isLeft()) {
            workflowForProject.left().forEach(anError -> this.log.warn("Failure to load workflow for project: %s", new Object[]{anError.toString()}));
        } else {
            workflowForProject.right().forEach(wf -> statuses.addAll(wf.workflow().getLinkedStatusObjects()));
        }
        for (IssueType issueType : project.getIssueTypes()) {
            Either<AnError, ServiceDeskManagedJiraWorkflow> workflowForIssueType = this.workflowManager.getWorkflowForProjectAndIssueTypeIds(project.getId(), issueType.getId());
            if (workflowForIssueType.isLeft()) {
                workflowForIssueType.left().forEach(anError -> this.log.warn("Failure to load workflow for issue type %s: %s", new Object[]{issueType.getName(), anError.toString()}));
                continue;
            }
            workflowForIssueType.right().forEach(wf -> statuses.addAll(wf.workflow().getLinkedStatusObjects()));
        }
        return statuses;
    }
}

