/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.sla.condition.factory.InternalTimeMetricCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.StatusConditionHelper;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import java.util.HashMap;
import java.util.Map;

class StatusMatchCondition
implements TimeMetricMatchCondition,
InternalTimeMetricCondition {
    private final StatusConditionHelper helper;
    private Status status;

    StatusMatchCondition(Status status, StatusConditionHelper helper) {
        this.status = status;
        this.helper = helper;
    }

    public String getId() {
        return this.status.getId();
    }

    public String getName(I18nHelper i18n) {
        return i18n.getText(this.getI18nNameKey(), this.status.getNameTranslation(i18n));
    }

    public String getNameHtml(I18nHelper i18n) {
        return this.getName(i18n);
    }

    public MatchEvent evaluate(Issue issue, SLAChangeEvent event) {
        return this.helper.getStatusMatch(issue, this.status);
    }

    public MatchConditionHistory getHistory(Issue issue) {
        return this.helper.getMatchHistory(issue, this.status);
    }

    @Override
    public String getI18nNameKey() {
        return "sd.sla.condition.match.status.set.to";
    }

    @Override
    public Map<String, String> getI18nParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("statusId", this.status.getId());
        return parameters;
    }
}

