/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistoryBuilder;
import com.atlassian.servicedesk.api.sla.condition.HitEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentManager;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CommentConditionHelper {
    private final CommentManager commentManager;
    private final InternalSDCommentManager internalSDCommentManager;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final OutsiderPermissionChecker outsiderPermissionChecker;

    @Autowired
    public CommentConditionHelper(CommentManager commentManager, InternalSDCommentManager internalSDCommentManager, ServiceDeskPermissionService serviceDeskPermissionService, OutsiderPermissionChecker outsiderPermissionChecker) {
        this.commentManager = commentManager;
        this.internalSDCommentManager = internalSDCommentManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.outsiderPermissionChecker = outsiderPermissionChecker;
    }

    HitConditionHistory getCommentedByCustomerHistory(Issue issue) {
        HitConditionHistoryBuilder builder = HitConditionHistoryBuilder.newBuilder();
        List comments = this.commentManager.getComments(issue);
        if (comments != null) {
            for (Comment comment : comments) {
                if (!this.isCommentByCustomer(issue, Optional.of(comment))) continue;
                builder.addHit(new DateTime(comment.getCreated().getTime()));
            }
        }
        return builder.build();
    }

    HitConditionHistory getCommentedForCustomersHistory(Issue issue) {
        HitConditionHistoryBuilder builder = HitConditionHistoryBuilder.newBuilder();
        ApplicationUser reporter = issue.getReporterUser();
        List comments = this.commentManager.getCommentsForUser(issue, reporter);
        if (comments != null) {
            for (Comment comment : comments) {
                ApplicationUser author;
                if (this.internalSDCommentManager.isCommentInternal(comment) || (author = comment.getAuthorApplicationUser()) == null || !this.isCommentedForCustomers(issue, Optional.of(comment))) continue;
                builder.addHit(new DateTime(comment.getCreated().getTime()));
            }
        }
        return builder.build();
    }

    HitEvent isCommentByCustomer(Issue issue, SLAChangeEvent event) {
        Optional comment = event.getComment();
        return this.isCommentByCustomer(issue, comment) ? HitEvent.HIT : HitEvent.NO_HIT;
    }

    private boolean isCommentByCustomer(Issue issue, Optional<Comment> commentOption) {
        return commentOption.filter(comment -> Objects.nonNull(comment.getAuthorApplicationUser())).map(comment -> {
            ApplicationUser author = comment.getAuthorApplicationUser();
            return this.isCustomerOfIssue(author, issue);
        }).orElseGet(Suppliers.alwaysFalse());
    }

    private boolean isCustomerOfIssue(ApplicationUser user, Issue issue) {
        return (Boolean)StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isCustomer(user, issue)).getOr(Suppliers.alwaysFalse());
    }

    HitEvent isCommentedForCustomers(Issue issue, SLAChangeEvent event) {
        Optional comment = event.getComment();
        return this.isCommentedForCustomers(issue, comment) ? HitEvent.HIT : HitEvent.NO_HIT;
    }

    private boolean isCommentedForCustomers(Issue issue, Optional<Comment> commentOption) {
        return commentOption.filter(comment -> Objects.nonNull(comment.getAuthorApplicationUser())).map(comment -> {
            ApplicationUser author = comment.getAuthorApplicationUser();
            return !this.isCustomerOfIssue(author, issue) && !this.outsiderPermissionChecker.isUserAnOutsider(author, issue) && this.isVisibleByCustomer(issue, (Comment)comment);
        }).orElseGet(Suppliers.alwaysFalse());
    }

    @VisibleForTesting
    boolean isVisibleByCustomer(Issue issue, Comment comment) {
        if (this.internalSDCommentManager.isCommentInternal(comment) || this.internalSDCommentManager.isCommentInternalInJIRA(comment.getAuthorApplicationUser(), comment)) {
            return false;
        }
        ApplicationUser reporter = issue.getReporterUser();
        List visibleComments = this.commentManager.getCommentsForUser(issue, reporter);
        if (visibleComments != null) {
            for (Comment visible : visibleComments) {
                if (!visible.getId().equals(comment.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

