/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.internal.sla.condition.factory.AssigneeChangedHitCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.AssigneeConditionHelper;
import com.atlassian.servicedesk.internal.sla.condition.factory.AssigneeFromUnassignedHitCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.AssigneeNotSetMatchCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.AssigneeSetMatchCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.AssigneeToUnassignedHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricConditionFactory;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class AssigneeTimeMetricConditionFactory
implements TimeMetricConditionFactory {
    @Autowired
    private AssigneeConditionHelper helper;
    @Autowired
    private ApplicationProperties applicationProperties;
    private AssigneeSetMatchCondition assigneeSetMatchCondition;
    private AssigneeNotSetMatchCondition assigneeNotSetMatchCondition;
    private AssigneeFromUnassignedHitCondition assigneeFromUnassignedHitCondition;
    private AssigneeToUnassignedHitCondition assigneeToUnassignedHitCondition;
    private AssigneeChangedHitCondition assigneeChangedHitCondition;

    @PostConstruct
    public void onSpringContextStarted() {
        this.assigneeSetMatchCondition = new AssigneeSetMatchCondition(this.helper);
        this.assigneeNotSetMatchCondition = new AssigneeNotSetMatchCondition(this.helper);
        this.assigneeFromUnassignedHitCondition = new AssigneeFromUnassignedHitCondition(this.helper);
        this.assigneeToUnassignedHitCondition = new AssigneeToUnassignedHitCondition(this.helper);
        this.assigneeChangedHitCondition = new AssigneeChangedHitCondition(this.helper);
    }

    public TimeMetricMatchCondition getMatchCondition(String id) {
        if (this.assigneeSetMatchCondition.getId().equals(id)) {
            return this.assigneeSetMatchCondition;
        }
        if (this.assigneeNotSetMatchCondition.getId().equals(id)) {
            return this.assigneeNotSetMatchCondition;
        }
        return null;
    }

    public List<? extends TimeMetricMatchCondition> getAllMatchConditions(Project project) {
        if (this.isUnassignedIssuesEnabled()) {
            return Lists.newArrayList((Object[])new TimeMetricMatchCondition[]{this.assigneeSetMatchCondition, this.assigneeNotSetMatchCondition});
        }
        return Collections.emptyList();
    }

    public List<? extends TimeMetricHitCondition> getAllHitConditions(Project project) {
        if (this.isUnassignedIssuesEnabled()) {
            return Lists.newArrayList((Object[])new TimeMetricHitCondition[]{this.assigneeFromUnassignedHitCondition, this.assigneeToUnassignedHitCondition, this.assigneeChangedHitCondition});
        }
        return Lists.newArrayList((Object[])new AssigneeChangedHitCondition[]{this.assigneeChangedHitCondition});
    }

    public TimeMetricHitCondition getHitCondition(String id) {
        if (this.assigneeFromUnassignedHitCondition.getId().equals(id)) {
            return this.assigneeFromUnassignedHitCondition;
        }
        if (this.assigneeToUnassignedHitCondition.getId().equals(id)) {
            return this.assigneeToUnassignedHitCondition;
        }
        if (this.assigneeChangedHitCondition.getId().equals(id)) {
            return this.assigneeChangedHitCondition;
        }
        return null;
    }

    private boolean isUnassignedIssuesEnabled() {
        return this.applicationProperties.getOption("jira.option.allowunassigned");
    }
}

