/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.HitEvent;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.api.events.ChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.internal.sla.condition.factory.ConditionHelper;
import com.google.common.base.Strings;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class AssigneeConditionHelper
extends ConditionHelper {
    private final ChangeItemBeanUtils changeItemBeanUtils;

    @Autowired
    public AssigneeConditionHelper(ChangeItemBeanUtils changeItemBeanUtils, ChangeHistoryManager changeHistoryManager) {
        super(changeHistoryManager, changeItemBeanUtils);
        this.changeItemBeanUtils = changeItemBeanUtils;
    }

    MatchConditionHistory getMatchHistoryForAssigned(Issue issue) {
        return this.getMatchHistoryForField(issue, issue.getAssigneeId(), "assignee", MatchEvent.MATCH, MatchEvent.INVERSE_MATCH);
    }

    MatchConditionHistory getMatchHistoryForNotAssigned(Issue issue) {
        return this.getMatchHistoryForField(issue, issue.getAssigneeId(), "assignee", MatchEvent.INVERSE_MATCH, MatchEvent.MATCH);
    }

    boolean isAssigned(Issue issue) {
        return issue.getAssigneeUser() != null;
    }

    HitEvent hasBeenAssignedHit(SLAChangeEvent event) {
        if (event.isIssueCreatedEvent()) {
            if (!Strings.isNullOrEmpty((String)event.getIssue().getAssigneeId())) {
                return HitEvent.HIT;
            }
            return HitEvent.NO_HIT;
        }
        Optional changeItem = event.getChangeItemForField("assignee");
        return changeItem.map(changeItemBean -> this.changeItemBeanUtils.extractFieldChangeType(changeItemBean, event.getIssue())).map(changeType -> FieldChangeType.SET.equals(changeType) ? HitEvent.HIT : HitEvent.NO_HIT).orElseGet(() -> HitEvent.NO_HIT);
    }

    HitEvent hasAssigneeBeenClearedHit(SLAChangeEvent event) {
        Optional changeItem = event.getChangeItemForField("assignee");
        return changeItem.map(changeItemBean -> this.changeItemBeanUtils.extractFieldChangeType(changeItemBean, event.getIssue())).map(changeType -> FieldChangeType.CLEAR.equals(changeType) ? HitEvent.HIT : HitEvent.NO_HIT).orElseGet(() -> HitEvent.NO_HIT);
    }

    HitEvent hasAssigneeChangedHit(SLAChangeEvent event) {
        Optional changeItem = event.getChangeItemForField("assignee");
        return changeItem.map(change -> this.changeItemBeanUtils.isChangeToAnotherValue(change, event.getIssue()) ? HitEvent.HIT : HitEvent.NO_HIT).orElseGet(() -> HitEvent.NO_HIT);
    }

    HitConditionHistory getHitHistoryForAssigned(Issue issue) {
        return this.getHitHistoryForFieldValueSet(issue, issue.getAssigneeId(), "assignee");
    }

    HitConditionHistory getHitHistoryForUnassigned(Issue issue) {
        return this.getHitHistoryForFieldValueCleared(issue, "assignee");
    }

    HitConditionHistory getHitHistoryForAssigneeChanged(Issue issue) {
        return this.getHitHistoryForFieldValueChanged(issue, "assignee");
    }
}

