/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.audit;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogEntry;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogManager;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaAuditLogService {
    private final SlaAuditLogManager slaAuditLogManager;
    private final InternalServiceDeskProjectManager projectManager;
    private final ServiceDeskLicenseAndPermissionService permissionService;
    private final UserFactory userFactory;
    private final CommonErrors commonErrors;

    @Autowired
    public SlaAuditLogService(SlaAuditLogManager slaAuditLogManager, InternalServiceDeskProjectManager projectManager, ServiceDeskLicenseAndPermissionService permissionService, UserFactory userFactory, CommonErrors commonErrors) {
        this.slaAuditLogManager = slaAuditLogManager;
        this.projectManager = projectManager;
        this.permissionService = permissionService;
        this.userFactory = userFactory;
        this.commonErrors = commonErrors;
    }

    public io.atlassian.fugue.Either<AnError, Map<Long, String>> retrieveIssueListOfTimeMetric(String projectKey, long timeMetricId, String issueKeySearchString) {
        return this.canAdministerServiceDeskProject(projectKey).map(unit -> this.slaAuditLogManager.retrieveIssueListOfTimeMetric(timeMetricId, issueKeySearchString));
    }

    public io.atlassian.fugue.Either<AnError, List<SlaAuditLogEntry>> retrieveAuditEntries(String projectKey, long timeMetricId, Option<Long> issueId, boolean showGlobal) {
        return this.canAdministerServiceDeskProject(projectKey).map(unit -> this.slaAuditLogManager.retrieveAuditEntries(timeMetricId, issueId, showGlobal));
    }

    private io.atlassian.fugue.Either<AnError, Unit> canAdministerServiceDeskProject(String projectKey) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.projectManager.getProjectByKey(projectKey)).then((user, project) -> this.canAdministerServiceDesk((SDUser)user, (Project)project)).yield((user, project, unit) -> unit);
    }

    private io.atlassian.fugue.Either<AnError, Unit> canAdministerServiceDesk(SDUser user, Project project) {
        if (this.permissionService.canAdministerServiceDesk(user, project)) {
            return io.atlassian.fugue.Either.right((Object)Unit.Unit());
        }
        return io.atlassian.fugue.Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
    }
}

