/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.audit;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogEntry;
import com.atlassian.servicedesk.internal.sla.condition.factory.InternalTimeMetricCondition;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.ThresholdData;
import com.atlassian.servicedesk.internal.sla.model.TimelineEventType;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricCondition;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdExceeded;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaAuditLogDataHelper {
    public static final String STATUS_ID = "statusId";
    private static final String DELETED_METRIC_ID = "metricId";
    private static final String DELETED_METRIC_NAME = "metricName";
    static final String ISSUE_KEY = "issueKey";
    private static final String TIMELINE_EVENT = "timelineEvent";
    private static final String TIMELINE_NAME = "timelineName";
    private static final String TIMELINE_I18N = "timelineI18N";
    private static final String NEXT_TIMED_PROMISED = "nextTimedPromise";
    private static final String PAUSED = "slaOngoingDataPaused";
    private static final String COMPLETED = "slaCompleted";
    private static final String REMAINING_TIME = "slaThresholdRemainingTime";
    private static final String EXCEEDED_THRESHOLDS = "slaExceededThresholds";
    private final I18nHelper i18nHelper;

    @Autowired
    public SlaAuditLogDataHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public Map<String, String> determineExceededEventData(SlaThresholdExceeded exceeded, Issue issue) {
        List thresholdList = exceeded.getThresholds().stream().map(SlaThreshold::getRemainingTime).collect(Collectors.toList());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(EXCEEDED_THRESHOLDS, StringUtils.join(thresholdList, (String)","));
        data.put(ISSUE_KEY, issue.getKey());
        return Collections.unmodifiableMap(data);
    }

    public Map<String, String> determineUnschedulingData(Issue issue) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(ISSUE_KEY, issue.getKey());
        return Collections.unmodifiableMap(data);
    }

    public Map<String, String> determineNextTimedPromiseData(DateTime nextExceedingThresholdTime, Issue issue) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(NEXT_TIMED_PROMISED, String.valueOf(nextExceedingThresholdTime.getMillis()));
        data.put(ISSUE_KEY, issue.getKey());
        return Collections.unmodifiableMap(data);
    }

    public Map<String, String> determineDeletionData(TimeMetric timeMetric) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(DELETED_METRIC_ID, timeMetric.getId().toString());
        data.put(DELETED_METRIC_NAME, timeMetric.getName());
        return Collections.unmodifiableMap(data);
    }

    public Map<String, String> determineIssueEventAuditData(TimelineEventType type, Option<TimeMetricCondition> conditionOption, Issue issue) {
        HashMap<String, String> data = new HashMap<String, String>();
        conditionOption.forEach(condition -> {
            if (condition instanceof InternalTimeMetricCondition) {
                InternalTimeMetricCondition internalCondition = (InternalTimeMetricCondition)condition;
                data.putAll(internalCondition.getI18nParameters());
                data.put(TIMELINE_I18N, internalCondition.getI18nNameKey());
            } else {
                data.put(TIMELINE_NAME, condition.getName(this.i18nHelper));
            }
        });
        data.put(TIMELINE_EVENT, type.name());
        data.put(ISSUE_KEY, issue.getKey());
        return Collections.unmodifiableMap(data);
    }

    public Map<String, String> determineSlaValueData(SLAValue value, Issue issue) {
        HashMap<String, String> data = new HashMap<String, String>();
        OngoingSLAData ongoingSLAData = value.getOngoingSLAData();
        if (ongoingSLAData != null) {
            data.put(PAUSED, String.valueOf(ongoingSLAData.isPaused()));
            ongoingSLAData.getThresholdData().flatMap(ThresholdData::getRemainingTime).forEach(remainingTime -> data.put(REMAINING_TIME, String.valueOf(remainingTime)));
        } else {
            data.put(COMPLETED, String.valueOf(true));
        }
        data.put(ISSUE_KEY, issue.getKey());
        return Collections.unmodifiableMap(data);
    }

    public Option<String> getDeletedMetricName(SlaAuditLogEntry entry) {
        return Option.option((Object)entry.getData().get(DELETED_METRIC_NAME));
    }

    public Option<String> getIssueKey(SlaAuditLogEntry entry) {
        return Option.option((Object)entry.getData().get(ISSUE_KEY));
    }

    public Option<TimelineEventType> getTimelineEvent(SlaAuditLogEntry entry) {
        try {
            return Option.option((Object)entry.getData().get(TIMELINE_EVENT)).map(TimelineEventType::valueOf);
        }
        catch (IllegalArgumentException e) {
            return Option.none();
        }
    }

    public Option<String> getConditionName(SlaAuditLogEntry entry) {
        return Option.option((Object)entry.getData().get(TIMELINE_NAME));
    }

    public Option<String> getConditionI18N(SlaAuditLogEntry entry) {
        return Option.option((Object)entry.getData().get(TIMELINE_I18N));
    }

    public Option<String> getConditionStatusId(SlaAuditLogEntry entry) {
        return Option.option((Object)entry.getData().get(STATUS_ID));
    }

    public Option<String> getNextTimedPromise(SlaAuditLogEntry entry) {
        return Option.option((Object)entry.getData().get(NEXT_TIMED_PROMISED));
    }

    public boolean isCompletedSla(SlaAuditLogEntry entry) {
        return (Boolean)Option.option((Object)entry.getData().get(COMPLETED)).map(Boolean::valueOf).getOrElse((Object)false);
    }

    public boolean isPausedSla(SlaAuditLogEntry entry) {
        return (Boolean)Option.option((Object)entry.getData().get(PAUSED)).map(Boolean::valueOf).getOrElse((Object)false);
    }

    public Option<Long> getRemainingThresholdTime(SlaAuditLogEntry entry) {
        try {
            return Option.option((Object)entry.getData().get(REMAINING_TIME)).map(Long::valueOf);
        }
        catch (NumberFormatException e) {
            return Option.none();
        }
    }

    public Option<List<Long>> getExceededThresholds(SlaAuditLogEntry entry) {
        try {
            return Option.option((Object)entry.getData().get(EXCEEDED_THRESHOLDS)).map(value -> value.split(",")).map(Arrays::asList).map(list -> list.stream().map(Long::valueOf).collect(Collectors.toList()));
        }
        catch (NumberFormatException e) {
            return Option.none();
        }
    }
}

