/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.audit;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogDataHelper;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogEntry;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevelService;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaAuditLogChangeRenderer {
    private final I18nHelper i18nHelper;
    private final SlaAuditLogDataHelper dataHelper;
    private final StatusManager statusManager;
    private final UrgencyLevelService urgencyLevelService;

    @Autowired
    public SlaAuditLogChangeRenderer(I18nHelper i18nHelper, SlaAuditLogDataHelper dataHelper, StatusManager statusManager, UrgencyLevelService urgencyLevelService) {
        this.i18nHelper = i18nHelper;
        this.dataHelper = dataHelper;
        this.statusManager = statusManager;
        this.urgencyLevelService = urgencyLevelService;
    }

    public Option<String> getIssueKey(SlaAuditLogEntry entry) {
        return this.dataHelper.getIssueKey(entry);
    }

    public String render(SlaAuditLogEntry entry, DateTimeFormatter formatter) {
        return this.getOptionValue((Option<String>)entry.getReason().map(reason -> {
            switch (reason) {
                case SLA_CREATED: {
                    return this.i18nHelper.getText("sd.sla.audit.log.sla.created", this.formatSlaValueInformation(entry));
                }
                case SLA_UPDATED: {
                    return this.i18nHelper.getText("sd.sla.audit.log.sla.updated", this.formatSlaValueInformation(entry));
                }
                case SLA_DELETED: {
                    return this.i18nHelper.getText("sd.sla.audit.log.sla.deleted", this.getOptionValue(this.dataHelper.getDeletedMetricName(entry)));
                }
                case CALENDAR_CHANGED: {
                    return this.i18nHelper.getText("sd.sla.audit.log.calendar.changed", this.formatSlaValueInformation(entry));
                }
                case CONSISTENCY_CHECK: {
                    return this.i18nHelper.getText("sd.sla.audit.log.consistency.check", this.formatSlaValueInformation(entry));
                }
                case FORCED_CONSISTENCY_CHECK: {
                    return this.i18nHelper.getText("sd.sla.audit.log.forced.consistency.check", this.formatSlaValueInformation(entry));
                }
                case ISSUE_EVENT: {
                    return this.getIssueEventChange(entry);
                }
                case EXCEEDED_EVENT: {
                    return this.i18nHelper.getText("sd.sla.audit.log.exceeded.event", this.formatExceededThresholds(entry));
                }
                case SCHEDULING_TIMED_PROMISE: {
                    return this.i18nHelper.getText("sd.sla.audit.log.schedule.timed.promise", this.getNextTimedPromiseScheduledTime(entry, formatter));
                }
                case UNSCHEDULING_TIMED_PROMISE: {
                    return this.i18nHelper.getText("sd.sla.audit.log.unschedule.timed.promise");
                }
                case DEFAULT_ISSUE_CREATION: {
                    return this.i18nHelper.getText("sd.sla.audit.log.default.issue.creation", this.formatSlaValueInformation(entry));
                }
                case MOVED_ISSUE_BETWEEN_PROJECTS: {
                    return this.i18nHelper.getText("sd.sla.audit.log.moved.issue", this.formatSlaValueInformation(entry));
                }
                case PROJECT_MIGRATION: {
                    return this.i18nHelper.getText("sd.sla.audit.log.project.migration", this.formatSlaValueInformation(entry));
                }
            }
            throw new RuntimeException("unknown sla audit log reason");
        }));
    }

    private String getIssueEventChange(SlaAuditLogEntry entry) {
        String conditionDetails = (String)this.dataHelper.getConditionI18N(entry).fold(() -> this.getOptionValue(this.dataHelper.getConditionName(entry)), i18n -> this.getI18nTranslation((String)i18n, entry));
        String typeName = this.getOptionValue((Option<String>)this.dataHelper.getTimelineEvent(entry).map(type -> this.i18nHelper.getText("sd.sla.audit.log.condition." + type.name().toLowerCase())));
        return this.i18nHelper.getText("sd.sla.audit.log.issue.event", typeName, conditionDetails);
    }

    private String getI18nTranslation(String i18nKey, SlaAuditLogEntry entry) {
        return (String)this.getStatusName(entry).fold(() -> this.i18nHelper.getText(i18nKey), statusName -> this.i18nHelper.getText(i18nKey, statusName));
    }

    private Option<String> getStatusName(SlaAuditLogEntry entry) {
        return this.dataHelper.getConditionStatusId(entry).flatMap(statusId -> Option.option((Object)this.statusManager.getStatus(statusId))).map(status -> status.getNameTranslation(this.i18nHelper));
    }

    private String getOptionValue(Option<String> option) {
        return (String)option.getOrElse((Object)this.i18nHelper.getText("sd.sla.audit.log.unknown"));
    }

    private String getNextTimedPromiseScheduledTime(SlaAuditLogEntry entry, DateTimeFormatter formatter) {
        return this.getOptionValue((Option<String>)this.dataHelper.getNextTimedPromise(entry).map(Long::valueOf).map(epoch -> this.formatEventTime((long)epoch, formatter)));
    }

    private String formatEventTime(long eventTime, DateTimeFormatter formatter) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(eventTime), formatter.getZone()).format(formatter);
    }

    private String formatSlaValueInformation(SlaAuditLogEntry entry) {
        if (this.dataHelper.isCompletedSla(entry)) {
            return this.i18nHelper.getText("sd.sla.audit.log.sla.value.completed");
        }
        String remainingTime = this.getOptionValue((Option<String>)this.dataHelper.getRemainingThresholdTime(entry).map(this::formatRemainingTime));
        if (this.dataHelper.isPausedSla(entry)) {
            return this.i18nHelper.getText("sd.sla.audit.log.sla.value.paused", remainingTime);
        }
        return this.i18nHelper.getText("sd.sla.audit.log.sla.value.ongoing", remainingTime);
    }

    @VisibleForTesting
    String formatRemainingTime(long time) {
        long absTime = Math.abs(time);
        String formattedAbsoluteTime = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(absTime), TimeUnit.MILLISECONDS.toMinutes(absTime) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(absTime) % TimeUnit.MINUTES.toSeconds(1L));
        if (time < 0L) {
            return "-" + formattedAbsoluteTime;
        }
        return formattedAbsoluteTime;
    }

    private String formatExceededThresholds(SlaAuditLogEntry entry) {
        return (String)this.dataHelper.getExceededThresholds(entry).map(thresholds -> thresholds.stream().map(this::formatThreshold).collect(Collectors.toList())).map(thresholds -> StringUtils.join((Collection)thresholds, (String)", ")).getOr(() -> this.i18nHelper.getText("sd.sla.urgency.unknown"));
    }

    private String formatThreshold(Long exceededThreshold) {
        return (String)Option.option((Object)exceededThreshold).flatMap(threshold -> this.urgencyLevelService.getUrgencyLevelForRemainingTime((long)threshold)).map(level -> this.i18nHelper.getText(level.getKey())).getOr(() -> this.i18nHelper.getText("sd.sla.urgency.unknown"));
    }
}

